<?php
########## Confixx(R) 3.2 Professional ############
####### Copyright SWsoft, Inc. 2004-2006 ##########
##### http://www.swsoft.com - info@swsoft.com #####

include_once( 'auth.php' );
include_once( '../include/class.SQLString.php' );
include_once( '../include/elements/data/class.SetOfRowsData.php' );
include_once( '../include/elements/data/class.HTMLDataField.php' );
include_once( '../include/elements/data/class.TextDataField.php' );
include_once( '../include/elements/data/class.LinkDataField.php' );
include_once( '../include/elements/data/class.OptionsDataField.php' );
include_once( '../include/elements/data/class.CompoundDataField.php' );
include_once( '../include/elements/data/class.CheckDataField.php' );
include_once( '../include/elements/data/class.ButtonData.php' );
include_once( '../include/elements/data/class.PagedTableView.php' );
include_once( '../include/elements/data/class.IconDataField.php' );
include_once( '../include/data_source/class.SQLQuery.php' );
include_once( '../include/data_source/class.CompoundValue.php' );
include_once( '../include/data_source/class.ValueLocale.php' );
include_once( '../include/data_source/class.ValueFromArray.php' );
include_once( '../include/data_source/class.ValueFormated.php' );
include_once( '../include/data_source/class.CallBackValue.php' );
include_once( '../include/data_source/class.ConversedDBValue.php' );
include_once( '../include/data_source/class.DataValue.php' );
include_once( '../include/elements/html/class.CompoundElement.php' );
include_once( '../include/elements/html/class.PPButtonElement.php' );
include_once( '../include/elements/html/class.ButtonURLElement.php' );
include_once( '../include/elements/html/class.SimpleSearchElement.php' );
include_once( '../include/elements/html/class.MainPageElement.php' );
include_once( 'defines.php' );

global $DEBUG;
//$DEBUG=1;

if($DEBUG){
	echo "tools_domains: _POST<br><pre>\n";
	print_r($_POST);
	echo "</pre><hr>\n";
}

db_connect($db_host, $db_user, $db_pass);

$loUser = new SQLString($PHP_AUTH_USER);

$id = safe_query2( " SELECT maxsubdomains, wildcard, cssl, gesperrt, anbieter".
                   " FROM kunden WHERE kunde = ? AND server_id='$ServerID'", $loUser );
$werte = db_fetch_array($id);
$maxsubdomains = $werte['maxsubdomains'];
$wildcard = $werte['wildcard'];
$anbieter = $werte['anbieter'];
$cssl = $werte['cssl'];
$lgGesperrt = $werte['gesperrt'];
db_free_query( $id );

$id = safe_query2( " SELECT COUNT(domain) FROM domains WHERE richtigedomain=0 AND kunde = ? ".
                   " AND server_id='$ServerID'", $loUser );
list($genutztesubdomains) = db_fetch_array( $id );
if ($maxsubdomains != -1) { 
	$freiesubdomains = ($maxsubdomains >= $genutztesubdomains)? $maxsubdomains - $genutztesubdomains: 0; 
} else { 
	$freiesubdomains = -1; 
}
db_free_query( $id );

/**
 * catch domain
 */
$id = safe_query2( " SELECT ip FROM ipadressen WHERE kunde=? ".
									 " AND server_id='$ServerID'", $loUser );
$liExclIP = db_num_rows( $id );
db_free_query( $id );
if( $liExclIP ){
	$id = safe_query2( "SELECT MIN(id), COUNT(catch) FROM domains WHERE kunde=? ".
										 " AND catch=1 AND richtigedomain IN (0,1,2) ".
										 " AND server_id='$ServerID'",
										 $loUser );
	list( $liMinID, $liCnt ) = db_fetch_array( $id, 'N' );
	db_free_query( $id );
  if( $liCnt != 1 ){
    // unset spare catch
    if( $liCnt > 1 ){			
      safe_query2( " UPDATE domains SET catch=0 WHERE id != $liMin AND catch=1 ".
									 " AND kunde=? AND server_id='$ServerID'",
									 $loUser );
    }else{ 
      //set first catch
			$id = safe_query2( "SELECT MIN(id) FROM domains WHERE kunde=? ".
												 " AND richtigedomain IN (0,1,2) ".
												 " AND server_id='$ServerID'",
												 $loUser );
			list( $liMinID ) = db_fetch_array( $id, 'N' );
			db_free_query( $id );
			if( $liMinID ){
				safe_query2( "UPDATE domains SET catch=1 WHERE id=$liMinID ".
										 " AND kunde=? AND server_id='$ServerID'",
										 $loUser );
			}
		}
	}
 }


$loRes = new SQLString($anbieter);
if( istleer( $status ) ){
  $status = 0;
}

switch( $action ){
 case 'delete':
	 $action = '';
	 db_close();
	 include('tools_domains_loeschen.php');
	 exit;
	 break;
 case 'ssl_redir':
 case 'ssl':
	 $action = '';
	 if( $cssl ) {
		 $loID = new SQLInteger($domain_id);
		 $id = safe_query2( "SELECT domain FROM domains WHERE id=? AND server_id='$ServerID'", $loID );
		 list($domain) = db_fetch_array($id);
		 if( $domain ) {
       $lcSQL = " UPDATE domains SET cssl=? ".( $status == 1 ? "" : ", httpd = 2 " ).
                " WHERE id=? AND kunde=? AND anbieter=? AND server_id='$ServerID'";
			 safe_query2( $lcSQL, new SQLInteger($ssl), $loID, $loUser, $loRes );

			 safe_query2( "UPDATE kunden SET httpd=1 WHERE kunde=? AND server_id='$ServerID'", $loUser);
			 safe_query2( "UPDATE allgemein SET httpd=1 WHERE server_id='$ServerID'" );

			 $fehlertext = ltext("todo_ssl_changed",array($domain));
		 } 
		 db_free_query( $id );
	 }
	 break;
 case 'catch':
	 if( $liExclIP ){
		 $loID = new SQLInteger($domain_id);

		 // switch off catch
		 safe_query2( "UPDATE domains SET catch=0 WHERE catch=1 ".
									" AND kunde=? AND server_id='$ServerID'",
									$loUser );

		 // switch on catch
     safe_query2( "UPDATE domains SET catch=1".( $status == 1 ? "" : ", httpd = 2 " ).
                  " WHERE id=? AND kunde=?  AND server_id='$ServerID'",
									$loID, $loUser );

		 safe_query2( "UPDATE kunden SET httpd=1 WHERE kunde=? AND server_id='$ServerID'", $loUser);
		 safe_query2( "UPDATE allgemein SET httpd=1 WHERE server_id='$ServerID'" );

		 $fehlertext = ltext( 'todo_catch_changed', array( $domain ) );
	 }

	 break;
	 /*
 case 'new':
	 $action = '';
	 break;
	 */
 case 'change':
	 $action='';
	 db_close();
	 include('tools_domains_aendern.php');
	 exit;
	 break;
}


/**
 * add new subdomain
 */
if (($freiesubdomains > 0) || ($freiesubdomains == -1)) {

	$loNewSubDomain = new SetOfRowsData();

	$loRow =& $loNewSubDomain->AppendHeaderRow( new HTMLDataField( ltext( 'todo_cell_subdomain' ) ),
																							new HTMLDataField( ltext( 'todo_cell_domain' ) ),
																							new HTMLDataField( ltext( 'todo_cell_path' ))
																							);
	if( $cssl ) {
		$loRow->AppendFields( new HTMLDataField( ltext( 'todo_cell_ssl' )),
													new HTMLDataField( ltext( 'todo_cell_ssl_redirect' )) 
													);
	}
	$loDomains = new OptionsDataField( array(), '', 'domain');
  $lcSQL = " SELECT domain, domain FROM domains WHERE".
           " (richtigedomain=1 OR richtigedomain=7) AND ".
           " kunde =".$loUser->SQL()." AND anbieter=".$loRes->SQL().
           " AND server_id='$ServerID' ORDER BY domain";
	$loDomains->AppendOptionsFromSQL( $lcSQL );
	
	$loRow =& $loNewSubDomain->AppendRow( new TextDataField( '', 'prefix' ),
																				$loDomains,
																				new TextDataField( '/', 'pfad' )
																				);
	if( $cssl ){
		$loRow->AppendFields( new CheckDataField( 1, 
																							'cssl', 
																							array( 'onclick' => "javascript:toggleItem('cssl_redirect',!this.checked)"
																										 ),
																							array( 'align' => 'center') 
																							),
													new CheckDataField( 1, 
																							'cssl_redirect', 
																							array( 'id' => 'cssl_redirect'),
																							array( 'align' => 'center') 
																							) );
  } 

	$loNewSubDomain->AppendButton( ltext('todo_btn_save'), "javascript:doChange()", cc_IDOk );		
	$loNewSubDomain->AppendHidden( new TextDataField('tools_domains.php','cur_page') );
	$loNewSubDomain->AppendHidden( new TextDataField('new','action') );
  $loAppendForm = $loNewSubDomain->GetInputPresentation( array( "action" => "tools_domains_neu.php", 
                                                                "method" => "post", "name"=>"append_new" ), 
																												 ltext("todo_subtitle3"));

	$loAppendForm->AppendHelp(ltext("todo_desc3"));
	if ( $wildcard ) {
		$loAppendForm->AppendHelp(ltext("todo_desc4"));
	}

	$liFormIndex = 1;
} else {
	$liFormIndex = 0;
}

/**
 * list of domains
 */
initPagingSettings( $_POST, array( 'domain_to_search' => $domain_to_search ) );

$lcSQL = "SELECT COUNT(*) FROM domains WHERE kunde = ? AND richtigedomain IN (0,1,2,7) AND server_id='$ServerID'";
$res = safe_query2( $lcSQL, $loUser );
list( $total_number ) = db_fetch_array( $res );
db_free_query( $res );

$listFormIndex = 1;
	
if (!isset($order)) {
	$order = 'domain';
}
if (!isset($direction)) {
	$direction = 'asc';
}
switch( $order ){
 case 'domain':
	 $lcSqlOrder .= " ORDER BY domain";
	 if( $direction == 'desc' ){
		 $lcSqlOrder .= " DESC";
	 }
	 break;
 case 'state':
	 $lcSqlOrder .= " ORDER BY httpd";
	 if( $direction == 'desc' ){
		 $lcSqlOrder .= " DESC";
	 }
	 break;
case 'redirect':
	 $lcSqlOrder .= " ORDER BY pfad";
	 if( $direction == 'desc' ){
		 $lcSqlOrder .= " DESC";
	 }
	 break;
case 'ssl':
	 $lcSqlOrder .= " ORDER BY cssl";
	 if( $direction == 'desc' ){
		 $lcSqlOrder .= " DESC";
	 }
	 break;
 	default:
	$lcSqlOrder .= " ORDER BY domain";
	 if( $direction == 'desc' ){
		 $lcSqlOrder .= " DESC";
	 }
}
	
	
if( isset($domain_to_search)&&strlen($domain_to_search) ) {
	$loDomain = new SQLValue( $domain_to_search, 'S' );
	$lcSQL = "SELECT COUNT(*) FROM domains WHERE (domain LIKE '%?%' OR pfad LIKE '%?%')".
	         " AND kunde = ? AND anbieter = ? AND richtigedomain IN (0,1,2,7) AND server_id='$ServerID'";
	$loQuery = new SQLQuery( $lcSQL, array( $loDomain,$loDomain, new SQLValue($PHP_AUTH_USER,'C'), new SQLValue($anbieter,'C') ) );

	$loQuery->doQuery();
	list($total_number) = $loQuery->fetchArray('N');

	$lcSQL = "SELECT * FROM domains WHERE (domain LIKE '%?%' OR pfad LIKE '%?%')".
	        " AND kunde = ? AND anbieter = ? AND richtigedomain IN (0,1,2,7) AND server_id='$ServerID'".$lcSqlOrder;
	$loQuery->Query( $lcSQL );

} else {
	$lcSQL = "SELECT * FROM domains WHERE kunde = ? AND anbieter = ?".
	        " AND richtigedomain IN (0,1,2,7) AND server_id='$ServerID'".$lcSqlOrder;
	$loQuery = new SQLQuery( $lcSQL, array( new SQLValue($PHP_AUTH_USER,'C'), new SQLValue($anbieter,'C') ) );
}

$loDS = new ConversedDBValue( $loQuery, $page_size, $start_index - 1 );
$loDS->TotalNumber( $total_number );

$loTemplate = new CompoundValue( new ValueFromArray( 'httpd' ),
																 new CompoundValue (
																										new ValueFromArray( 'httpd'),
																										new ValueFromArray( 'domain'),
																										new ValueFromArray( 'richtigedomain')
																										),
                                 new CompoundValue( new ValueFromArray( 'pfad'),
                                                    new ValueFromArray( 'richtigedomain') )
																 );
$laContent =array();

$lcDirIcon = ( $direction=='desc' ) ? cc_DescIcon : cc_AscIcon;
$lcNewDir = ( $direction=='desc' ) ? 'asc' : 'desc';

if ( $order == 'domain' ) {
	$laContent['domain'] = new CompoundDataField( new HTMLDataField( ltext( 'todo_cell_domain' )),
																							 new IconDataField( $lcDirIcon ) );
	$laContent['domain']->SetSeparator('');
} else {
	$laContent['domain'] = new HTMlDataField( ltext( 'todo_cell_domain' ) );
}
if ( $order == 'state' ) {
	$laContent['state'] = new CompoundDataField( new HTMLDataField( ltext( 'todo_cell_state' )),
																							 new IconDataField( $lcDirIcon ) );
	$laContent['state']->SetSeparator('');
} else {
	$laContent['state'] = new HTMlDataField( ltext( 'todo_cell_state' ) );
}
if( $order == 'redirect' ){
	$laContent['redirect'] = new CompoundDataField( new HTMLDataField( ltext( 'todo_cell_redirect' )),
																							 new IconDataField( $lcDirIcon ) );
	$laContent['redirect']->SetSeparator('');
} else {
	$laContent['redirect'] = new HTMlDataField( ltext( 'todo_cell_redirect' ) );
}
if( $order == 'ssl' ){
	$laContent['ssl'] = new CompoundDataField( new HTMLDataField( ltext( 'todo_cell_ssl' )),
																							 new IconDataField( $lcDirIcon ) );
	$laContent['ssl']->SetSeparator('');
} else {
	$laContent['ssl'] = new HTMlDataField( ltext( 'todo_cell_ssl' ) );
}


$loTitle = new CompoundValue( new DataValue( 'state', 
																						 NULL, 
																						 new LinkDataField( "javascript:setValue('order','state',$listFormIndex);".
																																"setValue('start_index',1,$listFormIndex);".
																																"submitForm('direction','$lcNewDir',$listFormIndex)",
																																'',
																																array(),
																																$laContent['state']
																																) ),
															new DataValue( 'domain', 
																						 NULL, 
																						 new LinkDataField( "javascript:setValue('order','domain',$listFormIndex);".
																																"setValue('start_index',1,$listFormIndex);".
																																"submitForm('direction','$lcNewDir',$listFormIndex)",
																																'',
																																array(),
																																$laContent['domain']
																																) ),
															new DataValue( 'redirect', 
																						 NULL, 
																						 new LinkDataField( "javascript:setValue('order','redirect',$listFormIndex);".
																																"setValue('start_index',1,$listFormIndex);".
																																"submitForm('direction','$lcNewDir',$listFormIndex)",
																																'',
																																array(),
																																$laContent['redirect']
																																) )
				
															);
$laWidths = array( '30%', '30%'); 

if( $liExclIP ){
	$loTemplate->addValue( new ValueFromArray( 'catch'),
												 new ValueFromArray( 'id'),
												 new ValueFromArray( 'domain'),
												 new ValueFromArray( 'httpd'),
												 new ValueFromArray( 'richtigedomain')
												 );
	$loTitle->addValue( new ValueLocale( 'todo_cell_catch' )	);
 }


if( $cssl ){
	$loTemplate->addValue( new ValueFromArray( 'cssl' ), 
												 new ValueFromArray( 'id'), 
												 new ValueFromArray( 'domain'),
												 new ValueFromArray( 'httpd'),
												 new ValueFromArray( 'richtigedomain') ); /* ssl */
	$loTemplate->addValue( new ValueFromArray( 'cssl' ), 
												 new ValueFromArray( 'id'),
												 new ValueFromArray( 'domain'),
												 new ValueFromArray( 'httpd'),
												 new ValueFromArray( 'richtigedomain') ); /* ssl-redirect */

	$loTitle->addValue( new DataValue( 'ssl', 
																						 NULL, 
																						 new LinkDataField( "javascript:setValue('order','ssl',$listFormIndex);".
																																"setValue('start_index',1,$listFormIndex);".
																																"submitForm('direction','$lcNewDir',$listFormIndex)",
																																'',
																																array(),
																																$laContent['ssl']
																																) ) );
	$loTitle->addValue( new ValueLocale('todo_cell_ssl_redirect') );

	$laWidths = array( '5%','30%','28%','7%','15%','10%','5%' );

} else {
	$laWidths = array( '5%','40%','40%','10%','5%' );

}
$loTemplate->addValue( new ValueFromArray( 'id' ),
                       new ValueFromArray( 'httpd'), 
                       new ValueFromArray( 'richtigedomain') ); /* change */
$loTemplate->addValue( new ValueFromArray( 'richtigedomain' ), new ValueFromArray( 'id') ); /* delete */

$loCheckBox = new CheckDataField( 1, 'selectAll' );
$loCheckBox->Attribute('onclick', "javascript:checkedAll('domain_ids', this.checked, $liFormIndex)");
$loCheckBox->SetParentAttributes(array('align'=>'center'));
$loSelValue = new DataValue( 'selectAll', 1, $loCheckBox );
$loSelValue->setTypeOfPresentation( 'Input' );

$loTitle->addValue( new ValueLocale('ll_change') );
$loTitle->addValue( $loSelValue );

$loDS->Template( $loTemplate );

/**
 * call back functions to make visible objects
 */
function &makeLink( $poSrc ){
	list( $lcHttpd,	$lcSrc, $liDomType )  = $poSrc->listValue();
  
  if( $lcHttpd == 1 || $liDomType == 7 ){
		$loLink = new HTMLDataField( ($liDomType == 7) ? '<i>'.$lcSrc.'</i>' : $lcSrc, '', array(), array( 'align' => 'left' ) );
	}	elseif ( strpos( $lcSrc, '*' ) === FALSE ) {
		$loLink = new LinkDataField( "http://".$lcSrc, '', array(), $lcSrc );
		$loLink->SetAttributes (array( 'target' => 'show_domain' ) );
		$loLink->SetParentAttributes (array( 'align' => 'left' ) );	
	} else {
		$loLink = new HTMLDataField( $lcSrc, '', array(), array( 'align' => 'left' ) );
	}
	return $loLink;
}
$gcOk = ltext('ll_state_ok');
$gcNew = ltext('ll_state_new');
$gcProgress = ltext('ll_state_process');
$gcLocked = ltext('ll_state_locked');

function makeStatus( $poSrc ){
		global $confixx_interface_version, $gcNew, $gcOk, $lgGesperrt, $gcLocked,$gcProgress;
		
		switch( $poSrc ){
		case 1:
			$lcTitle = $gcNew;
			$lcIcon = cc_StateNewIcon;
			$lcIconText = $gcNew;
			break;
		case 2:
			$lcTitle = $gcProgress;
			$lcIcon = cc_StateProgressIcon;
			$lcIconText = $gcProgress;
			break;
		case 0:
			$lcTitle = $gcOk;
			$lcIcon = cc_StateOkIcon;
			$lcIconText = $gcOk;
			break;
		default:
			$lcTitle = $gcOk;
			$lcIcon = cc_StateOkIcon;
			$lcIconText = $gcOk;
		}
		if ($lgGesperrt) {
			$lcTitle = $gcLocked;
			$lcIcon = cc_LockedIcon;
			$lcIconText = $gcLocked;
		}
			
	if ($confixx_interface_version == 'powp') {
		$loIcon = new IconDataField( $lcIcon, 
																 array( 'alt' => $lcTitle, 'title' => $lcTitle ), 
																 array( 'align'=>'center') );
	} else {
		$loIcon = new HTMLDataField( $lcIconText, 
																 array( 'alt' => $lcTitle, 'title' => $lcTitle ), 
																 array( 'align'=>'center') );
	}
		return $loIcon;
}

$gcSwitchOnCatch = ltext('todo_catch_switch_on');
$gcSwitchOffCatch = ltext('todo_catch_switch_off');

$gcTitleOn = ltext('ll_on');
$gcTitleOff = ltext('ll_off');

function &makeCatchStatus( &$poSrc ){
	global $gcSwitchOnCatch, $gcSwitchOffCatch;
	global $gcTitleOn, $gcTitleOff; 
	global $liFormIndex, $confixx_interface_version;

  list( $liCatch, $liID, $lcDomain, $liStatus, $liType ) = $poSrc->listValue();

  // shared domain
  if( $liType == 7){
    return new HTMLDataField('');
  }

	if( $liCatch ){
		$lcIcon = cc_CatchOnIcon;
		$lcIconText = $gcTitleOn;
		$lcTitle = $gcSwitchOffCatch;
		$liCatch = 0;
	}else{
		$lcIcon = cc_CatchOffIcon;
		$lcIconText = $gcTitleOff;
		$lcTitle = $gcSwitchOnCatch;
		$liCatch = 1;
	}

	$loLink = new LinkDataField( "javascript:setValue('domain_id',$liID,$liFormIndex);".
															 "setValue('catch',$liCatch,$liFormIndex);".
															 "setValue('status',$liStatus,$liFormIndex);".
															 "submitForm('action','catch',$liFormIndex)", 
															 '', 
															 array(), 
															 ( ( $confixx_interface_version == 'powp' )?
																 new IconDataField( $lcIcon ):
																 new  HTMLDataField( $lcIconText )
																 )
															 );
	
	$loLink->AppendAttributes( array( 'title' => $lcTitle ) );
	$loLink->AppendParentAttributes( array( 'align' => 'center' ) );

	return $loLink;
}


$gcSwitchOnSSL = ltext('todo_ssl_switch_on');
$gcSwitchOffSSL = ltext('todo_ssl_switch_off');

function &makeSslStatus( &$poSrc ){
	global $gcSwitchOnSSL, $gcSwitchOffSSL;
	global $gcTitleOn, $gcTitleOff; 
	global $liFormIndex, $confixx_interface_version;
	
  list( $liSsl, $liID, $lcDomain, $liStatus, $liType ) = $poSrc->listValue();

  // shared domain
  if( $liType == 7 ){
    return new HTMLDataField('');
  }

	$lcIconText = '';
	if( $liSsl ) {
		$lcIcon = cc_OnSSLIcon;
		$lcIconText = $gcTitleOn;
		$lcTitle = $gcSwitchOffSSL;
		$liNewSsl = 0;
	} else {
		$lcIcon = cc_OffSSLIcon;
		$lcIconText = $gcTitleOff;;
		$lcTitle = $gcSwitchOnSSL;
		$liNewSsl = 1;
	}
	if( strpos( $lcDomain, '*' ) === FALSE ) {
		$loLink = new LinkDataField( "javascript:setValue('domain_id',$liID,$liFormIndex);".
																 "setValue('ssl',$liNewSsl,$liFormIndex);".
  															 "setValue('status',$liStatus,$liFormIndex);".
																 "submitForm('action','ssl',$liFormIndex)", 
																 '', 
																 array(), 
																 ($confixx_interface_version == 'powp')?
																 new IconDataField( $lcIcon ):
																 new  HTMLDataField($lcIconText));
	
		$loLink->AppendAttributes( array( 'title' => $lcTitle ) );
		$loLink->AppendParentAttributes( array( 'align' => 'center' ) );

	} else {
		$loLink = new HTMLDataField('&nbsp;');
	}
	return $loLink;

}

$gcSwitchOnSSLRedir = ltext('todo_ssl_switch_on_redir');
$gcSwitchOffSSLRedir = ltext('todo_ssl_switch_off_redir');

function &makeSslRedirect( &$poSrc ){
	global $gcSwitchOnSSLRedir, $gcSwitchOffSSLRedir, $confixx_interface_version;
	global $liFormIndex;
	list( $liSsl, $liID, $lcDomain, $liStatus, $liType ) = $poSrc->listValue();
  
  // shared domain
  if( $liType == 7 ){
    return new HTMLDataField('');
  }

	$lcIconText = '';
	switch($liSsl){
	case 2:
		$lcIcon = cc_OnSSLRedirIcon;
		$lcIconText = ltext('ll_on');
		$liNewSsl = 1;
		$lcTitle = $gcSwitchOffSSLRedir;
		break;
	case 1:
		$lcIcon = cc_OffSSLRedirIcon;
		$lcIconText = ltext('ll_off');
		$liNewSsl = 2;
		$lcTitle = $gcSwitchOnSSLRedir;
		break;
	default:
		$liNewSsl = 0;
	}

	if( $liNewSsl && ( strpos( $lcDomain, '*' ) === FALSE ) ) {
														
		$loLink = new LinkDataField( "javascript:setValue('domain_id',$liID,$liFormIndex);".
																 "setValue('ssl',$liNewSsl,$liFormIndex);".
  															 "setValue('status',$liStatus,$liFormIndex);".
																 "submitForm('action','ssl',$liFormIndex)", 
																 '', 
																 array(), 
																($confixx_interface_version == 'powp')?
																 new IconDataField( $lcIcon ):
																 new  HTMLDataField($lcIconText));
	
		$loLink->AppendAttributes( array( 'title' => $lcTitle ) );
		$loLink->AppendParentAttributes( array( 'align' => 'center' ) );

	} else {
		$loLink = new HTMLDataField( '&nbsp;' );
	}
	return $loLink;

}

function makePath( &$poSrc ) { 
  list( $lcPath, $liType ) = $poSrc->listValue();

  if( $liType ==7 ){
    $loCell = new HTMLDataField('');
  }else{
    $loCell = new HTMLDataField( $lcPath );
  }
	return $loCell;

}

function &makeAction( &$poSrc ) { 
	global $liFormIndex,$confixx_interface_version;
	$lcText = ltext('ll_change');
	
	list( $liID, $liStatus, $liType ) = $poSrc->listValue();
  if( $liType ==7 ){
    $loActions = new HTMLDataField('');
  }else{
    $loActions = new LinkDataField( "javascript:setValue('domain_id','$liID',$liFormIndex);".
                                    "setValue('cur_page','tools_domains_aendern.php',$liFormIndex);".
                                    "setValue('status',$liStatus,$liFormIndex);".
                                    "submitForm('action','change',$liFormIndex)", 
                                    '', 
                                    array(), 
                                    ($confixx_interface_version == 'powp') ? new IconDataField( cc_ChangeIcon ):$lcText);
    $loActions->Attribute( 'title', ltext('ll_change')  );
    $loActions->ParentAttribute( 'align','center');
  }
	return $loActions;

}

function makeSelect( &$poSrc ){

	$loType =& $poSrc->Value(0);
	$liType =(int)$loType->Value();
	
	if( $liType > 0 ) { /* richtigedomain > 0 */
		$loCheckBox = new HTMLDataField('');

	} else { /* sub-domain */
		$loID =& $poSrc->Value(1);
		$loCheckBox = new CheckDataField( $loID->Value(), 'domain_ids[]');
		$loCheckBox->ParentAttribute('align','center');
	}
	//return $loCheckBox;
	return array( $loCheckBox->GetInputPresentation(), array('align'=>'center'));
}



$loConv = new CompoundValue(new ValueFormated( 'httpd', NULL, 'makeStatus'), 
														new ValueFormated( 'domain', NULL, 'makeLink'), 
														new ValueFormated( 'path', NULL, 'makePath') 
														);
if( $liExclIP ){
	$loConv->addValue( new ValueFormated( 'catch', NULL, 'makeCatchStatus') );
 }

if( $cssl ){
	$loConv->addValue( new ValueFormated( 'ssl', NULL, 'makeSslStatus') );
	$loConv->addValue( new ValueFormated( 'ssl_redirect', NULL, 'makeSslRedirect') );
}
$loConv->addValue( new ValueFormated( 'action', NULL, 'makeAction' ) );
$loConv->addValue( new ValueFormated( 'select', NULL, 'makeSelect' ) );

$loDS->Conversion( $loConv );

$loDS->doQuery();

$loPTV = new PagedTableView( $loDS, $total_number );

$loPTV->Title( $loTitle	);
$loPTV->Widths( $laWidths );
$loPTV->setParameter( 'menu_node_id', $menu_node_id );
$loPTV->setParameter( 'cur_page', $cur_page?$cur_page:'' );
$loPTV->setParameter( 'head_text', $head_text );

$loPTV->setParameter( 'action', '' );
$loPTV->setParameter( 'domain_id', '' );
$loPTV->setParameter( 'domain', '' );
$loPTV->setParameter( 'ssl', '' );
$loPTV->setParameter( 'catch', '' );
$loPTV->setParameter( 'status', '' );
$loPTV->setParameter( 'order', $order );
$loPTV->setParameter( 'direction', $direction );

$loPTV->Anchor( 'list' );
$loPTV->FormIndex($liFormIndex);

if (isset($domain_to_search)&&strlen($domain_to_search)) {
	$loPTV->NoItemsMessage(ltext('ll_empty_search'));
}	else {
	$loPTV->NoItemsMessage(ltext('ll_empty_list'));
}

$tbl = $loPTV->GetOutputPresentation( array( 'action' => 'tools_domains.php#list',
																						 'name' => 'list_domains' ), 
																			ltext( "todo_title" ) );

$dsSearch = new CompoundValue( new ValueFromArray( 'domain_to_search', $domain_to_search ),
															 new ValueLocale( 'll_search' ),
															 new ValueLocale( 'll_show_all' )
															 );

$loSearch = new SimpleSearchElement( array(), 
																		 new InputTextElement( array( 'name' => 'domain_to_search', 
																																	'size' => '16',
																																	'value' => $domain_to_search,
																																	'MAXLENGTH'=> '32' )
																													 ) 
																		 );

$loGroup = new DivElement(array('class'=>'buttons'));
	

$loSearch->appendElement( new PPButtonElement( '', 
																							 "javascript:submitForm('start_index',1,$liFormIndex)", 
																							 'bid-search' 
																							 )
													);
$loSearch->appendElement( new PPButtonElement( '', 
																							 "javascript:setValue('domain_to_search','',$liFormIndex);
																							 submitForm('start_index',1,$liFormIndex)", 
																							 'bid-show-all'
																							 ) 
																							 
																							 
													);

$head_text = ltext('ll_delete');
$loGroup->AppendToContent( new PPButtonElement( $head_text,
																								"javascript:setValue('menu_node_id','delete_dom',$liFormIndex);".
																								"setValue('cur_page','tools_domains_loeschen.php',$liFormIndex);".
																								"setValue('head_text','$head_text',$liFormIndex);".
																								"submitForm('action','delete',$liFormIndex)",
																								'bid-delete' 
																								)
													 );

	
$loSearch->setDataSource( $dsSearch, array( 'domain_to_search' => $domains_to_search ) );

if ((isset($domain_to_search)&&strlen($domain_to_search))||$total_number>0) {
	$tbl->setSearchElement( $loSearch );
}
if ($total_number>0) {
	$tbl->setGroupActionElement( $loGroup );
}

$tbl->updateBodyContent();

	$page = new MainPageElement( $loAppendForm, $tbl ); 
$page->OutputHTML( array( '../../js/paged_form.js' ));
/* -------------------- end HTML -------------------- */

db_close();
?>
