<?php
########## Confixx(R) 3.2 Professional ############
####### Copyright SWsoft, Inc. 2004-2005 ##########
#### http://www.swsoft.com - info@swsoft.com ####

include_once( 'auth.php' );
include_once( '../include/elements/data/class.SetOfRowsData.php' );
include_once( '../include/elements/data/class.HTMLDataField.php' );
include_once( '../include/elements/data/class.TextDataField.php' );
include_once( '../include/elements/data/class.LinkDataField.php' );
include_once( '../include/elements/data/class.PasswordDataField.php' );
include_once( '../include/elements/html/class.MainPageElement.php' );
include_once( '../include/class.User.php' );

db_connect($db_host, $db_user, $db_pass);

$loConfixxUser = new User( $PHP_AUTH_USER, $ServerID );

if( ! $loConfixxUser->isServiceEnabled( 'password_protect' ) ){
  $fehlertext = ltext( 'service_is_disabled' );
  include 'allgemein_start.php';
  exit;
}


$loUser = new SQLString( $PHP_AUTH_USER );
$id = safe_query2( "SELECT pwschutz FROM kunden WHERE kunde = ? AND server_id='$ServerID'",
									 $loUser );
list( $skpwschutz ) = db_fetch_array( $id, 'N' );
db_free_query( $id );

if( isset( $ident ) ){
  $id = safe_query2( "SELECT * FROM pwschutz WHERE ident = ? AND kunde = ? AND server_id='$ServerID'",
                      new SQLInteger( $ident ), $loUser ); 
} else { 
  $id = safe_query2( "SELECT * FROM pwschutz WHERE pfad = ? AND kunde = ? AND server_id='$ServerID'", 
                     new SQLString( $pfad ), $loUser );
}

$werte = db_fetch_array( $id, 'A' );
$bereich = $werte['bereich'];
$ident = $werte['ident'];
$pfad = $werte['pfad'];
db_free_query( $id );

/**
 * "Information about the protected directory" form
 */
$dirform = new SetOfRowsData();
$dirform->AppendRow( new HTMLDataField( ltext('topwae_cell_dir' ) ),
										 new TextDataField( $pfad, 'pfad' ) );
$dirform->AppendRow( new HTMLDataField( ltext('topwae_cell_area' ) ), 
										 new TextDataField( $bereich, 'bereich' ) );
$dirform->AppendRow( new HTMLDataField( '&nbsp;' ),
										 new ButtonData( ltext('topwae_btn_change'), 'javascript:doChange()', cc_IDOk ) );
$dirform->AppendHidden( new TextDataField( $ident, 'ident' ) );
$dirform_page = $dirform->GetInputPresentation( array( 'action' => 'tools_pwschutz_aendern2.php', 
                                                       'method' => 'post', 
                                                       'name' => 'form1' ),
																								ltext( 'topwae_subtitle1' ) );

$id = safe_query2( "SELECT * FROM users WHERE parent = ? AND kunde = ? ".
									 " AND server_id='$ServerID' ORDER BY login", 
                   new SQLInteger( $ident ), 
                   $loUser );
if( db_num_rows( $id ) > 0 ){
  /**
   * "Users who have access to this directory" form
   */
	$userform = new SetOfRowsData();
	$userform->AppendHeaderRow( new HTMLDataField(ltext('topwae_cell_user')),
															new HTMLDataField(ltext('topwae_cell_action')),
															new HTMLDataField(ltext('topwae_cell_action')));

	while( $werte = db_fetch_array( $id, 'A' ) ){
		$login2 = $werte['login'];
		$ident2 = $werte['ident'];
	
		$userform->AppendRow(new HTMLDataField( $login2 ), 
		                     new LinkDataField( 'tools_pwschutz_pwaendern.php', 
                                            '', array( 'ident' => $ident2, 
                                                       'parent'=> $ident), 
                                            ltext( 'topwae_link_change') ),
           							 new LinkDataField( 'tools_pwschutz_loeschen.php', 
                                            '', array( 'ident' => $ident2, 
                                                       'parent' => $ident ), 
                                            ltext('topwae_link_del') ) );
		$userform_page = $userform->GetOutputPresentation( ltext('topwae_subtitle2') );
	}
}
db_free_query( $id );

/**
 * "Add new user" form
 */
$newuserform = new SetOfRowsData();
$newuserform->AppendRow( new HTMLDataField( ltext('topwae_cell_login' ) ),
												 new TextDataField( $login, 'login' ) );
$newuserform->AppendRow( new HTMLDataField( ltext('topwae_cell_pw1' ) ),
												 new PasswordDataField( '', 'pass1' ) );
$newuserform->AppendRow( new HTMLDataField( ltext('topwae_cell_pw2' ) ),
												 new PasswordDataField( '', 'pass2' ) );
$newuserform->AppendRow( new HTMLDataField( '&nbsp;' ),
												 new ButtonData( ltext('topwae_btn_new'), 'javascript:doChange(1)', cc_IDAdd ) );

$newuserform->AppendHidden( new TextDataField( $ident, 'ident' ) );
$newuserform->AppendHidden( new TextDataField( $pfad, 'pfad' ) );
$newuserform_page = $newuserform->GetInputPresentation( array( 'action' => 'tools_pwschutz_neubenutzer.php', 
                                                               'method' => 'post', 
                                                               'name' => 'form2' ), 
                                                        ltext('topwae_subtitle3' ) );
/**
 * "Remove password protection for this directory" form
 */
$delform = new SetOfRowsData();
$delform->AppendButton( ltext('topwae_btn_del'), 'javascript:doChange(2)',cc_IDDelete );
$delform->AppendHidden( new TextDataField( $ident, 'ident' ) );
$delform->AppendHidden( new TextDataField( $pfad, 'pfad2' ) );
$delform_page = $delform->GetInputPresentation( array( 'action' => 'tools_pwschutz_aufheben.php', 
                                                       'method' => 'post', 
                                                       'name' => 'form3' ), 
                                                ltext('topwae_subtitle4' ) );

if( $userform_page ) 
  $page = new MainPageElement( $dirform_page, $userform_page, $newuserform_page, $delform_page );
else 
  $page = new MainPageElement( $dirform_page, $newuserform_page, $delform_page );

$page->OutputHTML( js_f_call_help('', 'topwae_title') );

db_close();
?>
