<?php
########## Confixx(R) 3.2 Professional ############
####### Copyright SWsoft, Inc. 2004-2005 ##########
##### http://www.swsoft.com - info@swsoft.com #####

include_once( 'auth.php' );
include_once( 'defines.php' );
include_once( '../include/data_source/class.SQLQuery.php' );
include_once( '../include/data_source/class.CompoundValue.php' );
include_once( '../include/data_source/class.ValueLocale.php' );
include_once( '../include/data_source/class.ValueFromArray.php' );
include_once( '../include/data_source/class.ValueFormated.php' );
include_once( '../include/data_source/class.ConversedDBValue.php' );
include_once( '../include/data_source/class.DataValue.php' );
include_once( '../include/elements/data/class.HTMLDataField.php' );
include_once( '../include/elements/data/class.CompoundDataField.php' );
include_once( '../include/elements/data/class.CheckDataField.php' );
include_once( '../include/elements/data/class.ButtonData.php' );
include_once( '../include/elements/data/class.TextDataField.php' );
include_once( '../include/elements/data/class.PagedTableView.php' );
include_once( '../include/elements/data/class.IconDataField.php' );
include_once( '../include/elements/html/class.MainPageElement.php' );
include_once( '../include/elements/html/class.CompoundElement.php' );
include_once( '../include/elements/html/class.PPButtonElement.php' );
include_once( '../include/elements/html/class.ButtonURLElement.php' );
include_once( '../include/elements/html/class.SimpleSearchElement.php' );
include_once( '../include/elements/html/module.Constants.php' );

$lcLangFile = "../languages/$shortlang/webapp.inc.php";

if( is_readable( $lcLangFile ) ){
  include_once( $lcLangFile );
}


global $DEBUG;
//$DEBUG=1;

if( $DEBUG ){
	echo "webapp.php: _POST<br><pre>\n";
	var_dump( $_POST );
	echo "</pre><hr>\n";
 }

db_connect();

$loUser = new SQLString( $PHP_AUTH_USER );

$id = db_query( "SELECT webapp FROM admin WHERE server_id='$ServerID'");
list( $skwebapp ) = db_fetch_array($id);
db_free_query( $id );

$id = safe_query2( "SELECT maxwebapp, anbieter FROM kunden ".
									 " WHERE kunde=? AND server_id='$ServerID'",
									 $loUser );
list( $maxwebapp, $anbieter ) = db_fetch_array( $id, 'N' );
db_free_query( $id );


if( $skwebapp == 0 || $maxwebapp == 0 ){
	db_close();
	include( 'feature_unavailable.php' );
	exit;
 }

$id = safe_query2( "SELECT COUNT(*) FROM webapp_user WHERE kunde=? AND server_id='$ServerID'",
									 $loUser );
list( $usedApps ) = db_fetch_array( $id, 'N' );
db_free_query( $id );

$glCanAdd = ( ( $maxwebapp > 0 && $usedApps < $maxwebapp ) || $maxwebapp == -1 );
 

if( isset( $action ) ){
	switch( $action ){
  case 'on':
    /**
     * Install or view?
     */
    $liViewMode = 0;
    $lrId = safe_query2( " SELECT status FROM webapp_user ".
                         " WHERE webapp_id = ? AND kunde = ? AND server_id='$ServerID'",
                         new SQLString( $webapp_id ), $loUser );
    list( $liViewMode ) = db_fetch_array( $lrId, 'N' );
    db_free_query( $lrId );

    if( $glCanAdd || $liViewMode == 2 ){
      $webapp_action = $action;
      $action = '';
      include 'webapp_conf.php';
      exit;
    }else{
      $action = '';
      $fehlertext = ltext( 'wa_install_error' );
      break;
    }
  case 'off':
  case 'group_off':
		$webapp_action = $action;
		$action = '';
		include 'webapp_delete.php';
		exit;
	}
 }

if( is_array( $_POST ) && count( $_POST ) ){
	initPagingSettings( $_POST, array( 'webapp_to_search' => $webapp_to_search,
																		 'page_size' => $page_size,
																		 'start_index' => $start_index ) );
 }else{
	if( ! isset( $page_size ) ){
		$pages_size = 10;
	}
	if( ! isset( $start_index ) ){
		$start_index = 1;
	}
 }

//Sort settings
if( ! isset( $order ) ) {
	$order = 'name';
}
if( ! isset( $direction)) {
	$direction = 'asc';
}
$laOrders = array( 'name'   => 'w.name',
                   'status' => 'wu.status',
                   'type'   => 'k.type' );
if( array_key_exists( $order, $laOrders ) ){
	 $lcOrder = $laOrders[$order];
}else{
	 $lcOrder = $laOrders['name'];
}
if( $direction == 'desc' ){
  $lcOrder .= ' DESC';
}

$lcDirIcon = ( $direction =='desc' ) ? cc_DescIcon : cc_AscIcon;
$lcNewDir  =  ( $direction =='desc' ) ? 'asc' : 'desc';

$lcFromJoin = " FROM webapp w LEFT JOIN webapp_user wu ".
	" ON ( w.id = wu.webapp_id AND w.server_id=wu.server_id AND wu.kunde=? )".
	" LEFT JOIN webapp_knowledge k ".
	" ON ( w.name = k.webapp AND w.server_id = k.server_id )";

$lcSQL = "SELECT COUNT(w.id) FROM webapp w WHERE server_id='$ServerID' AND status=1";
$id = db_query( $lcSQL );
list( $total_number ) = db_fetch_array( $id );
db_free_query( $id );

$lcFields  = "w.id, w.name, w.version, w.descr, wu.status, wu.url, k.type";
$lcWhere = '';
$loUser = new SQLValue( $PHP_AUTH_USER, 'C' );
$laArgs = array( $loUser );


if( isset( $webapp_to_search ) && $webapp_to_search ){

	$loName = new SQLValue( $webapp_to_search, 'S' );
  $laArgs = array( $loUser, $loName, $loName, $loName ); 
  $lcWhere = " ( w.status=1 OR wu.status =2 ) AND w.server_id='$ServerID'".
             " AND ( w.name LIKE '%?%' OR w.descr LIKE '%?%' OR k.type LIKE '%?%')";
}

if( ! istleer( $webapp_type ) ){
  if( $lcWhere ){
    $lcWhere .= " AND k.type = ? ";
  }else{
    $lcWhere .= " ( w.status=1 OR wu.status =2 ) AND w.server_id='$ServerID' AND  k.type = ? ";
  }
  $laArgs[] = new SQLValue( $webapp_type, 'C' );
}

if( $lcWhere ){
	$lcSQL = "SELECT COUNT(w.id) ".$lcFromJoin." WHERE ".$lcWhere;
	$loQuery = new SQLQuery( $lcSQL, $laArgs );
	$loQuery->doQuery();
	list( $total_number ) = $loQuery->fetchArray( 'N' );
	$loQuery->finish();

	$lcSQL = "SELECT $lcFields ".$lcFromJoin." WHERE $lcWhere ORDER BY $lcOrder";
	$loQuery->Query( $lcSQL );

 } else {
   $lcSQL = " SELECT $lcFields ".$lcFromJoin." WHERE ( w.status=1 OR wu.status) ".
            " AND w.server_id='$ServerID' ORDER BY $lcOrder";
	$loQuery = new SQLQuery( $lcSQL, array( new SQLValue($PHP_AUTH_USER,'C') ) );
 }

$listFormIndex = 0;

$laContent = array();
$laHeaders = array( 'status' => array( 'label' => 'wa_status',  'sort' => true ), 
                    'name'   => array( 'label' => 'wa_name',    'sort' => true ), 
                    'vers'   => array( 'label' => 'wa_version', 'sort' => false ), 
                    'type'   => array( 'label' => 'wa_type',    'sort' => true ), 
                    'descr'  => array( 'label' => 'wa_descr',   'sort' => false ), 
                    'action' => array( 'label' => 'wa_action',  'sort' => false ), 
                    'help'   => array( 'label' => '',           'sort' => false ) ); 

foreach( $laHeaders as $lcKey => $laValue ){
  if( $laValue['sort'] ){
  if( $order == $lcKey ){
	  $loTmp = new CompoundDataField( new HTMLDataField( ltext( $laValue['label'] )),
	  														    new IconDataField( $lcDirIcon ) );
	  $loTmp->SetSeparator('');
  }else{
    $loTmp = new HTMlDataField( ltext( $laValue['label'] ) );
  }

  $laContent[] = new DataValue( $lcKey, NULL, 
                                new LinkDataField( "javascript:setValue('order','$lcKey',$listFormIndex);".
																						  	   "setValue('start_index',1,$listFormIndex);".
																						 	  	 "submitForm('direction','$lcNewDir',$listFormIndex)",
																								   '',	array(), $loTmp ) ); 
  }else{
    if( $laValue['label'] ){
      $laContent[] = new ValueLocale( $laValue['label'] );
    }else{
      $laContent[] = new DataValue( $lcKey, NULL, new HTMLDataField(' '));
    }
  }
}	


$loDS = new ConversedDBValue( $loQuery, $page_size, $start_index - 1 );
$loDS->TotalNumber( $total_number );

$loTemplate = new CompoundValue( new CompoundValue( new ValueFromArray( 'status' ),
																										new ValueFromArray( 'id' )
																										),
																 new CompoundValue( new ValueFromArray( 'name' ),
																										new ValueFromArray( 'status' ),
																										new ValueFromArray( 'url' ) ),
																 new ValueFromArray( 'version' ),
																 new ValueFromArray( 'type' ),
                                 new CompoundValue( new ValueFromArray( 'name' ),
                     															  new ValueFromArray( 'descr' ) ),
																 new CompoundValue( new ValueFromArray( 'status' ),
                                                    new ValueFromArray( 'id' ) ),
                                 new ValueFromArray( 'name' ),
																 new CompoundValue( new ValueFromArray( 'status' ),
																										new ValueFromArray( 'id' ) )

																 );
$loCheckBox = new CheckDataField( 1, 'selectAll' );
$loCheckBox->Attribute('onclick', "javascript:checkedAll('webapp_ids', this.checked, $listFormIndex)");
$loCheckBox->SetParentAttributes(array('align'=>'center'));

$loSelValue = new DataValue( 'selectAll', 1, $loCheckBox );
$loSelValue->setTypeOfPresentation( 'Input' );
$laContent[] = $loSelValue;
$loTitle = new CompoundValue( $laContent );
$laWidths = array( '10%', '15%', '10%', '10%', '45%', '10%'); 
$loDS->Template( $loTemplate );

$gcStatusOff = ltext( 'wa_status_off' );
$gcStatusOn = ltext( 'wa_status_on' );
$gcStatusToOff = ltext( 'wa_status_to_off' );
$gcStatusToOn = ltext( 'wa_status_to_on' );
$gcSwitchToOff = ltext( 'wa_switch_to_off' );
$gcSwitchToOn = ltext( 'wa_switch_to_on' );

/**
 * Formating functions
 */
$gcWebappDelete = ltext( 'wa_uninstall' );
$gcWebappInstall = ltext( 'wa_install' );

function &makeStatus( &$poSrc ){

	global $gcStatusOff, $gcStatusOn, $gcStatusToOff, $gcStatusToOn ;
	global $gcSwitchToOn, $gcSwitchToOff;
	global $confixx_interface_version;
	global $listFormIndex, $glCanAdd;
	global $gcWebappDelete, $gcWebappInstall;

	list( $liStatus, $liId ) = $poSrc->listValue();
  $lcAction = '';
  
  switch( $liStatus ){
	case 1:
		$lcIcon = cc_ToOnIcon;
    //$lcTitle = $gcStatusToOn;
		$lcTitle = $gcSwitchToOff;
		$lcAction = 'off';
		$lcNodeId = 'webapp_delete';
		$lcCurPage = 'webapp_delete.php';
		$lcHeadText = $gcWebappDelete;
		break;
	case 2:
		$lcIcon = cc_OnIcon;
		$lcTitle = $gcSwitchToOff;
		$lcAction = 'off';
		$lcNodeId = 'webapp_delete';
		$lcCurPage = 'webapp_delete.php';
		$lcHeadText = $gcWebappDelete;
		break;
	case 3:
		$lcIcon = cc_ToOffIcon;
		$lcTitle = $gcStatusToOff;
		break;
	default:
		$lcIcon = cc_StateOffIcon;
		if( $glCanAdd ){
			$lcTitle = $gcSwitchToOn;
			$lcAction = 'on';
			$lcNodeId = 'webapp_install';
			$lcCurPage = 'webapp_conf.php';
			$lcHeadText = $gcWebappInstall;
		}else{
			$lcTitle = $gcStatusOff;
		}
	}
	if( $confixx_interface_version == 'powp' ){
		$loIcon = new IconDataField( $lcIcon, 
																 array( 'alt' => $lcTitle, 'title' => $lcTitle ), 
																 array( 'align'=>'center') );
	} else {
		$loIcon = new HTMLDataField($lcTitle, FALSE, array(), array( 'align'=>'center'));
	}

	if( $lcAction ){
		$loLink = new LinkDataField( "javascript:setValue('webapp_id',$liId,$listFormIndex);".
																 "setValue('menu_node_id','$lcNodeId');".
																 "setValue('cur_page','$lcCurPage');".
																 "setValue('head_text','$lcHeadText');".
																 "submitForm('action','$lcAction',$listFormIndex)", 
																 
																 '',
																 array(),
																 $loIcon
																 );
		$loLink->Attribute( 'title', $liStatus==2?$gcSwithToOff:$gcSwithToOn );
		$loLink->ParentAttribute( 'align', 'center' );
	}else{
		$loLink =& $loIcon; 
	}
    
	return $loLink;

}

function &makeDesc( $poDesc ){
  global $lang_text;

  list( $lcName, $lcDesc ) = $poDesc->listValue();

  if( ! empty( $lang_text[$lcName] ) ){
    $loDesc = new HTMLDataField( ltext( $lcName ) ); 
  }else{
    $loDesc = new HTMLDataField( $lcDesc ); 
  }
  return $loDesc;
}

$gcHelp = ltext( 'll_info' );

function &makeHelp( $piId ){
  global $confixx_interface_version;
  global $gcHelp, $hostname, $lang_short;
	$lcIcon = cc_HelpIcon;
    
  if( $confixx_interface_version == 'powp' ){
	  $loIcon = new IconDataField( $lcIcon, 
																 array( 'alt' => $gcHelp, 'title' => $gcHelp ), 
																 array( 'align'=>'center') );
	} else {
		$loIcon = new HTMLDataField( $gcHelp, FALSE, array(), array( 'align'=>'center' ) );
	}
/**
 * @todo  Don't forget about https!
 */
  $loLink = new LinkDataField( "javascript: displayHelpDiv(1,".
                               "'http://$hostname/webapps/$piId/index.$lang_short.html');",
                                '', array(), $loIcon );
	$loLink->Attribute( 'title', $gcHelp );
	$loLink->ParentAttribute( 'align', 'center' );
  
	return $loLink;
}

function &makeName( &$poSrc ){
	list( $lcName, $liStatus, $lcUrl ) = $poSrc->listValue();

	if( $liStatus == 2 || $liStatus == 3 ){
		$loLink = new LinkDataField( $lcUrl,
																 '',
																 array(),
																 $lcName
																 );

		$loLink->Attribute( 'title', 'Go to application' );
		$loLink->Attribute( 'target', 'web_app' );

	}else{
		$loLink = new HTMLDataField( $lcName );
	}
	return $loLink;
}

$gcConfig = ltext( 'wa_config' );
$gcInfo = ltext( 'm_settings' );
$gcHead = ltext( 'wa_config_head' );

function &makeConf( &$poSrc ){
	global $gcConfig, $gcHead;
  global $page_size,$start_index;
  global $webapp_to_search, $gcWebappInstall, $listFormIndex;
  global $gcInfo;

  list($liStatus,$liId)= $poSrc->listValue();
      $lcAction = 'on';
			$lcNodeId = 'webapp_install';
			$lcCurPage = 'webapp_conf.php';
			$lcHeadText = $gcWebappInstall;

  if( $liStatus <= 2 ){
    $loIcon = new HTMLDataField( ( $liStatus == 2 ? $gcInfo : $gcWebappInstall ), FALSE, 
                                array(), array( 'align'=>'center' ) );
  
    $loLink = new LinkDataField( "javascript:setValue('webapp_id',$liId,$listFormIndex);".
																 "setValue('menu_node_id','$lcNodeId');".
																 "setValue('cur_page','$lcCurPage');".
																 "setValue('head_text','$lcHeadText');".
																 "submitForm('action','$lcAction',$listFormIndex)", 
																 
																 '',
																 array(),
																 $loIcon
																 );
	}else{
		$loLink = new HTMLDataField( '');
	}
	return $loLink;
}

function &makeSelect( &$poSrc ) {
	list($liStatus,$liID) = $poSrc->listValue();
	if( $liStatus == 2 ){
		$loCheckBox = new CheckDataField( $liID, 'webapp_ids[]');
		$loCheckBox->ParentAttribute('align','center');
	}else{
		$loCheckBox = new HTMLDataField( '&nbsp;' ); 
	}
	
	return array( $loCheckBox->GetInputPresentation(), array('align'=>'center'));
	
}

// end formating funtions
//
//==========================================================

$loConv = new CompoundValue( new ValueFormated( 'status', NULL, 'makeStatus' ),
														 new ValueFormated( 'name', NULL, 'makeName' ),
														 NULL,
														 NULL,
														 new ValueFormated( 'desc', NULL, 'makeDesc' ),
														 new ValueFormated( 'conf', NULL, 'makeConf' ),
														 new ValueFormated( 'help', NULL, 'makeHelp' ),
														 new ValueFormated( 'select', NULL, 'makeSelect' )
														 );
$loDS->Conversion( $loConv );

$loDS->doQuery();

$loPTV = new PagedTableView( $loDS, $total_number );
$loPTV->Title( $loTitle	);
$loPTV->Widths( $laWidths );
$loPTV->setParameter( 'menu_node_id', $menu_node_id );
$loPTV->setParameter( 'cur_page', $cur_page?$cur_page:'' );
$loPTV->setParameter( 'head_text', $head_text );

$loPTV->setParameter( 'action', '' );
$loPTV->setParameter( 'webapp_id', '' );
$loPTV->setParameter( 'order', "$order" );
$loPTV->setParameter( 'direction', "$direction" );

if( isset( $name_to_search ) && $name_to_search ){
	$loPTV->NoItemsMessage(ltext('ll_empty_search'));
 } else {
	$loPTV->NoItemsMessage(ltext('ll_empty_list'));
 }

$loPTV->Anchor( 'list' );

$tbl = $loPTV->GetOutputPresentation( array( 'action' => 'webapp.php#list',
																						 'name' => 'list_apps' ), 
																			ltext( 'wa_title' ) );

/**
 *  Add search elements
 */
$loType = new CompoundDBValue( new SQLQUery( " SELECT type AS webapp_type, type AS webapp_type FROM webapp_knowledge ".
                                             " WHERE type<>'' AND server_id='$ServerID' GROUP BY type" ) );
$loType->doQuery();
$loType->addValue( new KeyValue( 'webapp_type', '' ), new ValueLocale( 'wa_all_types' ) );

$dsSearch = new CompoundValue( new ValueFromArray( 'webapp_to_search', $webapp_to_search ),
                               $loType, 
                               new ValueLocale( 'll_search' ),
                               new ValueLocale( 'll_show_all' )
                               );

$loSearch = new SimpleSearchElement( array(), 
                                     new InputTextElement( array( 'name' => 'webapp_to_search', 
                                                                  'size' => '16',
                                                                  'value' => $mail_to_search,
                                                                  'MAXLENGTH'=> '32' ) ),
                                     new SelectElement( array( 'name' => 'webapp_type' ) ) );
  
$loGroup = new DivElement(array('class'=>'buttons'));
  

$loSearch->appendElement( new PPButtonElement( '', 
                                               "javascript:submitForm('start_index',1,$listFormIndex)", 
                                               'bid-search' 
                                               )
                          );
$loSearch->appendElement( new PPButtonElement( '', "javascript:setValue('webapp_to_search','',$listFormIndex);".
                                                   "setValue('webapp_type','',$listFormIndex );".
                                                   "submitForm('start_index',1,$listFormIndex)", 
                                                   'bid-show-all'
                                               ) 
                          );

$head_text = ltext('ll_delete');
$lcConfirm = ltext('ll_confirm_delete');
$lcNothing = ltext('ll_nothing');

  
$loSearch->setDataSource( $dsSearch, array( 'webapp_to_search' => $webapp_to_search,
                                            'webapp_type' => $webapp_type  ) );

$loGroup->AppendToContent( new PPButtonElement( $head_text,
																								"javascript:submitForm('action','group_off', $listFormIndex)",
																								'bid-delete' ) );

if( ( isset( $webapp_to_search ) && $webapp_to_search ) 
  || ! istleer( $webapp_type )
  || $total_number > 0 ){
	$tbl->setSearchElement( $loSearch );
 }
if ($total_number>0) {
	$tbl->setGroupActionElement( $loGroup );
 }

$tbl->updateBodyContent();

$page = new MainPageElement( $tbl );

$JSscriptPart = "function displayHelpDiv(dspl, url ){
                  var div = document.getElementById('helpdiv');
                  var divpage = document.getElementById('paging');
                  var frame = document.getElementById('helpframe');
                  if(div){
                    if(dspl){
                      div.style.display = '';
                      divpage.style.display = 'none';
                      if(url && url.toLowerCase()!== frame.src.toLowerCase()){
                        frame.src = url;   
                      }
                    }else{
                    div.style.display = 'none';
                    divpage.style.display = '';
                  }
                }else{
                  //		alert(id+' : '+div);
                  }
               }";
$lcTmp = '<div id="helpdiv" class="helpdiv" style="display:none"><div style="margin:10px">';
$loBackButton  = new ButtonData( ltext( 'll_back' ),"javascript:displayHelpDiv(0);", cc_IDBack );
$loBackButtonOut = $loBackButton->GetOutputPresentation();
$lcTmp .= $loBackButtonOut->GetHTML();
$lcTmp .='</div> <IFRAME src="#" frameborder=0 scrolling="auto" id="helpframe" width="100%" height="1000px">
          </IFRAME>
          </div>';


$page->AppendToContent( $lcTmp );
$page->OutputHTML( array( '../../js/paged_form.js' ), $JSscriptPart );

?>
