<?php
########## Confixx(R) 3.2 Professional ############
####### Copyright SWsoft, Inc. 2004-2005 ##########
#### http://www.swsoft.com - info@swsoft.com ####

include_once( 'auth.php' );
include_once( 'defines.php' );
include_once( '../include/data_source/class.SQLQuery.php' );
include_once( '../include/class.SQLFieldSet.php' );
include_once( '../include/elements/data/class.CheckDataField.php' );
include_once( '../include/elements/data/class.OptionsDataField.php' );
include_once( '../include/elements/data/class.SetOfRowsData.php' );
include_once( '../include/elements/data/class.HTMLDataField.php' );
include_once( '../include/elements/data/class.TextDataField.php' );
include_once( '../include/elements/data/class.PasswordDataField.php' );
include_once( '../include/elements/html/class.MainPageElement.php' );
include_once( '../include/elements/html/module.Constants.php' );
include_once( '../include/event_functions.php' );
include_once( '../include/module.webapp.php' );

$lcLangFile = "../languages/$shortlang/webapp.inc.php";

if( is_readable( $lcLangFile ) ){
  include_once( $lcLangFile );
}

global $DEBUG;
//$DEBUG=1;

if( $DEBUG ){
	echo "webapp_conf.php: _POST<br><pre>\n";
	print_r( $_POST );
	echo "</pre><hr>\n";
}

$confixx_db =& getConfixxDBConnect();

$loUser = new SQLString( $PHP_AUTH_USER );
$loWebappId = new SQLInteger( $webapp_id );

/**
 * Checks for availability of feature
 */
$id = db_query( "SELECT webapp FROM admin WHERE server_id='$ServerID'");
list( $skwebapp ) = db_fetch_array($id);
db_free_query( $id );

$id = safe_query2( "SELECT maxwebapp, anbieter FROM kunden ".
									 " WHERE kunde=? AND server_id='$ServerID'",
									 $loUser );
list( $maxwebapp, $anbieter ) = db_fetch_array( $id, 'N' );
db_free_query( $id );


if( $skwebapp == 0 || $maxwebapp == 0 ){
  $confixx_db->disconnect();
	include( 'feature_unavailable.php' );
	exit;
}

/**
 * Install or view?
 */
$liViewMode = 0;
$lrId = safe_query2( " SELECT status FROM webapp_user ".
							  		 " WHERE webapp_id = ? AND kunde = ? AND server_id='$ServerID'",
								  	 $loWebappId, $loUser );
list( $liViewMode ) = db_fetch_array( $lrId, 'N' );
db_free_query( $lrId );
if( $liViewMode != 2 ){
  $liViewMode = 0;
}
/**
 * Check for webapp count overhead 
 */
$lrId = safe_query2( " SELECT COUNT(id) FROM webapp_user ".
									   " WHERE kunde=? AND server_id='$ServerID'",
  									 $loUser );
list( $liWebAppUsage ) = db_fetch_array( $lrId, 'N' );
db_free_query( $lrId );

$gbCanAdd = ( ( $maxwebapp > 0 && $liWebAppUsage < $maxwebapp ) || $maxwebapp == -1 );

if( ! $gbCanAdd && ! $liViewMode ){
  $fehlertext = ltext( 'wa_install_error' );
  $confixx_db->disconnect();
  popPathBar();
	include_once( 'webapp.php' );
	exit;
}

/**
 * Get web application data
 */
$id = safe_query2( " SELECT name,descr,version FROM webapp ".
									 " WHERE server_id='$ServerID' AND id=?",
									 $loWebappId );
if( ! db_num_rows( $id ) ){
	$fehlertext = ltext( 'wa_id_not_found' ); 
  $confixx_db->disconnect();
  popPathBar();
	include_once( 'webapp.php' );
	exit;
 }

list( $waName, $waDescr, $waVersion ) = db_fetch_array( $id, 'N' );
db_free_query( $id );

/**
 * Perform action?
 */
if( isset( $action ) && ! empty( $action ) ){

  if( $liViewMode ){
    $action = 'cancel';
  }

	switch( $action ){
	case 'save':
		$lcError = NULL;
    if( is_array( $names ) && is_array( $values ) ){
      /**
       * All fields of install form should not be empty
       */
      foreach( $values as $liParam_id => $lcValue ){
        if( ! strlen( $lcValue ) ){
          $lcError = ltext( 'form_empty_required_fields' );
          break;
        }
      }
      $lcDb = '';
			$lcPath = '';
			if( is_array( $realms ) && ! $lcError ){
				foreach( $realms as $lcRealm => $lcComaList ){
					$laList = split( ',', $lcComaList );
					switch( $lcRealm ){
					case 'db':
            $lcError = checkDbSet( $laList, $names, $values, $roles, $waName );
            $confixx_db->CheckConnection();
						list( $lcDb ) = getParams( $laList, $values, $roles, array( 'name' ) );
						break;
					case 'admin':
					case 'setup':
					case 'header':
					case 'mambo_editor':
						$lcError = checkAdminSet( $laList, $names, $values, $roles, $lcRealm );
						break;
					case 'application':
            list( $lcPath ) = getParams( $laList, $values, $roles, array( 'path' ) );

            if( preg_match( "#[^0-9a-zA-Z\-_\/\xD6\xF6\xC4\xE4\xDC\xFC\xDF]#", $lcPath ) ){
              $lcError = ltext( 'uc_invalidchar', ltext( 'wa_app_path' ) );
            }

					default:
					}
					if( $DEBUG ){
						echo "check: $lcError<br>\n";
					}
					if( $lcError ){ // an error is found
						break;
					}
        }

				unset( $realms );
				unset( $roles );
      }else{
        $lcSearchId = array_search( 'install_prefix', $names );
        if( isset( $values[$lcSearchId] ) ){
          if( preg_match( "#[^0-9a-zA-Z\-_\/\xD6\xF6\xC4\xE4\xDC\xFC\xDF]#", $values[$lcSearchId] ) ){
              $lcError = ltext( 'uc_invalidchar', 'install_prefix' );
          }
        }
      }

			if( ! $lcError ){
			 	$sql = " UPDATE webapp_user_param SET value=? WHERE server_id='$ServerID' ".
               " AND kunde=? AND webapp_id=? AND name=? ";

				foreach( $names as $param_id => $name ){
					if( is_array( $values[$param_id] ) ){
						$lcValue = array_shift( $values[$param_id] ); // password
          }else{
						$lcValue = $values[$param_id];
					}
					safe_query2( $sql,
											 new SQLString( $lcValue ),
											 $loUser,
											 $loWebappId,
											 new SQLString( $name )
											 );
				}
				unset( $values );
				unset( $names );
			}
		}

		if( $lcError ){
			$fehlertext = $lcError;

		}else{
			$where = "server_id='$ServerID' AND kunde=? AND webapp_id=?";
	$id = safe_query2( "SELECT id FROM webapp_user WHERE $where",
												 $loUser, $loWebappId );
			$rows = db_num_rows( $id );
			if( $rows > 1 ){
				safe_query2( "DELETE FROM webapp_user WHERE $where",
										 $loUser, $loWebappId );
				$rows = 0;
			}
			list( $liId ) = db_fetch_array( $id, 'N');
			db_free_query( $id );
			$loFlds = new SQLFieldSet( array( 'domain_id' =>  $domain_id,
																				'clean_db' => $clean_db,
																				'db' => array( $lcDb, 'C' ),
																				'path' => array( $lcPath, 'C' )
																				)
																 );
			if( $webapp_action == 'on' ){
				$loFlds->addField( 'status', 1 );
				eventAdd( $OBJECT_WEBAPP, $EVENT_NEW );
				safe_query2( "UPDATE kunden SET httpd=1 WHERE kunde=? AND server_id='$ServerID'", 
										 $loUser );
				safe_query2( "UPDATE allgemein SET httpd=1 WHERE server_id='$ServerID'" );
			}
			
			if( $rows ){
				$lcSet = $loFlds->getSQLUpdate();
				$sql = "UPDATE webapp_user SET $lcSet WHERE id=$liId AND server_id='$ServerID'";
			}else{

				$id = safe_query2( "SELECT anbieter FROM kunden WHERE kunde=? AND server_id='$ServerID'",
													 $loUser );
				list( $lcReseller )  = db_fetch_array( $id, 'N' );
				db_free_query( $id );

				$loFlds->addField( 'server_id', $ServerID, 'C' );
				$loFlds->addField( 'kunde', $PHP_AUTH_USER, 'C' );
				$loFlds->addField( 'anbieter', $lcReseller, 'C' );
				$loFlds->addField( 'webapp_id', $webapp_id );
			  	
				list($lcNames,$lcVals) = $loFlds->getSQLInsert();
        $sql = "INSERT INTO webapp_user ( $lcNames ) VALUES ( $lcVals )";
			}
			safe_query2( $sql );
	
      $action = '';
      popPathBar();
			include( 'webapp.php' );

			exit();
		}
    break;
  case 'cancel':
    popPathBar();
    include( 'webapp.php');
    exit;
	default:
	}
 }

$data = new SetOfRowsData();

$data->AppendRow( new HTMLDataField( ltext('wa_name')),
									new HTMLDataField( $waName )
									);

$data->AppendRow( new HTMLDataField( ltext('wa_version')),
									new HTMLDataField( $waVersion )
									);

$data->AppendRow( new HTMLDataField( ltext('wa_descr')),
									new HTMLDataField( empty($lang_text[$waName]) 
                                     ? $waDescr 
                                     : ltext( $waName ) )
									);

$id = safe_query2( "SELECT domain_id FROM webapp_user WHERE webapp_id=? AND kunde=?",
									 $loWebappId, $loUser );
list( $domain_id) = db_fetch_array( $id, 'N' );
db_free_query( $id );

$loList = new SQLQuery( " SELECT id, domain FROM domains WHERE kunde = ? ".
												" AND pfad LIKE '/%' AND domain NOT LIKE '%*%' AND server_id='$ServerID'".
												" ORDER BY domain",
												new SQLValue( $PHP_AUTH_USER, 'C' ) );

$data->AppendRow( new HTMLDataField( ltext( 'wa_domain' ) ),
									new OptionsDataField( $loList, $domain_id, 'domain_id' )
									);
/**
 * Get webapp params
 */
$id = safe_query2( " SELECT id, name, def_val, type, valtype FROM webapp_param ".
									 " WHERE server_id='$ServerID' AND webapp_id=?",
									 $loWebappId );
$laParams = array();
while( $laRow = db_fetch_array( $id, 'A' ) ){
	$laParams[$laRow['id']] = $laRow;
 }
db_free_query( $id );
/**
 * Get roles
 */
$laRoles = array();
$id = safe_query2( "SELECT param,realm,role FROM webapp2confixx ORDER BY ind");
while( $laRow = db_fetch_array( $id, 'N' ) ){
	$laRoles[] = $laRow;
 }
db_free_query( $id );
/**
 * Get user's params for current application
 */
$id = safe_query2( "SELECT id,param_id,name,value FROM webapp_user_param ".
									 " WHERE server_id='$ServerID' AND webapp_id=? AND kunde=?",
                   $loWebappId, $loUser );

while( $laRow = db_fetch_array( $id, 'A' ) ){
	$liParamId = $laRow['param_id'];
	if( array_key_exists( $liParamId, $laParams ) ){
		$laParam = $laParams[$liParamId];

		if( $laParam['name'] == $laRow['name'] ){ // all is ok
			$laParams[$liParamId]['value'] = $laRow['value'];

		}else{ // name is wrong
			safe_query2( "UPDATE webapp_user_param SET name=?, value='' WHERE server_id='$ServerID' AND id=".$laRow['id'],
									 new SQLString( $laParam['name'] ) );
			$laParams[$liParamId]['value'] = '';
		}

	}else{ // bad parameter
		safe_query2( "DELETE FROM webapp_user_param WHERE server_id='$ServerID' ".
								 " AND id=".$laRow['id'] );
	}
 }
db_free_query( $id );

$laRealms  = array();
$laUnknown = array();
/**
 * Does Confixx know these params and their roles?
 */
foreach( $laParams as $liId => $laParam ){
	$lcName = $laParam['name'];
	if( ! array_key_exists( 'value', $laParam ) ){
		$laParams[$liId]['value'] = $laParam['value'] = $laParam['def_val'];

		safe_query2( "INSERT INTO webapp_user_param (server_id,webapp_id,param_id,kunde,name,value) ".
								 " VALUES ('$ServerID',?,".$laParam['id'].",?,?,?)",
								 $loWebappId,
								 $loUser,
								 new SQLString( $laParam['name'] ),
								 new SQLString( $laParam['value'] )
								 );
	}

	$llNotFound = 1;
	foreach( $laRoles as $liRoleInd => $laRole ){
		if( preg_match( '/'.$laRole[0].'/', $lcName ) ){
			$laParams[$liId]['role'] = $laRole;
			$laRealms[$laRole[1]][] = $liId;
			$llNotFound = 0;
			break;
		}
	}
	if( $llNotFound ){
		$laUnknown[] = $liId;
	}
}

unset( $laRoles );

if( is_array( $values ) ){ // pass value from POST

	foreach( $values as $liId => $lcValue ){
		if( array_key_exists( $liId, $laParams ) ){
			if( is_array( $lcValue ) ){
				$laParams[$liId]['value'] = array_shift( $lcValue );
			}else{
				$laParams[$liId]['value'] = $lcValue;
			}
		}
	}
	unset( $values );
	unset( $names );
 }


if( $DEBUG ){
	echo "Parameters: <br><pre>\n";
	print_r($laParams);
	echo "</pre><hr>\n";
 }
 
foreach( $laRealms as $lcRealm => $laInds ){

	if( $DEBUG ){
		echo "$lcRealm: <br><pre>\n";
		print_r( $laInds );
		echo "</pre><hr>\n";
	}

	switch( $lcRealm ){
	case 'db':
		addDbSet( $data, $laInds, $laParams, $webapp_id );
		break;
	case 'admin':
	case 'setup':
	case 'header':
	case 'mambo_editor':
		addAdminSet( $data, $laInds, $laParams, $lcRealm );
		break;
	case 'application':
		addAppSet( $data, $laInds, $laParams, $waName );
		break;
	case 'personalinfo':
		addPersInfoSet( $data, $laInds, $laParams );
		break;
		/*
	case 'company':
		addCompanySet( $data, $laInds, $laParams );
		break;
	case 'server':
		addServerSet( $data, $laInds, $laParams );
		break;
	case 'file':
		addFileSet( $data, $laInds, $laParams );
		break;
		*/
	default:
		addUnknownSet( $data, $laInds, $laParams, $lcRealm );
	}

	foreach( $laInds as $liInd ){
		$data->AppendHidden(new TextDataField( $laParams[$liInd]['name'],
																					 'names['.$laParams[$liInd]['id'].']' ));
		$data->AppendHidden(new TextDataField( $laParams[$liInd]['role'][2],
																					 'roles['.$laParams[$liInd]['id'].']' ));

	}

	//
	// register the realm to validate parameters
	//
	$data->AppendHidden( new TextDataField( join(',',$laInds), "realms[$lcRealm]" ) );

}
if( count( $laUnknown ) ){

	if( $DEBUG ){
		echo "unknown: <br><pre>\n";
		print_r( $laUnknown );
		echo "</pre><br>\n";
	}

	addUnknownSet( $data, $laUnknown, $laParams );

	foreach( $laUnknown as $liInd ){
		$data->AppendHidden(new TextDataField( $laParams[$liInd]['name'],
      'names['.$laParams[$liInd]['id'].']' ));
	}
 }

$data->AppendHidden(new TextDataField( $webapp_id, 'webapp_id' ) );
if( isset( $webapp_action ) ){
	$data->AppendHidden(new TextDataField( $webapp_action, 'webapp_action' ) );
 }
$data->AppendHidden(new TextDataField( 'save', 'action' ) );

$data->AppendHidden( new TextDataField( $page_size, 'page_size' ) );
$data->AppendHidden( new TextDataField( $start_index, 'start_index' ) );
$data->AppendHidden( new TextDataField( $webapp_to_search, 'webapp_to_search' ) );

if( $liViewMode ){
 $data->AppendButton( ltext( 'll_back' ), 
			  							 "javascript:submitForm('action','cancel')",
		  								 cc_IDBack );
}else{
  $data->AppendButton( ltext( 'll_apply' ), 
                       "javascript:doChange()",
                       cc_IDOk );
  $data->AppendButton( ltext( 'll_cancel' ), 
  										 "javascript:submitForm('action','cancel')",
	   									 cc_IDCancel );
}
/**
 * @todo  Don't forget about https!
 */
 $data->AppendButton( ltext( 'll_info' ), 
                      "javascript:displayHelpDiv( 1,'http://$hostname/webapps/$waName/index.".
                      "$lang_short.html' );return false",
		  								 cc_IDOk );

$loForm = $data->GetInputPresentation( array( 'action' => 'webapp_conf.php',
  																						'method' => 'post',
	  																					'name' => 'form1' ),
          														 ltext( 'wa_config' ) );

$loForm->AppendTop( ltext('form_all_required_fields' ) );

$loPage = new MainPageElement( $loForm );

$JSscriptPart = "function displayHelpDiv(dspl, url ){
                  var div = document.getElementById('helpdiv');
                  var frame = document.getElementById('helpframe');
                  if(div){
                    if(dspl){
                      div.style.display = '';
                      if(url && url.toLowerCase()!== frame.src.toLowerCase()){
                        frame.src = url;   
                      }
                    }else{
                    div.style.display = 'none';
                  }
                }else{
                  //		alert(id+' : '+div);
                  }
               }";
$lcTmp = '<div id="helpdiv" class="helpdiv" style="display:none"><div style="margin:10px">';
$loBackButton =	new ButtonData( ltext( 'll_back' ),"javascript:displayHelpDiv(0);", cc_IDBack );
$loBackButtonOut = $loBackButton->GetOutputPresentation();
$lcTmp .= $loBackButtonOut->GetHTML();
$lcTmp .='</div> <IFRAME src="#" frameborder=0 scrolling="auto" id="helpframe" width="100%" height="1000px">
          </IFRAME>
          </div>';
$loPage->AppendToContent( $lcTmp );
$loPage->OutputHTML( array( '../../js/paged_form.js' ), $JSscriptPart );


?>
