package Modules::Apache::Config::RedirectSet;

########## Confixx(R) 3.1 Professional ############
####### Copyright SWsoft, Inc. 2004-2005 ##########
#### http://www.swsoft.com - info@swsoft.com ####

# $id: RedirectSet.pm, v 1.0 2003/11/7 $

use Modules::Apache::Config::Redirect;
use Modules::Apache::Config::Redirect ();

my $class = "Modules::Apache::Config::Redirect";

use strict;

sub new {
  my $class = shift;
  my $self = {};

  bless($self, $class);

  $self->{'_set'} = undef;
  $self->{'_index'} = -1;

  return $self;
}

sub append {
  my $self = shift;
  if (@_){
    my $vserv= shift;
    if (ref($vserv) =~ /Redirect/){
      my $forAdd = Modules::Apache::Config::Redirect->clone($vserv);
      push @{$self->{'_set'}},$forAdd;
      return $forAdd;
    }
  }
}

sub appendnew {
  my $self = shift;

  my %args = (
	      'ip' => '127.0.0.1',
	      'url' => '',
	      'domain' => '',
	      'level' => 0,
	      'kunde' => '',
	      @_
	     );

  my $new = Modules::Apache::Config::Redirect->new ( 'ip' => $args{'ip'},
																										 'url' => $args{'url'},
																										 'domain' => $args{'domain'},
																										 'level' => $args{'level'},
																										 'kunde' => $args{'kunde'});
  push @{$self->{'_set'}},$new;
  return $new;
}

sub index {
  my $self = shift;
  my $ret=-1;	
  if (@_){
    my $pattern = shift;
    if (ref($pattern) =~ /Redirect/){
      for (my $i=0; $i<@{$self->{'_set'}}; $i++){
				if ( $pattern->isequiv($self->{'_set'}[$i] ) ){
					$ret=$i;
					$self->{'_index'}=$ret;	
					last;
				}
      }
    }
    return $ret;
  } else {
    return $self->{'_index'};
  }
}


sub levels {
  my $self = shift;
  unless (defined($self->{'_set'})){
    return;
  }
  my %levels;
  foreach my $rdr (@{$self->{'_set'}}){
    $levels{$rdr->level}=1;
  }
  return sort keys %levels;
}

sub maxlevel {
  my $self = shift;
  unless (defined($self->{'_set'})){
    return;
  }
  my $max=$self->{'_set'}[0]->level;
  foreach my $rdr (@{$self->{'_set'}}){
    my $lvl=$rdr->level;
    if ($max<$lvl){
      $max = $lvl;
    }
  }
  return $max;
}

sub level {
  my $self = shift;
  if (@_){
    $self->{'_level'} = shift;
  }
  return $self->{'_level'}
}

sub levelclear {
  my $self = shift;
  delete $self->{'_level'};
}

sub top {
  my $self=shift;
  $self->{'_index'}=-1;
}

sub next {
  my $self = shift;
  unless ( defined( $self->{'_set'} ) ){
    return;
  }
  my $level=$self->{'_level'};
  my $ist;
  for (my $ind=$self->{'_index'}+1; $ind<@{$self->{'_set'}}; $ind++){
    if (defined($level)){
      if ($self->{'_set'}[$ind]->level == $level){
	$ist = 1;
      }
    }else{
      $ist = 1;
    }
    if ($ist){
      $self->{'_index'}=$ind;
      return $self->{'_set'}[$ind];

    }
  }
  $self->{'_index'}=-1;
  return undef;
}

sub current {
  my $self = shift;
  unless ( defined( $self->{'_set'} ) ){
    return;
  }
  my $index = $self->{'_index'};
  if ($index>=0 && $index < @{$self->{'_set'}}){
    return $self->{'_set'}[$index];
  }
}

sub totext {
  my $self = shift;
  my $ret='';
  my ($key,$val,$rec,$ref,$cnt,$i,$vkey,$vval);
  while (($key,$val)=(each %$self)){
    if (($key eq '_set') && defined($val) ){
      $cnt = @$val;
      $ret .= "$key (Redirect) $cnt:\n";
      for ($i = 0; $i < $cnt; $i++){
				$ret .= "[$i]:\t(".ref($val->[$i]).")\n";
				$ret .= $val->[$i]->totext("\t");
      }

    }else{
      $ref = ref($val);
      if ($ref eq 'ARRAY'){
				$cnt = @$val;
				$ret .= "$key (array) $cnt:\n";
				for ($i = 0; $i < $cnt; $i++){
					$ret .= "\t[$i]:\t".$val->[$i]."\n";
				}

      } elsif ( $ref eq 'HASH' ) {
				$cnt = scalar(keys %$val);
				$ret .= "$key (hash) $cnt:\n";
				while (($vkey,$vval) = (each %$val)){
					$ret .= "\t$vkey\t=>\t$vval\n";
				}

      } else {
				if ( defined ( $val ) ) {
					$ret.="$key\t=\t$val\n";
				} else {
					$ret.="$key\t=\tundef\n";
				}
      }
    }
  }
  return $ret;
}

1;
