package Modules::Backup::Dir;

########## Confixx(R) 3.1 Professional ############
####### Copyright SWsoft, Inc. 2004-2005 ##########
#### http://www.swsoft.com - info@swsoft.com ####

BEGIN {
  use Exporter;
  @ISA = qw(Exporter);
  @EXPORT_OK = qw(&new &Path &Base &isDir &fullPath
		  &addExclusion &Exclusions &addDelete &Delete
		  &Attribute &toText );
}

use strict;

use Modules::Backup::Path;

sub new {
  my $classname = shift;
  my $args = {
	      'path'=>'',
	      'base'=>'',
	      @_
	      };
  my $this={'path'=>'',
	   'base'=>'',
	   'exclude'=>[],
	   'delete'=>[],
	   'attribute'=>{},
	   };

  bless ($this,$classname);
  $this->Path($args->{'path'}) if $args->{'path'};
  $this->Base($args->{'base'}) if $args->{'base'};
  $this->Attribute('name',$this->Path);
  return $this;
}

sub Path {
  my $this=shift;
  if(@_){
    $this->{'path'}=shift;
    if($this->{'path'}=~/^\//){
      $this->{'base'}='';
    }
  }
  return $this->{'path'};
}

sub Base {
  my $this=shift;
  if(@_){
    $this->{'base'}=shift;
    if ($this->{'base'}){
      $this->{'base'}.='/' unless ($this->{'base'}=~/\/$/);
      $this->{'path'}=~s/^\///;
    }else{
      $this->{'base'}='' ;
    }
  }
  return $this->{'base'};
}

sub makeFullPath {
  my ($base,$path)=@_;
  if($base){
    $base.='/' unless $base=~/\/$/;
    $path=~s/^\///;
    $path=$base.$path;
  }
  return $path;
}

sub fullPath {
  my $this=shift;
  my $path=&makeFullPath($this->{'base'},$this->{'path'});
  my $chunk;
  while (@_){
    $path=&makeFullPath($path,shift);
  }
  return $path;
}

sub isDir {
  my $this=shift;
  my $path=&makeFullPath($this->{'base'},$this->{'path'});
  return (-d $path);
}

sub addExclusion {
  my $this=shift;

  my $args = {
	      'path'=>'',
	      'where'=>'',
	      @_
	      };


  my $objPath = Modules::Backup::Path->new('path'=>$args->{'path'},
					   'where'=>$args->{'where'},
					  );
  if($objPath){
    push @{$this->{'exclude'}},$objPath;
  }
  return $objPath;
}

sub Exclusions {
  my $this=shift;
  if (ref($this->{'exclude'})=~/ARRAY/){
    return $this->{'exclude'}
  }else{
    return undef;
  }
}

sub Delete {
  my $this=shift;
  if (ref($this->{'delete'})=~/ARRAY/){
    return $this->{'delete'}
  }else{
    return undef;
  }
}

sub addDelete {
  my $this=shift;

  my $args = {
	      'path'=>'',
	      'where'=>'',
	      @_
	      };


  my $objPath = Modules::Backup::Path->new('path'=>$args->{'path'},
					   'where'=>$args->{'where'},
					  );
  if($objPath){
    push @{$this->{'delete'}},$objPath;
  }
  return $objPath;
}


sub Attribute {
  my $this=shift;
  my $key=shift;
  if (@_){
    $this->{'attribute'}->{$key}=shift;
    return $this->{'attribute'}->{$key};
  }else{
    if (exists ($this->{'attribute'}->{$key})){
      return $this->{'attribute'}->{$key};
    }else{
      return undef;
    }
  }
}

sub toText {
  my $this=shift;
  my ($key,$value,$ret,$count,$chunk,$npp);
  $ret='';
  while(($key,$value)=each(%{$this})){
    if(ref($value)=~/HASH/){
      $ret.="$key\t(hash):\n";
      while(($key,$chunk)=each(%{$value})){
	$ret.="\t$key\t=\t$chunk\n";
      }
    }elsif(ref($value)=~/ARRAY/){
      $count=@{$value};
      $ret.="$key\t(array: $count)\n";
      $npp=0;
      foreach $chunk (@{$value}){
	$ret.="\t[$npp]:\t";
	if (ref($chunk)=~/Path/){
	  $ret.="\n";
	  $ret.=$chunk->toText("\t");
	}else{
	  $ret.="$chunk\n";
	}
	$npp++;
      } 
    }else{
      $ret.="$key\t=\t$value\n";
    }
  }
  return $ret;
}

1;
