package Modules::Backup::Path;

########## Confixx(R) 3.1 Professional ############
####### Copyright SWsoft, Inc. 2004-2005 ##########
#### http://www.swsoft.com - info@swsoft.com ####

BEGIN {
  use Exporter;
  @ISA = qw(Exporter);

  @EXPORT_OK = qw(&new &Path &Name &Dir &If &Where &toText);
}

use strict;

sub new {
  my $classname = shift;
  my $args = {
	      'path'=>'',
	      'if'=>'',
	      'where'=>'',
	      @_
	      };
  my $this={
	    'path'=>$args->{'path'},
	    'if'=>$args->{'if'},
	    'where'=>$args->{'where'},
	   };
  bless ($this,$classname);
  return $this;
}

sub Path {
  my $this=shift;
  if(@_){
    $this->{'path'}=shift;
  }
  return $this->{'path'};
}

sub If {
  my $this=shift;
  if(@_){
    $this->{'if'}=shift;
  }
  return $this->{'if'};
}

sub Where {
  my $this=shift;
  if(@_){
    $this->{'where'}=shift;
  }
  return $this->{'where'};
}

sub Name {
  my $this=shift;
  my $name;
  if(@_){
    $name=shift;
    $this->{'path'}=~s/([^\/]+)$/$name/;
  }else{
    if($this->{'path'}=~/([^\/]+)$/){
      $name=$1;
    }else{
      $name=$this->{'path'};
    }
  }
  return $name;
}

sub Dir {
  my $this=shift;
  my $dir;
  if(@_){
    $dir=shift;
    $dir=~s/\/$//;
    $this->{'path'}=~s/^(.+)\//$dir/;
  }else{
    if($this->{'path'}=~/^(.+)\//){
      $dir=$1;
    }else{
      $dir='';
    }
  }
  return $dir;
}

sub toText {
  my $this=shift;
  my $prefix=shift||'';
  my ($key,$value,$ret);
  $ret='';
  while (($key,$value)=each(%{$this})){
    $ret.="$prefix$key\t=\t$value\n";
  } 
  return $ret;
}

1;
