package Modules::DNS;

########## Confixx(R) 3.1 Professional ############
####### Copyright SWsoft, Inc. 2004-2005 ##########
#### http://www.swsoft.com - info@swsoft.com ####


use Exporter;

use strict;

my @ISA = 'Exporter';
my @EXPORT = qw( &getDirectZone &getSerienNumber );

sub getSerienNumber{
	my( $time, $ind ) = @_;

	if( $time && $time < 100 ){
		$ind = $time;
		$time = time();
	}

	$time = time() unless $time;

	if( $ind =~ /^\d\d?$/ ){
		$ind = sprintf( '%02d', $ind );
	}else{
		$ind = '01';
	}

	my( $year, $mon, $mday );
	($year,$mon,$mday) = (localtime( $time ))[5,4,3];
	$year += 1900;
  $mon++;

  my $serienNumber = sprintf( "%04d%02d%02d", $year, $mon, $mday ).$ind;

	return $serienNumber;

}

#
# make a zone file
#
# call:
#
# &getDirectZone( 'template' => $dns_template
#                 'domain' => $domain
#                 'pns' => $pns,
#                 'sns' => $sns,
#                 'ip_pns' => $ip_pns,
#                 'ip_sns' => $ip_sns
#                );
#
#
sub getDirectZone {
	my %args = (@_);
	
	my $zonefile = $args{'template'} || $args{'dnsspezial'} || $args{'dnstemplate'};
	my $domain = $args{'domain'};
	$zonefile =~ s/##domain##/$domain/g if $domain;

	my( $sns, $pns ) = &addEndDot( $args{'sns'}, $args{'pns'} );

  $zonefile =~ s/##ns1##/$pns/g if $pns;
  $zonefile =~ s/##ns2##/$sns/g if $sns;
  $zonefile =~ s/##ip##/$args{'ip'}/g if $args{'ip'};
		
	my( $snsDomain, $pnsDomain ) = map{ s/^[^.]+\.//; }( $sns, $pns );
	if( $args{'ip_pns'} && ( $pnsDomain eq $domain ) ){
		$zonefile = "$pns      86400  IN   A   ".$args{'ip_pns'}."\n".$zonefile;
	}
	if( $args{'ip_sns'} && ( $snsDomain eq $domain ) ){
		$zonefile = "$sns      86400  IN   A   ".$args{'ip_sns'}."\n".$zonefile;
	}

	return $zonefile;
}

sub addEndDot{
	my @ret = map{ $_ .= '.' unless /^(\d{1,3}\.){3}\d{1,3}$/; $_ } @_;
	if( @_ == 1 ){
		return shift @ret;
	} else {
		return @ret;
	}
}
1;
