package Modules::File;

########## Confixx(R) 3.1 Professional ############
####### Copyright SWsoft, Inc. 2004-2005 ##########
#### http://www.swsoft.com - info@swsoft.com ####

sub new {
	my $class = shift;
	my $this = {
		'stack_'	=> [],
	};
	return bless ($this, $class);
}

sub initObj($) {
	my $this = shift;
	my ($obj) = @_;
	
	if ($obj->create) {
		push (@{$$this{'stack_'}}, $obj);
		return $obj;
	}
	return (undef);
}

sub createDir($$) {
	my $this = shift;
	
	use Modules::File::Dir;
	my $obj = Modules::File::Dir->new(@_);
	return $this->initObj($obj);
}

sub createTempDir($) {
	my $this = shift;
	
	use Modules::File::TempDir;
	my $obj = Modules::File::TempDir->new(@_);
	return $this->initObj($obj);
}

sub createSoftLink($$) {
	my $this = shift;
	
	use Modules::File::SoftLink;
	my $obj = Modules::File::SoftLink->new(@_);
	return $this->initObj($obj);
}

sub destroy2 {
	my $this = shift;
	
	foreach my $obj (reverse @{$$this{'stack_'}}) {
		print $obj->name.':'.($obj->is_broken() + 0)."\n";
		$obj->rollback_creation if ($obj->is_broken());
	}
}

sub DESTROY {
	my $this = shift;
	
	my $aref = $$this{'stack_'};
#	print "D: number of elements in stack: ". ($#{$aref} + 1) . "\n";
	foreach my $obj (reverse @$aref) {
#		print "rollback\n";
#		print $obj->name.':'.($obj->is_broken() + 0)."\n";
		$obj->rollback_creation() if ($obj->is_broken());
	}
}

# Class-wide methods


1;
