package Modules::File::Proc;

########## Confixx(R) 3.1 Professional ############
####### Copyright SWsoft, Inc. 2004-2005 ##########
#### http://www.swsoft.com - info@swsoft.com ####

BEGIN {
	use Exporter;
	@ISA = qw(Exporter);
	@EXPORT = qw(&removeDir &cnx_copy);
}

use File::Path;

use Modules::ConfixxLog;
use Modules::System;

sub removeDir {
	return &cnx_remove(@_);
}

sub cnx_remove {
	my ($file) = @_;

	print "remove file: $file\n";

	unless (-e $file) {
		&error("File '$file' doesn't exist\n");
		return 1;
	}
	
	if (-d $file && ! -l $file) {
		&rmtree($file); 
		return &error("Unable to remove directory '$file'") if (-d $file);
	} else {
		unlink($file) 
			or return &error("Unable to remove file '$file'");
	}
	
	return 1;
}

# argumenst: f1, d2, f3, destination

sub cnx_copy {
	my ($source, $dest) = @_;
	unless (&exec_sys_util('cp', ['-rf', $source, $dest])) {
		return &error("Unable to copy file '$source' to '$dest'");
	}
	return 1;
}

END {
}
1;
