package Modules::File::SoftLink;

########## Confixx(R) 3.1 Professional ############
####### Copyright SWsoft, Inc. 2004-2005 ##########
#### http://www.swsoft.com - info@swsoft.com ####

use Modules::File::Created;
@ISA = qw/Modules::File::Created/;

sub new {
	my $class = shift;
	my ($dest, $orig) = @_;
	$this = { 'orig' => $orig, 'dest' => $dest};
	return bless($this);
}

sub create {
	my $this = shift;
	
	if (-l $$this{'dest'}) {
		warn("File '$$this{'dest'}' already exists");
		return $this->set_created(1);
	}
	use Modules::System;
	unless (&exec_sys_util("ln", ["-s", $$this{'orig'}, $$this{'dest'}])) {
		warn("Unable to create symbolic link '$$this{'dest'}': $!\n");
		return $this->set_created(0);
	}
	return $this->set_created(1);
}

sub remove {
	my $this = shift;
	if ($this->is_created()) {
		unless (unlink $$this{'dest'}) {
			warn("Unable to remove symbolic link '$$this{'dest'}': $!\n");
			return 0;
		}
	}
	return 1;
}

sub name {
	my $this = shift;
	return $$this{'dest'};
}

sub rollback_creation {
	my $this = shift;
	return $this->remove;
}

1;
