package Modules::File::TempDir;

########## Confixx(R) 3.1 Professional ############
####### Copyright SWsoft, Inc. 2004-2005 ##########
#### http://www.swsoft.com - info@swsoft.com ####

use Modules::File::Created;
@ISA = qw/Modules::File::Created/;

sub new {
	my $class = shift;
	my ($template) = @_;
	$this = { 'template' => $template, 'dir' => $template};
	return bless($this);
}

sub create {
	my $this = shift;
	use File::Temp qw/ :mktemp  /;
	my $tmp = &mkdtemp($$this{'template'});
	unless (defined $tmp) {
		warn("Unable to create temp.dir.: $!\n");
		return $this->set_created(0);
	}
	$$this{'dir'} = $tmp;
	return $this->set_created(1);
}

sub remove {
	my $this = shift;
	if ($this->is_created()) {
		use Modules::File::Proc;
		unless (&removeDir($$this{'dir'})) {
			warn("Unable to remove temp.dir.: $!\n");
			return 0;
		}
	}
	return 1;
}

sub name {
	my $this = shift;
	return $$this{'dir'};
}

sub rollback_creation {
	my $this = shift;
	return $this->remove;
}

1;


