package Modules::Restore::Tables::Table_dns;

########## Confixx(R) 3.1 Professional ############
####### Copyright SWsoft, Inc. 2004-2005 ##########
#### http://www.swsoft.com - info@swsoft.com ####


use DBI;
use XML::DOM;
use XML::DOM::NodeList;

use strict;

use Modules::DNS;

use Modules::Restore::Map;
use Modules::Restore::Tables::Common;
use Modules::Restore::Tables::Table_admin;
use Modules::Restore::DumpConfXML;
use Modules::Restore::DumpDoc;

my $href_admin;
my $href_old_admin;
my $serienNumber;
my $oldPnsIP;
my $oldSnsIP;

sub pre_restore_tab($$$$) {

  my( $tblName, $ptrConfXML, $clean, $xmlTable ) = @_;
  unless( $tblName && ref($ptrConfXML) =~ /DumpConfXML/ ){
    print STDERR "Modules::Restore::Tables::Table_anbieter::pre_restore_tab : wrong arguments ($tblName,..)\n";
    return 1;
  }

  $href_admin = $Modules::Restore::Tables::Table_admin::ptrAdmin;
	$href_old_admin = \%Modules::Restore::Tables::Table_admin::oldAdmin;

  my $sth;

  unless( ref( $href_admin ) =~ /HASH/ ){
    $sth = $main::dbh->prepare( "SELECT dnstemplate, ip_pns, ip_sns, standardip ".
																" FROM admin WHERE server_id='$::ServerID'" );
    $sth->execute or
			die("Error #0201: Can not restore 'anbieter' table: $DBI::errstr\n");

    $href_admin = $sth->fetchrow_hashref;
    $sth->finish;
  }

  $serienNumber = &Modules::DNS::getSerienNumber();;

  return 1;
}

sub restore_row($$$) {
  my( $table_name, $ptrRow,$ptrTable ) = @_;

  my( $oldIP, $key, $newRes, $sql, $sth, $newIP );

	my $oldUser = $ptrRow->{'kunde'};
  $key = "user($oldUser).name";
	my $newUser = $main::map->get_attr( $key );

	unless( $newUser ){
		print STDERR "Error: Table_dns: new user'name of '$oldUser' is not found\n";
		return 1;
	}

	$sql = "SELECT ip,anbieter FROM kunden WHERE kunde='$newUser'".
		" AND server_id='$::ServerID'";
  $sth = $main::dbh->prepare( $sql );
	if( $sth->execute ){
		( $newIP, $newRes ) = $sth->fetchrow;
		$sth->finish;
	}
	
  $sql = "SELECT dnsspezial,pns,sns,standardip FROM anbieter ".
		" WHERE server_id='$::ServerID' AND anbieter='$newRes'";
	$sth = $main::dbh->prepare( $sql );

  unless( $sth->execute ){
    print STDERR "Error: Table_dns: unable to exequte request: '$sql'\n$DBI::errstr\n";
    return 1;
  }

  unless( $sth->rows ){
		$sth->finish;
    print STDERR "Error: Table_dns: Reseller '$newRes' is not found\n";
    return 1;
  }

  my( $dnsspezial, $pns, $sns, $stdip ) = $sth->fetchrow;
  $sth->finish;

	if( $stdip eq 'standard' ){
		$stdip = $href_admin->{'standardip'};
	}
	unless( $newIP ){
		$newIP = $stdip;
	}
	
	my $dnstemplate = $href_admin->{'dnstemplate'};

	my $ip_pns = $href_admin->{'ip_pns'};
	my $ip_sns = $href_admin->{'ip_sns'};

	my $oldDomain = $ptrRow->{'domain'};
  $key = "domain($oldDomain).name";
	my $newDomain = $main::map->get_attr($key) || $oldDomain;

	if( $ptrRow->{'zonefile'} =~ /\*\.\Q$oldDomain\E\.\s+\d+\s+IN\s+A\s+((?:\d+\.){3}\d+)/g){
		$oldIP = $1;
	}

	if( ( $ip_pns eq $href_old_admin->{'ip_pns'} ) &&
			( $ip_sns eq $href_old_admin->{'ip_sns'} ) &&
			( $newDomain eq $oldDomain ) &&
			( $newIP eq $oldIP ) ){

		print STDERR "Table_dns: domain '$oldDomain' is unchanged. Remake the direct DNS sone is skiped\n" if $::DEBUG > 1 ;

		return 1;
	}

	unless( $dnstemplate ){
		print STDERR "Error: Table_dns: DNS-template is not found\n";
		return 1;
	}


	my $zonefile = &Modules::DNS::getDirectZone( 'template' => $dnstemplate,
																							 'domain' => $newDomain,
																							 'ip' => $newIP,
																							 'pns' => $pns,
																							 'sns' => $sns,
																							 'ip_sns' => $href_admin->{'ip_sns'},
																							 'ip_pns' => $href_admin->{'ip_pns'},
																						 );

  $ptrRow->{'zonefile'} = $zonefile;
  $ptrRow->{'lastchange'} = $serienNumber;

  return 1; ## goto common part

}

END {
	$href_admin = undef;
	$href_old_admin = undef;
}

1;
