package Modules::Restore::Tables::Table_idnaliases;

########## Confixx(R) 3.1 Professional ############
####### Copyright SWsoft, Inc. 2004-2005 ##########
#### http://www.swsoft.com - info@swsoft.com ####

use DBI;

use vars qw($ptrTblDomains);

BEGIN {
  use Exporter;
  @ISA = qw(Exporter);
  @EXPORT = qw( &restore_row($$$) &pre_restore_tab($$$$) );
  $ptrTblDomains = undef;
}

END {
  $ptrTblDomains = undef;
}

use strict;


use Modules::Restore::Map;
use Modules::Restore::Service;
use Modules::Restore::Table;
use Modules::Restore::DumpConfXML;
use Modules::Restore::DumpDoc;

use Modules::Restore::Tables::Common;
use Modules::Restore::Tables::Table_domains;

sub pre_restore_tab($$$$) {
  my ($table_name, $ptrConfXML,$clean,$xmlTable) = @_;

  unless ($table_name && ref($ptrConfXML)=~/DumpConfXML/){
    print STDERR "Table_idnaliases : wrong arguments ($table_name,..)\n";
    return 1;
  }

  my ($table,$tblName,$tbl,$key);
  return 1 unless $table=$ptrConfXML->getTable($table_name);
  return 1 unless (ref($table)=~/Table/);
  
  $ptrTblDomains = $ptrConfXML->getTable('domains');
  unless(ref($ptrTblDomains)=~/Table/){
    print STDERR "Error: Table_idnaliases: table 'domains' is not found\n";
    return 1; 
  }

  my $attrSet = $table->getFieldAttrSet('idn_name');
  if (ref($attrSet)=~/HASH/){
    if($attrSet->{'type'}=~/url/){
      $attrSet->{'type'}='';  ## clean type if it is 'url'
                              ## to skipp default handler for URL 
    }
  }
  return 1; ## go to common part;
}

sub restore_row($$$){
  my ($table_name, $ptrRow, $ptrTable) = @_;

  return 1 unless (ref($ptrTable)=~/Table/);

  if(ref($ptrTblDomains)=~/Table/){
    my($oldDomainID,$oldIdnName,$newDomainID,$sql,$sth,$DomainName,$newIdnName);
    $oldDomainID = $ptrRow->{'domain_id'};
    $oldIdnName = $ptrRow->{'idn_name'};
    $newDomainID=$ptrTblDomains->getMappedValue('id',$oldDomainID);
    if ($newDomainID){
      $sql = "SELECT domain FROM domains WHERE server_id='$::ServerID' AND id=$newDomainID";
      $sth = $main::dbh->prepare($sql);
      if( $sth->execute ){
				($DomainName) = $sth->fetchrow;
      }
      $sth->finish;
      if( $DomainName ){
				my( @idnChunks, $domChunk, $idnChunk);
				my @domChunks = split( /\./, $DomainName );
				my @tmpChunks = split( /\./, $oldIdnName );
				my $err = 0;
				foreach $domChunk (@domChunks) {
					$idnChunk = shift @tmpChunks;
					if( $domChunk =~ /^xn--/ ){
						unless( $idnChunk =~ /[^-a-zA-Z0-9_]/ ){
							$err++;
						}
						push @idnChunks, $idnChunk;
					}else{
						push @idnChunks, $domChunk;
					}
				}
				if( $err ){
					print STDERR "Error: Table_idnaliases: domains are different '$DomainName' - '$oldIdnName'\n";
				}
				$newIdnName = join('.',@idnChunks);
				$ptrRow->{'idn_name'} = $newIdnName;
      }
    }
  }

  return 1; ## go to common part
}

1;
