package Modules::Restore::Tables::Table_pop3;

########## Confixx(R) 3.1 Professional ############
####### Copyright SWsoft, Inc. 2004-2005 ##########
#### http://www.swsoft.com - info@swsoft.com ####

use XML::DOM;
use XML::DOM::NodeList;

use strict;

use Modules::Restore::Map;
use Modules::Restore::Tables::Common;
use Modules::Restore::Tables::Table_admin;
use Modules::Restore::Table;
use Modules::Restore::DumpConfXML;
use Modules::Restore::DumpDoc;


sub pre_restore_tab($$$$){
  my ($table_name, $ptrConfXML,$clean,$xmlTable) = @_;

  return 1 unless ( ref( $xmlTable ) =~ /XML/ ); ## check argument
  return 1 unless ( ref( $ptrConfXML ) =~ /DumpConfXML/ ); ## check argument
  my $tblPop = $ptrConfXML->getTable( 'pop3' );
  return 1 unless ( ref( $tblPop ) =~ /Table/ ); ## check argument


#  print STDERR "pre restore table 'pop3'\n" if $::DEBUG;

  my ($kid,$ptrRow,$oldName,$oldID,$newName,$tblName,$table,
      $oldUser,$key,$suff,$oldKunde,$newKunde,$newUID,$oldUID);

  my $maxUID = $main::map->LastUID();
  foreach $kid ( $xmlTable->getChildNodes() ){

    next unless( $kid->getNodeType == ELEMENT_NODE );
    next unless( $kid->getNodeName() eq 'row' );

    $ptrRow = $main::objDumpDoc->decode_row( $kid );
    next unless( ref( $ptrRow ) =~ /HASH/ );

    $oldName = $ptrRow->{'account'};
    $oldKunde = $ptrRow->{'kunde'};
    $oldUID = $ptrRow->{'uid'};
    next unless( $oldName =~ /(\S+)(p\d+)$/ );
    $suff = $2;

    if( $clean ){

      $maxUID = $main::map->ReplaceUID( $oldUID );
      if( $newKunde = $::map->get_attr( "user($oldKunde).name" ) ){
				$newName = $newKunde.$suff;
				$main::map->add_attr( "user($oldName).name", $newName );
      }else{
				$main::map->add_attr( "user($oldName).name", $oldName );
      }
    }else{

      $key = "user($oldName).name";
      unless( $main::map->get_attr( $key ) ){

				$key = "user($oldKunde).name";
				next unless ( $newKunde = $main::map->get_attr( $key ) );

				$newName = $newKunde.$suff;

				$maxUID++;
				$main::map->LastUID( $maxUID );
				$main::map->add_attr( "user($oldName).name", $newName );
				$tblPop->addToMap( 'account', $oldName, $newName );

      }
    }
    $key = "user($oldName).uid";
    $newUID = $main::map->get_attr( $key );
    if( $newUID ){
      $main::map->LastUID( $newUID );
      $main::map->add_attr( "user($oldUID).uid", $newUID );
    }else{
      $main::map->add_attr( "user($oldName).uid", $maxUID );
      $main::map->add_attr( "user($oldUID).uid", $maxUID );
      $tblPop->addToMap( 'uid', $oldUID, $maxUID );
    }
  }

  if( $clean ){
#
# delete old accounts
#
		my $userCurrent = ($::map->get_rule('user(*).default') == $ASSIGN_CURRENT );
		my $resellerCurrent = ($::map->get_rule('reseller(*).default') == $ASSIGN_CURRENT );

    my ($sql,$sth,$userPrefix,$user,$account,$res,$where);

    $userPrefix = $Modules::Restore::Tables::Table_admin::newUserPrefix
      ||$::user_prefix;

    $sql = "SELECT account,kunde,anbieter FROM pop3 WHERE server_id='$::ServerID'";
		
		if( $resellerCurrent ){
			$where = "anbieter != 'res0'";
		}elsif( $userCurrent ){
			$where = "kunde != '$userPrefix"."0'";
		}

		$sql .= ' AND '.$where if $where;

    $sth = $main::dbh->prepare( $sql );
    if( $sth->execute() ){
      while( ( $account, $user, $res ) = $sth->fetchrow ){
				$sql = "INSERT INTO delaccs (account,anbieter,kunde,type,server_id) ".
					" VALUES( '$account','$res','$user','pop3','$::ServerID' )";
				$main::dbh->do($sql);
      }
      $sth->finish;
    }
  }
  return 0;
}

sub restore_row($$$) {
  my ($table_name, $ptrRow,$ptrTable) = @_;

#
# map name
#
  my $newValue;
  my $oldAccount = $ptrRow->{'account'};
  my $key = "user($oldAccount).name";
  if( $newValue = $main::map->get_attr( $key ) ){
    $ptrRow->{'account'} = $newValue;
  }

#
# map uid
#
  $key = "user($oldAccount).uid";
  my $oldUID = $ptrRow->{'uid'};
  $newValue = $main::map->get_attr( $key );
  if( $newValue =~ /\d+/ ){
    $ptrRow->{'uid'} = $newValue;
  } else {
    if( $oldUID =~ /\d+/ ){
      $newValue = $main::map->ReplaceUID( $oldUID );
      $ptrRow->{'uid'} = $newValue;

      $main::map->add_attr($key,$newValue);
    }
  }
  $main::map->add_attr( "user($oldUID).uid", $ptrRow->{'uid'} );

  $ptrRow->{'neu'} = 1;  ## mark as "new"

  return 1; ## next Common-part

}

return 1;
