#!/usr/bin/perl
	
########## Confixx(R) 3.0 Professional ############
####### Copyright SWsoft, Inc. 2004-2005 ##########
#### http://www.sw-soft.com - info@sw-soft.com ####

use LWP::Simple;
use XML::DOM;

use lib_module_common;

our $dbh;

sub insertVersionIntoDB {
	my ($version, $distrib_type, $download_url, $description_url, 
			$description_text, $release_date) = @_;
	if ( $scriptdebug ) {
		my $subname = (caller(0))[3];
		print "SUB: $subname($version, $distrib_type, $download_url, $description_url, description_text, $release_date)\n";
	}

	my $sth_count = $dbh->prepare("SELECT COUNT(*) FROM updates WHERE version = ?");

	$sth_count->execute($version) or &soft_error("#2170: $DBI::errstr");

	my ($count) = $sth_count->fetchrow_array;

	unless ( $count ) {
		my $sth_add = $dbh->prepare("INSERT INTO updates (version, type, download_url, description_url, description_text, release_date,server_id) VALUES (?, ?, ?, ?, ?, ?, ?)");
		if ( $sth_add->execute($version, $distrib_type, $download_url, $description_url, 
													 $description_text, $release_date, $ServerID ) )	{
			if ( $scriptdebug ) {
				print "New version: $version $distrib_type\n";
			}
		}	else	{
			&soft_error("#2171: $DBI::errstr");
		}
	}
}

sub checkNewVersion {
	if ( $scriptdebug )  {
		my $subname = (caller(0))[3];
		print "SUB: $subname\n";
	}

	$dbh->do("update allgemein set checknewversion = " . time) or 
		&soft_error("#2172: $DBI::errstr");


	my $content;

	unless( defined ( $content = get $new_version_url ) )    {
		&soft_error("#1217: fail download url: $new_version_url");
		return;
	}


		#print "$content\n\n";

    #$content .= "sgfs";

	my $parser = new XML::DOM::Parser;
	
	my $doc;

	eval  {
		$doc = $parser->parse($content);
	};
	my $err = $@;
	if ( $err )    {
		#print $err;
		&soft_error("#1218: fail parsing xml: $err");
		return;
	}
		
	#my $doc = $parser->parse($content);
		

	my $nodes = $doc->getElementsByTagName ("VERSION");
	my $n = $nodes->getLength;

	#print "$n\n";

	for (my $i = 0; $i < $n; $i++) {
		my $node = $nodes->item ($i);
		
		my $version = $node->getAttribute("NUM");
		my $type = $node->getAttribute("TYPE");
		my $dow_url = $node->getAttribute("DOWNLOAD_URL");
		my $rel_date = $node->getAttribute("RELEASE_DATE");
		my $desc_url = $node->getAttribute("DESCRIPTION_URL");

		my $te = $node->getFirstChild;
		my $desc_text = $te->toString;
	
		insertVersionIntoDB($version, $type, $dow_url, $desc_url, $desc_text, $rel_date);
	}	
}


			     

#sub getParValue
#{
#    my ($tag, $par, $cont) = @_;
#    if($scriptdebug)
#    {
#	my $subname = (caller(0))[3];
#	print "SUB: $subname ($tag, $par)\n";
#    }
#    my $tc;
#    
#    if( $cont =~ /<$tag[^>]+$par="([^"]*)"[^>]*>/ )
#    {
#	#print $1 . "\n";
#	$tc = $1;
#    }
#    
#    return $tc
#}
#
#sub getTagValue
#{
#    my ($tag, $cont) = @_;
#    if($scriptdebug)
#    {
#	my $subname = (caller(0))[3];
#	print "SUB: $subname ($tag)\n";
#    }
#    my $tc;    
#    if( $cont =~ /<$tag>(.*)<\/$tag>/s )
#    {
#	#print "$1\n";
#	$tc = $1;
#    }
#    
#    return $tc;
#}

1;
