BEGIN {
	use FindBin;
	use File::Basename;

	use lib $FindBin::Bin=~s%(?<=.)/$%%?$FindBin::Bin:$FindBin::Bin;
	use lib dirname( dirname( $FindBin::Bin )); # = $installDir 
}

package lib_module_webapp;

use Exporter;
use Cwd;
use File::Copy;
use File::Path;

use DBI;

use lib_module_common;

use lib_module_db;
use lib_module_events;
use lib_module_messaging;
use Modules::System;

use strict;
use vars qw(@ISA @EXPORT @EXPORT_OK);


@ISA = qw( Exporter );

@EXPORT = qw/&deinstallWebapp &installWebapp/;

my( $DEBUG );

sub deinstallWebapp{
	my( $dbh, $force ) = @_;

  if( $::scriptdebug ){
    my $subname = (caller(0))[3];
    print "SUB: $subname\n";
  }

	my $ptrHash = &lib_module_events::getEventsCount( $dbh, $::OBJECT_WEBAPP, $::EVENT_DELETE );
	&cleanEvents( $dbh, $ptrHash );
	unless( keys %{$ptrHash} || $force ){
		return 0;
	}
	my( $cnt, $dbhMysql, $domPath, $user, $userDocRoot,
			$htmlDir, $cgiDir, $dir, $total );
	if( $::mysqlUserServer && $::mysqlUserUser ){
		my $dsn = makeDSN('mysql', $::mysqlUserServer, 'mysql', $::mysqlUserPort );
		$dbhMysql = DBI->connect( $dsn, $::mysqlUserUser, $::mysqlUserPw );
	}
	my $sthDb = $dbh->prepare( "SELECT COUNT(*) FROM mysql_datenbanken ".
														 " WHERE kunde=? AND server_id='$::ServerID' AND dbname=?" );
	my $sthDomain = $dbh->prepare( "SELECT pfad FROM domains ".
																 " WHERE kunde=? AND server_id='$::ServerID' AND id=?" );
	
	my $sth = $dbh->prepare( "SELECT id, webapp_id, kunde, domain_id, clean_db, clean_files, db, path FROM webapp_user ".
													 " WHERE server_id='$::ServerID' AND status=3" );
	unless( $sth->execute ){
		&soft_error( "Error sql query: $DBI::errstr" );
		return undef;
	}
	$total = 0;
	while( my $ptrRow = $sth->fetchrow_hashref ){
		$user = $ptrRow->{'kunde'};
		if( $ptrRow->{'clean_db'} && $ptrRow->{'db'} && $dbhMysql ){

			$sthDb->execute( $user, $ptrRow->{'db'} );
			($cnt) = $sthDb->fetchrow;
			$sthDb->finish();

			if( $cnt ){
				$dbhMysql->do( "DROP DATABASE ".$ptrRow->{'db'} );
				$dbhMysql->do( "CREATE DATABASE ".$ptrRow->{'db'} );
			}
		}

		if( $ptrRow->{'clean_files'} && $ptrRow->{'path'} &&
				$ptrRow->{'domain_id'} ){

			$sthDomain->execute( $user, $ptrRow->{'domain_id'} );
			( $domPath ) = $sthDomain->fetchrow();
			$sthDomain->finish();

			if( $domPath =~ s|^/|| ){
				$userDocRoot = "$::user_homeDir/$user/html";
				$domPath =~ s|/$||;

				$htmlDir = join( '/', $userDocRoot, $domPath, $ptrRow->{'path'} );
				$cgiDir = join( '/', ( $::local_cgi? "$userDocRoot/$domPath": $userDocRoot ), 'cgi-bin', $ptrRow->{'path'} );
				foreach $dir ( $htmlDir, $cgiDir ){
					next unless -d $dir;
					next if -l $dir;
					rmtree( $dir );
				}
			}
		}

		$dbh->do( "DELETE FROM webapp_user WHERE server_id='$::ServerID' AND id=".$ptrRow->{'id'} );
		$total++;
	}
	$sth->finish;
	return $total;
}

sub installWebapp{
	my( $dbh, $force ) = @_;

  if( $::scriptdebug ){
    my $subname = (caller(0))[3];
    print "SUB: $subname\n";
  }

	my $ptrHash = &lib_module_events::getEventsCount( $dbh, $::OBJECT_WEBAPP, $::EVENT_NEW );
	&cleanEvents( $dbh, $ptrHash );
	unless( keys %{$ptrHash} || $force){
		return 0;
	}

	my $srcDir = $::siteappsDir;
	unless( -d $srcDir ){
		&soft_error( "Error: dir '$srcDir' is not found" );
		return undef;
	}
	my $script = $::installDir.'/admin/siteapps/install.pl';
	unless( -x $script ){
		&soft_error( "Error: script '$script' is not found" );
		return undef;
	}
	my ($total, $cmd, $ret );
	my $sth = $dbh->prepare( "SELECT u.webapp_id, u.kunde, w.name, u.anbieter, u.id ".
													 " FROM webapp_user u, webapp w".
													 " WHERE u.server_id=w.server_id AND u.webapp_id=w.id ".
													 " AND u.status=1 AND w.status=1 AND u.server_id='$::ServerID'" );
	unless( $sth->execute ){
		&soft_error( "Error sql query: $DBI::errstr" );
		return undef;
	}
	$total = 0;
	my $cwd = getcwd();
	if( chdir( $srcDir  ) ){
		while( my( $webapp_id, $user, $webapp, $res, $id ) = $sth->fetchrow ){

			$cmd = $script." -u $user -w $webapp_id -s $srcDir";

			if( $ret = system( $cmd ) ){

				&soft_error( "mlf||wa_err_install||$webapp||$user" );
				&soft_error( "mlf||wa_err_install||$webapp||$user", $res, $user );

				$dbh->do( "UPDATE webapp_user SET status=0 ".
									" WHERE id=$id AND server_id='$::ServerID'" );
			}else{
				$total++;
			}
		}
		chdir $cwd;
	}else{
		&soft_error( "Error chdir '$srcDir': $!");
	}
	$sth->finish();

	return $total;
}

sub updateWebapps{
	my( $dbh, $force ) = @_;

  if( $::scriptdebug ){
    my $subname = (caller(0))[3];
    print "SUB: $subname\n";
  }


	my $ptrHash = &lib_module_events::getEventsCount( $dbh, $::OBJECT_WEBAPP, $::EVENT_UPDATE );
	&cleanEvents( $dbh, $ptrHash );
	unless( keys %{$ptrHash} || $force){
		return 0;
	}

	my $srcDir = $::siteappsDir;
	unless( -d $srcDir ){
		&soft_error( "Error: dir '$srcDir' is not found" );
		return undef;
	}

	my( $cmd, $ret );
	
	my $script = $::installDir.'/admin/siteapps/extract.pl';
	if( -x $script ){
		$cmd = "$script -src $srcDir -dst $srcDir";
		if( $ret = system( $cmd ) ){
			&soft_error( "mlf||wa_err_extract" );
		}
	}else{
		&soft_error( "Error: script '$script' is not found" );
		return undef;
	}

	$script = $::installDir.'/admin/siteapps/analyse.pl';
	if( -x $script ){
		my $cwd = getcwd();
		if( chdir( $srcDir  ) ){
			$cmd = "$script -src $srcDir";
			if( $ret = system( $cmd ) ){
				&soft_error( "mlf||wa_err_analyse" );
			}
			chdir $cwd;
		}else{
			&soft_error( "Error chdir '$srcDir': $!");
		}
	}else{
		&soft_error( "Error: script '$script' is not found" );
		return undef;
	}
	
}

1;
