#!/usr/bin/perl

########## Confixx(R) 3.0 Professional ############
####### Copyright SWsoft, Inc. 2004-2005 ##########
#### http://www.sw-soft.com - info@sw-soft.com ####

use lib_module_db;
use strict;

use vars qw/$dbType %bin $dbServer $dbRootUser $dbRootPw $dbPort 
						$dbUser $dbPw $dbDB/;

sub checkDbType {
	my $type = @_? shift: $dbType;

	my ($ret,$errmsg);

	unless ( $type ) {
		$type = &SelectQuestion( &ltext('install_question_selectdb') , 'MySQL', 'PostgreSQL');
		if ( $type eq 'MySQL' ) {
			$type = 'mysql';
		} else {
			$type = 'Pg';
		}
	}

  &checkAndInstallPkgs('DBI', "DBD::$type");
  
	($ret,$errmsg) = &loadPackage('DBI');
	if ( $ret ) {
		($ret,$errmsg) = &loadPackage('DBD::'.$type);
	}
	
	if ( wantarray() ) {
		return ($type, $errmsg);
	} else {
		return $type;
	}

}

sub configDbAccess {
	my ($type,$server,$db,$user,$pswd,$port,$DSN);
	if ( @_ ) {
		($server,$db,$user,$pswd,$port,$type) = @_;
	} else {
		$server = $dbServer;
		$user = $dbUser;
		$pswd = $dbPw;
		$port = $dbPort;
		$type = $dbType;
	}

	my $defaultServer = 'localhost';
	my $defaultUser = 'confixx';
	my $defaultDB = 'confixx';

	unless( $server ){
		$server = &ServerQuestion( &ltext('install_question_mysqlserver') , 
															 $server || $defaultServer);
	}
	my ($errmsg,$socket);

	unless ( $type ) {
		($type,$errmsg) = &checkDbType();
	}

	unless ( $db ) {
		$db = &Question( &ltext('install_question_mysqldb'),  $defaultDB);
	}
	unless ( $user ) {
		$user = &Question( &ltext('install_question_mysqluser_access', $db) , $defaultUser);
		$pswd = &Question( &ltext('install_question_mysqlpass', $user, $server),  '');
	}

	if($type eq 'mysql'){
		$socket = &getSocketPath();
	}

	if ($type eq 'mysql' && $server eq 'localhost' && !$port ) {
		$port = $socket;
	}

  if(&YesNoQuestion(&ltext('install_mysql_test', $server), 'j')){

		($DSN,$errmsg) = &checkDbConn($server,$db,$user,$pswd,$port,$type);

		unless ( $DSN  ) {
			my $loop = 1;
			print "Error: $errmsg\n";
			while ( $loop ) {
				if ( &YesNoQuestion( &ltext('install_question_mysqluser_perms', $user), 'j' ) ) {

					$server = &ServerQuestion( &ltext('install_question_mysqlserver'), $server );
		
					if ( $server eq 'localhost' && $type eq 'mysql' ) {
						$port = &SocketQuestion( &ltext('install_question_mysqlsocket'), $port );
					} else {
						$port = undef;
					}

					$user = &Question(&ltext('install_question_mysqluser_access', $server) , $user );
					$pswd = &Question(&ltext('install_question_mysqlpass', $user, $server), $pswd );

					($DSN,$errmsg) = &checkDbConn($server, $db, $user, $pswd, $port, $type);
					if ( $errmsg ) {
						print "Error: $errmsg\n";
					}
					$loop = $DSN?0:1;

				} else { ## exit from loop
					$DSN = &makeDSN( $type, $server, $db, $port );
					$loop = 0;
				}
			}
		}

	} else { ## don't test connection
		$DSN = &makeDSN( $type, $server, $db, $port );
	}

	return ($server,$db,$user,$pswd,$port,$type);

}

sub configRootDbAccess {

	my $type = shift;

	unless( $type =~ /^mysql|Pg$/ ){
		unshift @_, $type;
		$type = $dbType;
	}
	my ($server,$user,$pswd,$port,$DSN,$socket);

	if ( @_ ) {
		($server,$user,$pswd,$port) = @_;
	} else {
		$server = $dbServer;
		$user = $dbRootUser;
		$pswd = $dbRootPw;
		$port = $dbPort;
	}

	my $defaultServer = 'localhost';
	my $defaultUser = 'root';

	unless ( $server ) {
		$server = &ServerQuestion( &ltext('install_question_mysqlserver') , $defaultServer);
	}
	if($type eq 'mysql'){
		$socket = &getSocketPath();
		$port = ( $server eq 'localhost' )? $socket: undef;
	}

	unless( $user ){
		$user = &Question( &ltext( 'install_question_mysqluser_root', $server) , $defaultUser );
		$pswd = &Question( &ltext( 'install_question_mysqlpass', $user, $server ), ' ' );
	}
	
	my ($errmsg);

	if ( &YesNoQuestion( &ltext( 'install_mysql_test', $server ), 'j' ) ) {

		if( $type eq 'Pg' ){
			($DSN,$errmsg) = &checkDbConn($server,$user,$pswd,$port,$type);
		} else {
			($DSN,$errmsg) = &checkMysqlConn($server,$user,$pswd,$port);
		}

		unless ( $DSN  ) {
			my $loop = 1;
			print &ltext('install_error', $errmsg);
			while ( $loop ) {
        if( &YesNoQuestion( &ltext('install_question_mysqluser_perms', $user ), 'j' ) ) {

					$server = &ServerQuestion( &ltext('install_question_mysqlserver'), $server );

					if ( $server eq 'localhost' ){
						if($type eq 'mysql'){
							unless ( $port ) {
								$port = $socket;
							}
							$port = &SocketQuestion( &ltext('install_question_mysqlsocket'), $port );
						}
					} else {
						$port = undef;
					}

					$user = &Question( &ltext('install_question_mysqluser_root', $server), $user );
					$pswd = &Question( &ltext('install_question_mysqlpass', $user, $server), $pswd );


					if( $type eq 'Pg' ){
						( $DSN, $errmsg ) = &checkDbConn( $server, $user, $pswd, $port, $type);
					} else {
						( $DSN, $errmsg ) = &checkMysqlConn( $server, $user, $pswd, $port );
					}
					if ( $errmsg ) {
						print "Error: $errmsg\n";
					}
					$loop = $DSN? 0: 1;

				} else { ## exit from loop
					$DSN = &makeDSN( 'mysql', $server, 'mysql', $port );
					$loop = 0;
				}
			}
		}
	} else { ## don't test connection
		if( $type eq 'Pg' ){
			$DSN = &makeDSN( 'Pg', $server, $user, $port );
		} else {
			$DSN = &makeDSN( 'mysql', $server, 'mysql', $port );
		}
	}
	
	return ($server,$user,$pswd,$port);
	
}

sub configNewDbAccess {
	my ($db,$user,$pswd);
	if ( @_ ) {
		($db,$user,$pswd) = @_;
	} else {
		$db = $dbDB;
		$user = $dbUser;
		$pswd = $dbPw;
	}
	my $defaultDb = 'confixx' || $dbDB;
	my $defaultUser = 'confixx';
	my $defaultPswd = &::createRandPw();

	unless( $db ){
		$db = &Question( &ltext('install_question_mysqldb'),  $defaultDb );
	}

	if ( $dbRootUser && 
			 !&YesNoQuestion( &ltext('install_question_mysqluser_add', $dbRootUser), 'j')) {
		$user = $dbRootUser;
		$pswd = $dbRootPw;

	} else {
		$user = &Question( &ltext('install_question_mysqluser', $db) , $user || $defaultUser );
		$pswd ||= $defaultPswd;
#		$pswd = &Question(&ltext('install_question_mysqlpass', $user, $dbServer), 
#											$pswd || $defaultPswd );
	}
	return ($db,$user,$pswd);
}

sub checkDbConn {
	my ( $server, $db, $user, $pswd, $port, $type ) = @_;
	$type ||= $dbType;
	my $DSN = &makeDSN( $type, $server, $db, $port );

	my ( $dbh, $errmsg );

	open( OLDERR, ">&STDERR");
	open( STDERR, '>',\$errmsg);

	eval {
		$dbh = DBI->connect( $DSN, $user, $pswd );
	};

	close( STDERR );
	open( STDERR, ">&OLDERR" );

	if ( $dbh ) {
		$dbh->disconnect;
	} else {
		$errmsg = DBI->errstr;
		$DSN = undef;
	}

	if ( wantarray() ) {
		return ($DSN, $errmsg );
	} else {
		return $DSN;
	}
}


sub checkMysqlConn {
	my ( $server, $user, $pswd, $port ) = @_;

	my ($DSN,$errmsg) = &checkDbConn( $server, 'mysql', $user, $pswd, $port, 'mysql' );

	if ( wantarray() ) {
		return ($DSN, $errmsg );
	} else {
		return $DSN;
	}
}

sub getSocketPath {

	my ($socket,$path,$dir,$ptrHash,$name);
	my @defDirs = ( '/var/lib/mysql', '/var/mysql', '/var/run/mysqld', '/usr/local/data');
	my @defNames = ('mysql.sock','mysqld.sock');
	my @defPaths = ( '/etc/my.cnf','/etc/mysql/my.cnf' );

	foreach $dir ( @_ ) {
		if ( -d $dir ) {
			unshift @defDirs, $dir;
		} elsif ( -T $dir ) {
			unshift @defPaths, $dir;
		}
	}

	foreach $path (@defPaths) {
		$ptrHash = &parseMyCnf( $path, 'socket' );
		if ( $ptrHash ){
			$socket = $ptrHash->{'socket'};
		}
		if ( $socket && -S $socket ) {
			return $socket;
		}
	}

	foreach $dir ( @defDirs ) {
		next unless -d $dir;
		foreach $name ( @defNames ) {  
		  $path = $dir.'/'.$name;
  		  if ( -S $path ) {
			$socket = $path;
			return $socket;
		  }	
		}
	}
	
	return $socket;
}


1;
