#!/usr/bin/perl

use Socket;


########## Confixx(R) 3.0 Professional ############
####### Copyright SWsoft, Inc. 2004-2005 ##########
#### http://www.sw-soft.com - info@sw-soft.com ####


## UNTERPROGRAMME FUER CONFIXX INSTALLATION & KONFIGURATION


sub check_question_mode
{
 my($question) = @_;
 if( $no_questions_mode || $ENV{'NOQUESTION'}){
    print &ltext('install_no_question', $question);
    exit(1);
 }
}

sub Question{
  my ($question, $default) = @_;
  &check_question_mode($question);
  my ($answer);
  my $return = "";
  while($return eq ""){
    print "$question [$default]: ";
    $answer = <STDIN>;
    chop($answer);
    if($answer eq ""){
      $return = $default;
    }
    elsif($answer !~ /\s/){
      $return = $answer;
    }
    else{
      print &ltext('install_input_repeat');
    }
  }
  print &ltext('install_selected', $return);
  return ($return);
}


sub UGQuestion{
  my ($question, $default, $canZero, $UGexistance) = @_;
  &check_question_mode($question);
  my ($answer);
  my $return;
  my $loop = 1;
  while($loop){
    $return = "";
    print "$question [$default]: ";
    $answer = <STDIN>;
    chop($answer);
    if (  $answer eq "" ) {
    	$return = $default;
	$loop = 0;
    } elsif ( $answer !~ /\s/ && $answer =~ /^([a-zA-Z])/){
      $return = $answer;
	  $loop = 0;	  
    } else {
      print &ltext('install_input_repeat');
    }

    if ( ($loop == 0) && ($UGexistance eq 'user') ) {
	my $uid = getpwnam($return);
	if (defined $uid && $uid >= 0) {
#	    print &ltext('user_exist', $return);
	} else {
	    print &ltext('user_user_exist_no', $return);
	    $loop = 2 unless $canZero;
	}
    } elsif ( ($loop == 0) && ($UGexistance eq 'group') ) {
	my $gid = getgrnam($answer);
	if (defined $gid && $gid > 0) {
#	    print &ltext('group_exist', $return);	    
	} else {
	    print &ltext('group_exist_no', $return);
	    $loop = 2 unless $canZero;
	}
    }
  }
  print &ltext('install_selected', ( $return? $return: '[:blank:]' ) );
  return ($return);
}



sub PathQuestion{
  my ($question, $default) = @_;
  &check_question_mode($question);
  my ($answer);
  my $return = "";
  while($return eq ""){
    print "$question [$default]: ";
    $answer = <STDIN>;
    chop($answer);
    if($answer eq ""){
      $return = $default;
    }
    elsif(($answer !~ /\s/) && ($answer =~ /^\/\S+/) && ((-d "$answer") || !(-e "$answer"))){
      $return = $answer;
    }
    else{
      print &ltext('install_input_path');
    }
  }
  while($return =~ /.+\/$/){
    $return =~ s/\/$//g;
  }
  print &ltext('install_selected', $return);
  return ($return);
}


sub PassQuestion{
  my ($question, $default) = @_;
  &check_question_mode($question);
  my $return = "";
  while ($return eq "" || $return eq $default || $return !~ /^.{6,12}$/ || $return =~ /\s/){
    print "$question " . &ltext('install_input_nochars') . "[$default]: ";
    $return = <STDIN>;
    chop($return);
    if(($return eq "") || ($return eq $default)){
      print &ltext('install_input_defaultpw', $default);
    }
    if($return =~ /.{13}/){
      print &ltext('install_input_pw_long');
    }
    elsif($return ne "" && $return !~ /.{6}/){
      print &ltext('install_input_pw_short');
    }
  }
  print &ltext('install_selected', $return);
  return ($return);
}


sub FileQuestion{
  my ( $question, $default, $noanyway, $create ) = @_;
  &check_question_mode($question);
  my ($answer, $return);

  EXIT: {
    if ( ref($default) ){
      foreach ( @{$default} ){
	if ( -T ){
	  $default = $_;
	  last EXIT;
	}
      }
      $default = $default->[0];
    }
  }
  while (!(defined $return)){
    print "$question [$default]: ";
    $answer = <STDIN>;
    chop($answer);
    if ($answer eq ""){
      if (-T $default){
        $return = $default;
      }
      else{
        if(-e $default && (!(-r $default))){
          print &ltext('install_input_file_read', $default);
        }
        else{
          print &ltext('install_input_file_exist', $default);
        }
      }
    }
    elsif(-T $answer){
      if ($answer =~ /^\//){
        $return = $answer;
      }
      else{
        print &ltext('install_input_path');
      }
    }
    else{
      if(-e $answer && (!(-r $answer))){
        print &ltext('install_input_file_read', $answer);
      }
      else{
        if ( ! $noanyway ){
          print &ltext('install_input_file_text', $answer);
          if(&YesNoQuestion( &ltext('install_input_anyway', $answer) )){
            $return = $answer;
          }
        }
        elsif ( $create ){
          if(&YesNoQuestion( &ltext('install_input_create', $answer) )){
            $return = $answer;
            open ( FILE, ">", $answer );
            close (FILE);
          }
        }
        else{
          print &ltext('install_input_file_text', $answer);
        }
      }
    }
  }
  print &ltext('install_selected', $return);
  return ($return);
}


sub DirQuestion{
  my ($question, $default) = @_;
  &check_question_mode($question);
  my ($answer, $return);
  $return = "";
  while($return eq ""){
    print "$question [$default]: ";
    $answer = <STDIN>;
    chop($answer);
    if($answer eq ""){
      if(-d $default){
        $return = $default;
      }
      else{
        print &ltext('install_input_file_exist', $default);
      }
    }
    elsif(-d $answer){
      if($answer =~ /^\//){
        $return = $answer;
      }
      else{
        print &ltext('install_input_path');
      }
    }
  }
  while($return =~ /.+\/$/){
    $return =~ s/\/$//g;
  }
  print &ltext('install_selected', $return);
  return ($return);
}


sub BinQuestion{
  my ($question, $default) = @_;
  &check_question_mode($question);
  my ($answer, $return);
  while (!(defined $return)){
    print "$question [$default]: ";
    $answer = <STDIN>;

		last unless defined $answer; ## CTRL+C - to exit

    chop($answer);
    if ($answer eq ""){
      if (-x $default){
        $return = $default;
      }
      else{
        if(-e $default && (!(-x $default))){
          print &ltext('install_input_file_exec', $answer);
        }
        else{
          print &ltext('install_input_file_exist', $default);
        }
      }
    }
    elsif(-x $answer){
      if ($answer =~ /^\//){
        $return = $answer;
      }
      else{
        print &ltext('install_input_path');
      }
    }
    else{
      if(-e $answer && (!(-x $answer))){
        print &ltext('install_input_file_exec', $answer);
      }
      else{
        print &ltext('install_input_file_exist', $answer);
      }
    }
  }
  print &ltext('install_selected', $return);
  return ($return);
}

sub SocketQuestion{
  my ($question, $default) = @_;
  &check_question_mode($question);
  my ($answer, $return);
  while (!(defined $return)){
    print "$question [$default]: ";
    $answer = <STDIN>;

		last unless defined $answer; ## CTRL+C - to exit

    chop($answer);
    if ($answer eq ""){
      if (-S $default){
        $return = $default;
      }
      else{
        if(-e $default && (!(-S $default))){
          print &ltext('install_input_file_socket', $answer);
        }
        else{
          print &ltext('install_input_file_exist', $default);
        }
      }
    }
    elsif(-S $answer){
      if ($answer =~ /^\//){
        $return = $answer;
      }
      else{
        print &ltext('install_input_path');
      }
    }
    else{
      if(-e $answer && (!(-S $answer))){
        print &ltext('install_input_file_socket', $answer);
      }
      else{
        print &ltext('install_input_file_exist', $answer);
      }
    }
  }
  print &ltext('install_selected', $return);
  return ($return);
}



sub ServerQuestion{
  my ($question, $default) = @_;
  &check_question_mode($question);
  my ($answer, $return);
  while (!(defined $return)){
    print "$question [$default]: ";
    $answer = <STDIN>;
    chop ($answer);

    if ($answer eq ''){
      $return = $default;

    } else {
      if (gethostbyname($answer)){
        $return = $answer;

      } else {
        print &ltext('install_input_host_resolve', $answer);
      }
    }
  }
  print &ltext('install_selected', $return);
  return($return);
}


sub YesNoQuestion {
  my ($question, $default) = @_;
  &check_question_mode($question);
  my ($return);
  if (!(defined $default)){
    $default = "n";
  }
  if ($default eq "j"){
    print &ltext('install_input_default_yes', $question);
  }
  else{
    print &ltext('install_input_default_no', $question);
  }
  my $answer = <STDIN>;
  chop($answer);
  $answer =~ tr/A-Z/a-z/;
  if ($default eq "j"){
    if ($answer eq &ltext('install_no_short') || $answer eq &ltext('install_no_long')){
      $return = 0;
    }
    else{
      $return = 1;
    }
  }
  else{
    if ($answer eq &ltext('install_yes_short') || $answer eq &ltext('install_yes_long')){
      $return = 1;
    }
    else{
      $return = 0;
    }
  }
  print "\n";
  return($return);
}


sub SelectQuestion{
  my ($question, @args) = @_;
  &check_question_mode($question);
  my ($count, $selection, $return, $defaultIndex, @options, $lastOption, $text);
  print "$question\n";

	if ( ref($args[0]) =~ /ARRAY/ ) {
		@options  = @{$args[0]};
		$lastOption = @options;
		$defaultIndex = $args[1];
		if ( $defaultIndex =~ /^\d+$/ ) {
			if ( ( $defaultIndex >= 0 ) && ( $defaultIndex < $lastOption ) ) {
				$defaultIndex++;
			} else {
				$defaultIndex = undef;
			}
		} else {
			my $i = 0;
			my $found=0;
			foreach my $opt (@options){
				$i++;
				if( $opt eq $defaultIndex ){
					$found = 1;
					last;
				}
			}
			$defaultIndex = $found? $i: undef;
		}

	} else {
		@options = sort { uc($a) cmp uc($b) } @args;
		$lastOption = @options;
	}
  
  if ( scalar( @options ) == 1 ) {
		$selection = 0;
  	$return = $options[0];

  } else {
		while ( !(defined $return) ) {
			for ( $count = 1; $count <= $lastOption; $count++ ) {
				if ( $count < 10 ) {
					print "  ($count) $options[$count-1]\n";
				}
				else{
					print " ($count) $options[$count-1]\n";
				}
			}

			$text = &ltext('install_input_choose', $lastOption);
			if ( $defaultIndex ){
				$text =~ s/(:\s*)?$/\($defaultIndex\)$1/;
			}
			print $text;

			$selection = <STDIN>;
			chop($selection);

			if ( defined($selection) && $defaultIndex && !$selection ) {
				$selection = $defaultIndex;
			}
			if ( ( $selection =~ /^\d+$/ ) && 
					( 1 <= $selection ) && ( $selection <= $lastOption ) ) {
				$selection--;
				$return = $options[$selection];

			}	else {
				print &ltext('install_input_error_choose', $lastOption);
			}
		}
	}

  print &ltext('install_selected', $return);
	if ( wantarray() ) {
		return ( $return,  $selection );
	} else {
		return $return;
	}
}

sub header2{
  my ($header) = @_;
  my ($length, $count, $fix, $space);
  $fix = 35;
  $length = length($header);
  if($length > $fix){
    $fix = $length + 2;
  }
  $space = int(( $fix - $length ) / 2);
  for($count=1; $count <= $fix; $count++){
    print "#";
  }
  print "\n";
  for($count=1; $count <= $space; $count++){
    print " ";
  }
  print "$header    \n";
  for($count=1; $count <= $fix; $count++){
    print "#";
  }
  print "\n\n";
}

1;
## /UNTERPROGRAMME FUER CONFIXX INSTALLATION & KONFIGURATION
