#!/usr/bin/perl

########## Confixx(R) 3.0 Professional ############
####### Copyright SWsoft, Inc. 2004-2005 ##########
#### http://www.sw-soft.com - info@sw-soft.com ####


BEGIN {
  use FindBin;
  use lib $FindBin::Bin;
  use lib $FindBin::Bin.'/../scripts';
	use lib $FindBin::Bin.'/subs';
}

## Pre-Main
use File::Basename;
use File::Copy;

use lib_module_db;
use lib_module_common;

use vars qw/$wDir/;

use strict;

&initConfig();


if ($confixxState =~ /(install|update)/) {

	if ( -d "$wDir/subs" ){ ## configure & install

	    safe_do "$wDir/subs/subs_include_questions.pl";
	    safe_do "$wDir/subs/subs_include_vsftpd.pl";

	} elsif ( -d "$wDir/../subs" ) { ## update

	    safe_do "$wDir/../subs/subs_include_questions.pl";
	    safe_do "$wDir/../subs/subs_include_vsftpd.pl";
	}    
    
} else {
    $wDir = dirname($0);

    unless (-e "$wDir/vsftpd_install.pl"){
	$wDir = "$installDir/admin/subs";
    }

    safe_do "$wDir/subs_include_questions.pl";
    safe_do "$wDir/subs_include_writeConfig.pl";
    safe_do "$wDir/subs_include_files.pl";
    safe_do "$wDir/subs_include_vsftpd.pl";
}


&header2( &ltext('install_header_ftp', 'vsftpd') );

if ( $ftpDaemon ne 'vsftpd' ||  
		 ( -T "$wDir/../.config" && $ftpDaemon eq '' ) || 
		 !( -T "$ftpConfFile" ) ) {
  $ftpDaemon = 'vsftpd';
	&configureFtpd();
}
## /Pre-Main

## Main
&ConfigureVsFTPD;

&restartFtpd;

&UpdateMainConfig;


## /Main

## Unterprogramme

sub ConfigureVsFTPD{
  &BackUpFile("$ftpConfFile", "$installDir/backup/vsftpd/vsftpd.conf");
  print "\n";
  &CreateVsFTPDConfigFile;
}


sub CreateVsFTPDConfigFile{
  copy("$ftpConfFile", "$ftpConfFile.confixx-backup");
  my $time = localtime();

  my $default_type = &getServerType($ftpConfFile) || $ftpdType;
  my @types = ("inetd", "standalone");
  my $type;
  if($no_questions_mode){
    $type = 'inetd';
  } 
  else{
    $type = ($default_type) ? $default_type : &SelectQuestion( &ltext('install_question_ftpservertype'), @types);
  }
  $ftpdType = $type;


  print &ltext('install_do_file_create', $ftpConfFile);
  open(FILE, ">$ftpConfFile");

print FILE << "CONFIG";
#### CONFIXX VSFTPD KONFIGURATIONSDATEI ####
#### erstellt am $time ###

anonymous_enable=NO
local_enable=YES
write_enable=YES
local_umask=022

xferlog_enable=YES
xferlog_file=$ftpLogFile
xferlog_std_format=YES

ascii_upload_enable=YES
ascii_download_enable=YES
ls_recurse_enable=YES

connect_from_port_20=YES

chroot_local_user=YES

userlist_enable=YES
userlist_file=$chrootUsers
userlist_deny=NO

pam_service_name=vsftpd

#
# The following directive shows allways dot-files.
# vsftpd of version less than 1.1.3 does not support feature 'force_dot_files'.
# If your vsftpd has this feature then 
# remove commenting mark ('#') to activate the directive below.
#

#force_dot_files=YES


CONFIG

  if ($ftpdType =~ /standalone/){
    print FILE "\nlisten=YES\n";
  }

  print FILE "\n\n### ENDE ####\n";

  close(FILE);
}


sub header2{
  my ($header) = @_;
  my ($length, $count, $fix, $space);
  $fix = 35;
  $length = length($header);
  if($length > $fix){
    $fix = $length + 2;
  }
  $space = int(( $fix - $length ) / 2);
  for($count=1; $count <= $fix; $count++){
    print "#";
  }
  print "\n";
  for($count=1; $count <= $space; $count++){
    print " ";
  }
  print "$header    \n";
  for($count=1; $count <= $fix; $count++){
    print "#";
  }
  print "\n\n";
}
 
sub getServerType() {
  my $file = shift;
  if(-T $file && open(FILE,"< $file")){
	while(<FILE>){
	  if(/^\s*listen\s*=\s*y/i){
		return 'standalone';
	  }
	}
	close(FILE);
	return 'inetd';
  }
  return undef;
}

## /Unterprogramme
