#!/usr/bin/perl


########## Confixx(R) 3.0 Professional ############
####### Copyright SWsoft, Inc. 2004-2005 ##########
#### http://www.sw-soft.com - info@sw-soft.com ####


BEGIN {

  use FindBin qw($Bin);
	use File::Basename;

  use lib $Bin=~s%(?<=.)/$%%?$Bin:$Bin;
  use lib dirname( $Bin ).'/scripts';
  use lib dirname( $Bin ).'/subs';

}

use DBI;
use File::Copy;
use File::Path;
use FileHandle;

use strict;

use lib_module_common;
use Modules::Apache::Config::Parser;
use lib_module_services;

&initConfig;

safe_do "$installDir/admin/subs/subs_include_mhost.pl";
safe_do "$installDir/admin/subs/subs_include_writeConfig.pl";
safe_do "$installDir/admin/subs/subs_include_questions.pl";
safe_do "$installDir/admin/subs/subs_include_files.pl";
safe_do "$installDir/admin/subs/subs_include_IDN.pl";
safe_do "$installDir/admin/subs/IDN_install.pl";


my $dbh = DBI->connect($db_address, $dbUser, $dbPw) or 
	die( &ltext('db_connect', '#XXX', $DBI::errstr) );

&frontpage;
&html2slash;
&apachelogs;
&userGroupUpdate;
&SSLPerms;
&check_ftp;
&checkUtf8;
&apacheConfig;

my $orig_apache_reload = $pm_apache_reload;

$pm_apache_reload =~ s/(?<=\s)reload$/restart/;  ## replace 'reload' to 'restart' to restart apache

if ( &reload_daemon('apache') != 0 ) {
	unless( system( $pm_apache_reload ) == 0 ) {
		warn "Error execute '$pm_apache_reload': $!\n";
	}
}

$pm_apache_reload = $orig_apache_reload; ## restore old value

$dbh->disconnect;


## Unterprogramme

sub checkUtf8 {
  my $sth = $dbh->prepare("SELECT idn FROM admin WHERE server_id='$ServerID'");
  $sth->execute;
  my ( $idn ) = $sth->fetchrow();
	$sth->finish();

	return unless $idn; ## IDN is not supported

	my %idnBin = ('idn'=>$bin{'idn'},
								'iconv'=>$bin{'iconv'}
							 );


	($idn_vendor,$idn_shell,$iconv_shell,$iconv_utf8) =  &idnConfigure(\%idnBin);
	
	if ( $idn_vendor ) {
		&StoreBin($dbh,\%idnBin,'idn');
	}
}

sub frontpage{
  my($sth, $line, @row);
  print &ltext('update_feature_check', 'FrontPage');

  $sth = $dbh->prepare("SELECT frontpage FROM admin WHERE server_id='$ServerID'");
  $sth->execute;
  $line = $sth->fetchrow;

  if($line){
    $sth = $dbh->prepare("SELECT domain, kunde FROM domains WHERE frontpage=1 AND server_id='$ServerID'");
    $sth->execute;
    while(@row = $sth->fetchrow_array){
      print &ltext('update_user_check', $row[1]);
      unless(-e "$fp_homeDir/$row[1].cnf"){
        if(-e "$fp_homeDir/$row[0]\:80\.cnf"){
					print &ltext('install_do_file_copy', "$fp_homeDir/$row[0]\:80\.cnf", "$fp_homeDir/$row[1].cnf");
					copy("$fp_homeDir/$row[0]\:80\.cnf", "$fp_homeDir/$row[1].cnf");
        }
      }
    }
  }
  print "\n\n";
}


sub html2slash {
  print &ltext('update_feature_check', 'html2slash');

  my ($sth,$user,@row,$binDir,$homeDir,$uid,$lsPath);

  if ($ftpDaemon eq 'wu-ftpd'){
    $sth = $dbh->prepare("SELECT kunde,uid FROM kunden WHERE server_id='$ServerID'");
    $sth->execute;
    while(($user,$uid) = $sth->fetchrow){
			next unless $uid;
      print &ltext('update_user_check', $user);
			$homeDir = "$user_homeDir/$user";
			unless ( -d $homeDir ) {
				print "Error: dir '$homeDir' is not exist\n";
				next;
			}
			$binDir = "$homeDir/bin";
      if ( -l $binDir ) {
				unlink( $binDir );
      }
      unless(-d $binDir ) {
        print &ltext('install_do_dir_create', $binDir );
        unless ( mkdir( $binDir, 0711 ) ) {
          print &ltext('install_dir_create', $binDir );
					next;
				}
      }
      chmod(0711, $binDir );
      chown(0, 0, $binDir );
			$lsPath = "$binDir/ls";
      if ( -e $lsPath ) {
        unlink( $lsPath );
      }
      print &ltext('install_do_file_copy', "$installDir/ftp/bin/ls", $lsPath );
      unless ( copy("$installDir/ftp/bin/ls", $lsPath ) ) {
        print &ltext('install_file_copy', "$installDir/ftp/bin/ls", $lsPath);
				next;
			}
      chmod(0711, $lsPath );
      unless ( chown(0, 0, $lsPath ) ){
        print ( &ltext('install_file_chmod', $lsPath, "711") );
				next;
			}
      if ( ( -d "$user_homeDir/$user/html/bin" ) && 
					 &checkSymLink("$user_homeDir", "$user_homeDir/$user/html") && 
					 ((stat("$user_homeDir/$user/html/bin"))[4] == 0)){
        rmtree("$user_homeDir/$user/html/bin") or 
					print &ltext('install_dir_del_rec', "$user_homeDir/$user/html/bin");
      }
    }
		$sth->finish;

    $sth = $dbh->prepare("SELECT account,kunde,uid,pfad FROM ftp WHERE server_id='$ServerID'");
    $sth->execute;
    while ( @row = $sth->fetchrow_array ) {
      print &ltext('update_user_check', $row[0]);
			$homeDir = "$user_homeDir/$row[1]/html/$row[3]";
      if ( (-d $homeDir ) && 
					 &checkSymLink($user_homeDir, $homeDir ) ) {
				$binDir = "$homeDir/bin";
        if ( -l $binDir ) {
          rmtree( $binDir );
        }
        unless(-d $binDir ) {
          print &ltext('install_do_dir_create', $binDir );
          unless ( mkdir( $binDir, 0711) ) {
            print &ltext('install_dir_create', $binDir);
						next;
					}
        }
        chmod(0711, $binDir );
        chown(0, 0, $binDir );
				$lsPath = "$binDir/ls";
        if(-e $lsPath ) {
          unlink( $lsPath ); 
        }
        print &ltext('install_do_file_copy', "$installDir/ftp/bin/ls", $lsPath );

        unless ( copy("$installDir/ftp/bin/ls", $lsPath ) ) {
          print &ltext('install_file_copy', "$installDir/ftp/bin/ls", $lsPath);
					next;
				}
        chmod(0711, $lsPath );
        unless ( chown(0, 0, $lsPath ) ) {
          print ( &ltext('install_file_chmod', $lsPath, "711") );
					next;
				}
      }
    }
  }
  print "\n\n";
}


sub apachelogs {
  print &ltext('update_feature_check', 'Apache Logfiles');

  my ($sth, $user, $uid);

  $sth = $dbh->prepare("SELECT kunde,uid FROM kunden WHERE server_id='$ServerID'");
  $sth->execute;
  while(($user,$uid) = $sth->fetchrow){
    print "\n";
    print &ltext('update_user_check', $user);
    &accesslog($user,$uid);
    &errorlog($user,$uid);
  }
  print "\n\n";
}


sub userGroupUpdate{
  my ($sth, $user, $uid, @row);

  if(($confixx_homeDir ne "") && (-d $confixx_homeDir)){
      chown($confixx_uid, $gidapache, $confixx_homeDir);
      chmod(0750, $confixx_homeDir);
  }

  my (@chunks,@toCheck,$path,$home,$mode,$gid);

  $sth = $dbh->prepare("SELECT f.account,f.kunde,f.uid,f.pfad,k.uid ".
											 " FROM ftp f, kunden k WHERE k.kunde=f.kunde ".
											 " AND k.server_id='$ServerID' AND f.server_id='$ServerID'");
  $sth->execute;
  while(@row = $sth->fetchrow_array){

#
# check uid of ftp account & fix if necessary
#
    unless($row[4]==$row[2]){
      $dbh->do( "UPDATE ftp SET uid=$row[4] WHERE account='$row[0]' and server_id='$ServerID'");
      $row[2]=$row[4];
    }


		my $fullPath = "$user_homeDir/$row[1]/html";
    if(-d $fullPath && !-l $fullPath ){
#
# check path to home of ftp account
#
      @chunks = split(/\//,$row[3]);
      while (@chunks){
				$fullPath.='/'.shift(@chunks);
	
				if(-l $fullPath){
					last;
				}
				unless(-d $fullPath){
					last;
				}
				
				unless(($mode,$uid,$gid)=(stat($fullPath))[2,4,5]){
					last;
				}
				$mode &= 07777;
				unless (($mode & 05) == 05){ ## allow other access
					$mode |= 05;
					chmod $mode, $fullPath;
				}
				unless($gid == $uid){ ## fixed group ownership
					chown $uid,$uid,$path;
				}
			}
#
# end check path to home of ftp account
#
    }
  }
}


sub SSLPerms{
  my ($sth, $user);
  $sth = $dbh->prepare("SELECT kunde FROM cssl WHERE server_id='$ServerID'");
  $sth->execute;
  while($user = $sth->fetchrow){
    if(-e "$sslKeyDir/$user.key"){
      chmod(0400, "$sslKeyDir/$user.key");
    }
    if(-e "$sslCrtDir/$user.crt"){
      chmod(0400, "$sslCrtDir/$user.crt");
    }
  }
}


sub errorlog{
  my ($user) = @_;
  for(my $i=1; $i <= 90; $i++){
    if(-e "$apacheBackupDir/access/$user\.$i\.gz"){
      unless(-d "$apacheBackupDir/$user"){
        print &ltext('install_do_dir_create', "$apacheBackupDir/$user");
        mkdir ("$apacheBackupDir/$user", 0755);
      }
      print &ltext('install_do_file_mv', "$apacheBackupDir/access/$user\.$i\.gz", "$apacheBackupDir/$user/access_log\.$i\.gz");
      system("mv $apacheBackupDir/access/$user\.$i\.gz $apacheBackupDir/$user/access_log\.$i\.gz"); 
    }
    else{
      return('1');
    }
  } 
}


sub accesslog {
  my ($user,$gid) = @_;
	
  if(-l "$user_homeDir/$user/log/access_log"){
    unlink("$user_homeDir/$user/log/access_log");
  }
	my $logDir = "$user_homeDir/$user/log";
  if(-l $logDir){
    unlink($logDir);
  }
	if(-e $logDir && !-d $logDir){
    unlink($logDir);
	}
	my($uid);
	unless($gid){
		($uid,$gid)=(getpwuid($user))[2,3];
	}
  unless(-d $logDir){
    print &ltext('install_do_dir_create', $logDir);
    mkdir($logDir, 0750);
  }
	chown 0,$gid,$logDir;
	chmod 0750,$logDir;

  unless($apacheLogDir ne ""){
    return 1;
  }

  if(-e "$apacheLogDir/kunden/access/$user"){
    open(IN, "$apacheLogDir/kunden/access/$user");
    open(OUT, ">>$user_homeDir/$user/log/access_log");
    print &ltext('install_do_file_mv', "$apacheLogDir/kunden/access/$user", "$user_homeDir/$user/log/access_log");
    while(<IN>){
      print OUT $_;
    }
    close(IN);
    close(OUT);
    print &ltext('install_do_file_del', "$apacheLogDir/kunden/access/$user");
    unlink("$apacheLogDir/kunden/access/$user");
  }
  open(TMP, ">>$user_homeDir/$user/log/access_log");
  close(TMP);
  chown(0, 0, "$user_homeDir/$user/log/access_log");
	chmod(0644, "$user_homeDir/$user/log/access_log");
}


sub check_ftp{ 

	my $sql = "SELECT f.uid,f.kunde,f.pfad,f.account,k.uid as kuid ".
		"FROM ftp f, kunden k WHERE f.kunde=k.kunde";
  my $sth = $dbh->prepare($sql);
  unless($sth->execute){
		warn "Error execute sql: $sql\n$DBI::errstr\n";
		return 0;
	}
	my(@row,$uid,$account,$ftpHome);
  while(my @row = $sth->fetchrow_array){
		($account,$uid)=@row[3,4];
		$ftpHome = "$user_homeDir/$row[1]/html/$row[2]";
    if(&checkSymLink("$user_homeDir/$row[1]", $ftpHome) & (-d $ftpHome)){

      chown($uid, $uid, $ftpHome);
      chmod(0755, $ftpHome);

			unless($row[0]==$uid){
				$sql = "UPDATE ftp SET uid=$uid WHERE account='$account' AND server_id='$ServerID'";
				$dbh->do($sql) or
					warn "Error execute sql: '$sql'\nDBI::errstr\n";

				my $cmd="find $ftpHome -uid $row[0] -exec chown $uid:$uid {} ';'";
				(system($cmd)==0) or 
					warn "Error run command: $cmd\n$!\n";
				
			}

    }else{
			$dbh->do("DELETE FROM ftp WHERE account='$row[3]' AND server_id='$ServerID'");
			$dbh->do("INSERT INTO delaccs (account, type, pfad, kunde, server_id) VALUES (?, 'ftp' ,? ,?, '$ServerID')", undef, $account, $row[2], $row[1]);
			$dbh->do("UPDATE allgemein SET delftp = 1 WHERE server_id='$ServerID'");
    }
  }
	$sth->finish();
	
	# bug #36306 set right permissions
	chmod(0600, "$ftpLogFile");
}


sub checkSymLink{
  my ($base, $file) = @_;
  $base=~s/\/$//;
  while((length($file)>1) && ($file ne $base) ){
    if(-l $file){
      return 0;
    }
    $file = dirname($file);
  }
  return 1;
}

sub apacheConfig{
  my ( $file, $file_to_parse, $parser, @parameters, $ptrHash, $confixxConf );
  my $change_httpdconf = 0;

  if ($mhost_conf && -f $mhost_conf) {
    $file_to_parse = $mhost_conf;
  } else {
    $file_to_parse = $httpd_conf;
    $change_httpdconf = 1;
  }
  $file = new FileHandle ( $file_to_parse, 'r' ) or
		die "Error: apache's config '$file_to_parse' is not opened to read: $!\n";

  $parser = new Modules::Apache::Config::Parser();
  $parser->read( $file );
  if ( @parameters = $parser->getConfixxParameters() ) {

		( $confixx_IP, $confixx_domain ) = @parameters;

		$dbh->do( "UPDATE admin SET confixx_ip='$confixx_IP', ".
							" confixx_domain='$confixx_domain' WHERE server_id='$ServerID'" );

		$bin_cp ||= $bin{'cp'} || 'cp';
		$confixxConf = "$file_to_parse.confixx_backup";
		system ( "$bin_cp -f $file_to_parse $confixxConf" );

		if ($change_httpdconf) {
    	$file = new FileHandle ( $httpd_conf, 'w' );
			my ($ports);
			if ( $parameters[4] == 443 ) {
				$ports = $parameters[4];
			} else {
				$ports = [ $parameters[4], 443 ]; ## make an anonymous array
			}
    	$parser->output ( $file, $confixx_IP, $ports );
    	$file->close();
		}

		my ( $use_SSL);
		$bin_openssl ||= $bin{'openssl'};
		unless ( $bin_openssl && -x $bin_openssl ) {
			$use_SSL = &YesNoQuestion( &ltext('install_question_ssl') );
			$bin_openssl = &getBin('openssl',$use_SSL?undef:'no ask')
		}
			
		if ( $bin_openssl && -x $bin_openssl && !( $sslKeyDir && $sslCrtDir ) ) {
			my $default_sslDir = dirname($::httpd_conf);
			my $default_sslKeyDir = $default_sslDir.'/ssl.key/';
			my $default_sslCrtDir = $default_sslDir.'/ssl.crt/';

			if ( $use_SSL ) {
				$sslKeyDir = &PathQuestion(&ltext('install_ssl_keydir'), $default_sslKeyDir);
				$sslCrtDir = &PathQuestion(&ltext('install_ssl_crtdir'), $default_sslCrtDir);
				$dbh->do("UPDATE admin SET cssl=1 WHERE server_id='$ServerID'") or 
					&soft_error("$DBI::errstr");
			} else {
				$sslKeyDir = $default_sslKeyDir;
				$sslCrtDir = $default_sslCrtDir;
			}

			&UpdateMainConfig;
		}

		unless( $vhostDir ){
			my $default_vhostDir = dirname($::vhost_conf).'/confixx_vhosts';
			$vhostDir = &PathQuestion(&ltext('install_vhostdir'), $default_vhostDir);
			&UpdateMainConfig;
		}

		unless (-d $vhostDir ){
			mkdir $vhostDir;
			$dbh->do( "UPDATE kunden SET httpd=1 WHERE server_id='$ServerID'" );
		}

		my ($confixxKey,$confixxCrt);

		if(-x $bin_openssl && $sslKeyDir && $sslCrtDir){

			mkdir $sslKeyDir unless (-d $sslKeyDir);
			mkdir $sslCrtDir unless (-d $sslCrtDir);

			if( -d $sslKeyDir && -d $sslCrtDir ){
#
# prepare SSL settings
#		
				my($ip,$port,$ptrVHost,$pathKey,$pathCrt,
					 $confixxDomain,$keyKey,$keyCrt,$hasSSL,$confixxVHost);

				$ptrHash = &parseMHost( $confixxConf );

				if(ref($ptrHash)=~/HASH/){
					$confixxKey = "$sslKeyDir/$confixx_domain.key";
					$confixxCrt = "$sslCrtDir/$confixx_domain.crt";
					foreach $ip (keys %{$ptrHash}){
						$hasSSL=0;
						$confixxVHost=undef;
						foreach $port ( keys %{$ptrHash->{$ip}}){
							$ptrVHost = $ptrHash->{$ip}->{$port};

#
# work only with the confixx virtual hosts
#
							unless($ptrVHost->{'DocumentRoot'} eq $::confixx_htmlDir){
								unless( exists( $ptrVHost->{'Redirect'} ) ){
									delete $ptrHash->{$ip}->{$port};
									unless(keys %{$ptrHash->{$ip}}){
										delete $ptrHash->{$ip};
									}
								}
								next;
							}

							if(exists($ptrVHost->{'SSLEngine'})){
								$keyKey = 'SSLCertificateKeyFile';
								$keyCrt = 'SSLCertificateFile'
							}elsif(exists($ptrVHost->{'SSLEnable'})){
								$keyKey = 'SSL_KeyFile';
								$keyCrt = 'SSL_CertFile';
							}else{
								$confixxVHost = $ptrVHost;
								next;
							}

#
# get old path
#
							$pathKey = $ptrVHost->{$keyKey};
							$pathCrt = $ptrVHost->{$keyCrt};
							
							$hasSSL = 1;
						
							if(-f $pathKey && -f $pathCrt){
								if(&safeSymLink($pathKey,$confixxKey)){
									$ptrVHost->{$keyKey}=$confixxKey;
								}
								if(&safeSymLink($pathCrt,$confixxCrt)){
									$ptrVHost->{$keyCrt}=$confixxCrt;
								}
							}
						}
						unless($hasSSL){ # create new SSL virtul host if has not any 
							if(ref($confixxVHost)=~/HASH/){
								$ptrHash->{$ip}->{443}={%{$confixxVHost}};
								$ptrVHost=$ptrHash->{$ip}->{443};
								$ptrVHost->{'port'}=443;
								$ptrVHost->{'SSLEngine'}='on';
								$ptrVHost->{'SSLCertificateKeyFile'} = $confixxKey;
								$ptrVHost->{'SSLCertificateFile'} = $confixxCrt;
								$ptrVHost->{'access_log'} = $ptrVHost->{'CustomLog'};
								$ptrVHost->{'error_log'} = $ptrVHost->{'ErrorLog'};
								## to remake name of log
								delete $ptrVHost->{'CustomLog'};
								delete $ptrVHost->{'ErrorLog'};
							}
						}
					}
				}
			}
		}
#
# end prepare SSL settings
#
		&writeMHost( @parameters,$ptrHash );

		if( $confixxKey && $confixxCrt ){
			&checkSharedCrt( $confixxKey, $confixxCrt);
		}
			
	} else {
		print STDERR "ERROR: Can not find information abour Confixx Vhost in '$file_to_parse' file\n";
  }
}


#
# check & cretae shared SSL certificate
#
sub checkSharedCrt{

	my( $pathKey, $pathCrt ) = @_;

	my($ok,$key,$crt,$insert);
	my $sth = $dbh->prepare( "SELECT privatekey,crt,neu,domain FROM cssl ".
													 " WHERE kunde='admin' AND server_id='$ServerID'" );
	$sth->execute;
	if($sth->rows){
		my @row = $sth->fetchrow;
		my $domain = $row[3];
		if( -f "$sslKeyDir/admin.key"	&&
				-f "$sslCrtDir/admin.crt" ){		
			$ok = 1;

		}elsif($row[0] && $row[1]){
			$dbh->do( "UPDATE cssl SET aendern=1 WHERE kunde='admin' AND server_id='$ServerID'" );
			$dbh->do( "UPDATE allgemein SET cssl=1 WHERE server_id='$ServerID'" );

			$ok = 1;
		}
	}else{
		$insert = 1;
	}
	$sth->finish;
	unless($ok){
		if(-f $pathKey && -f $pathCrt){

			local $/;  ## restore LF after exit from block
			undef $/;  ## read full file

			if(open( IN, '<', $pathKey ) ) {
				$key = <IN>;
				close IN;
			}else{
				print STDERR "WARNING: Unable to crete the shared SSL.\n".
					"Open file error '$pathKey': $!\n";
			}
			if(open( IN, '<', $pathCrt ) ) {
				$crt = <IN>;
				close IN;
			}else{
				print STDERR "WARNING: Unable to crete the shared SSL.\n".
					"Open file error '$pathCrt': $!\n";
			}

			if( $insert ){
				$dbh->do( "INSERT INTO cssl(privatekey,crt,aendern,kunde,domain,server_id) ".
									" VALUES ('$key','$crt',1,'admin','shared', '$ServerID')");
			}else{
				$dbh->do( "UPDATE cssl SET privatekey='$key', crt='$crt',".
									" aendern=1, domain='shared'".
									" WHERE kunde='admin' AND server_id='$ServerID'" );
			}
			$dbh->do( "UPDATE allgemein SET cssl=1 WHERE server_id='$ServerID'" );

		} else {
			print STDERR "WARNING: Unable to crete the shared SSL.\n".
				"'$pathKey' & '$pathCrt' are not files\n";
			return 0;
		}
	}

	
}

## /Unterprogramme
