#!/usr/bin/perl

########## Confixx(R) 3.0 Professional ############
####### Copyright SWsoft, Inc. 2004-2005 ##########
#### http://www.sw-soft.com - info@sw-soft.com ####

BEGIN{

  use FindBin;
  use lib "$FindBin::Bin";
  use lib "$FindBin::Bin/../scripts";
  use lib "$FindBin::Bin/../subs";

}

use strict;

use DBI;
use File::Copy;
use File::Path;

use lib_module_common;
use Modules::HomeStructure;
use lib_module_db;

&initConfig();

do "$installDir/admin/subs/subs_include_writeConfig.pl";
do "$installDir/admin/subs/subs_include_questions.pl";

my $dirFrontPage5 = '/usr/local/frontpage/version5.0';
my $adminFrontPage5 = $dirFrontPage5.'/bin/owsadm.exe';

unless ( -d $dirFrontPage5 && -x $adminFrontPage5 ) {
	die "FrontPage version 5.0 is not found in /usr/local/frontpage\n";
}

unless ( &checkVersion() ) {
	print "For this version of Confixx it is not necessary upgrade\n";
}


my $dbh = DBI->connect($db_address, $dbUser, $dbPw)
or die( &ltext('db_connect', '#XXX', $DBI::errstr) );

my $sth = $dbh->prepare("SELECT frontpage FROM admin");
$sth->execute();
my $frontpageIsOn = $sth->fetchrow;
$sth->finish();

unless ( $frontpageIsOn ) {
	print "Support of FrontPage is off\nDo nothing\n";
}

unless ( $adminFrontPage5 eq $bin_fpsrvadm ) {

	$bin_fpsrvadm = $adminFrontPage5;
	$bin{'fpsrvadm'} = $bin_fpsrvadm;

	&WriteMainConfigFile();
	
	&updateFrontpage();

}

&checkOwnership();


$dbh->disconnect;

#
#  end main
#
#====================================================
#====================================================
#
#  subs
#

sub checkVersion {

	print "Check version of Confixx ...";

	my $script = "$installDir/confixx_updatescript.pl";
	if ( -x $script ) {
		my $out = `$script VERSION`;
		unless ( $out =~ /^(\d+)\.(\d+)\.(\d+)/ ) {
			$out = `$script -v`;
		}
		if ( $out =~ /^(\d+)\.(\d+)\.(\d+)/ ) {
			my ($major,$minor,$patchlevel) = ($1,$2,$3);

			print " $major.$minor.$patchlevel\n";

			if ( ( $major == 3 && $minor == 0 && $patchlevel == 4 ) ||
					 ( $major == 2 && $minor == 0 && $patchlevel == 14 ) ) {

				return 1; ## It is found !!!!

			}
		}
	} else {
		die "confixx_updatescript.pl is not found in $installDir\n";
	}
	return 0;
}

sub updateFrontpage{

	my ($domain,$user,$uid,$cmd,$sth,$stdDomain);

  my $fp_apache_type = 'apache-fp';
  if (&basename($bin_fpsrvadm) eq 'owsadm.exe' && $httpd eq 'apache2.0') {
		# if FP2002 and Apache 2.0
		$fp_apache_type = 'apache-2.0';
  }

  $sth = $dbh->prepare("SELECT standarddomain FROM admin WHERE server_id='$ServerID'");
  $sth->execute or &soft_error("#2124: $DBI::errstr");
  $stdDomain = $sth->fetchrow;
  $sth->finish;

	$sth = $dbh->prepare("SELECT d.domain, d.kunde, k.uid FROM domains d, kunden k  ".
											 "WHERE d.frontpage=1 AND d.kunde=k.kunde ".
											 " AND k.server_id='$ServerID' AND d.server_id='$ServerID'");
	$sth->execute or
		die "Error execute sql: DBI->errstr\n";


	while ( ($domain,$user,$uid) = $sth->fetchrow_array ) {

		$cmd = "$bin_fpsrvadm -o upgrade -p 80 -t $fp_apache_type ".
			"-m \"$user.$stdDomain\"  -xu $user -xu $user";
		
		if ( system($cmd) == 0 ) {

			my $userDocRoot = "$user_homeDir/$user/html";
			chown $uid,$gidapache,$userDocRoot; 
			chown $uid,$gidapache,"$userDocRoot/_vti_pvt";  ## same ownership as document root (~/html)

			copy("$fp_homeDir/$user.$stdDomain\:80.cnf", "$fp_homeDir/$user.cnf") or
				print "error by copy $user.$stdDomain\:80.cnf -> $user.cnf\n";

		} else {
			print "Error by execute '$cmd': $!\n";
		}

	}
	$sth->finish();

}

sub checkOwnership {
	my $homeStructure = Modules::HomeStructure->new();
	
  my $sth = $dbh->prepare("SELECT kunde,uid FROM kunden WHERE server_id='$ServerID'");
  $sth->execute()
    or die "Error execute sql: DBI->errstr\n";

	my ($kunde,$uid,$dir,$cmd);

  while ( ( $kunde,$uid ) = $sth->fetchrow() ) {

		unless ( $homeStructure->createHome( 'user'=>$kunde,'uid'=>$uid,'gid'=>$uid ) ) {

			my $errorCode = $homeStructure->lastErrorCode();
			my $fullPath = $homeStructure->lastFullPath();

			if ( $errorCode eq 'delete' ) {
				print "Error by clean '$fullPath'\n";

			} elsif ( $errorCode eq 'create' ) {
				print "Error by create '$fullPath'\n";

			} elsif ( $errorCode eq 'chmod' ) {
				print "Error by change mode of '$fullPath'\n";

			} elsif ( $errorCode eq 'chown' ) {
				print "Error by change ownership  of '$fullPath'\n";
			}

		}

#
# fix ownership of files in ~/backup to root:user
#
		$bin_find ||= $bin{'find'} || 'find';
		$dir = "$user_homeDir/$kunde/backup";
		$cmd = "$bin_find $dir -type f -exec chown 0:$uid {} ';'";
		unless(system($cmd)==0){
			warn "Error by execute command '$cmd' ($!)\n";
		}

		$bin_chmod ||= $bin{'chmod'} || 'chmod';
		system("$bin_chmod g+r $user_homeDir/$kunde/html -R");

	}
}

