#!/usr/bin/perl

########## Confixx(R) 3.0 Professional ############
####### Copyright SWsoft, Inc. 2004-2005 ##########
#### http://www.sw-soft.com - info@sw-soft.com ####

BEGIN{
  use FindBin;
  use lib "$FindBin::Bin";
  use lib "$FindBin::Bin/../scripts";
  use lib "$FindBin::Bin/../subs";
}

use DBI;
use File::Copy;
use File::Path;

use lib_module_common;
use lib_module_db;

use strict;

&initConfig();

my ($spamAssassinVersion);

print "Check version of SpamAssassin ...";

if (eval "require Mail::SpamAssassin" ) {
	$spamAssassinVersion = $Mail::SpamAssassin::VERSION;
	print Mail::SpamAssassin::Version(),"\n";
} else {
	die "\nSpamAssassin is not installed\n";
}

unless ( &checkVersion() ) {
	print "This version of Confixx has not support of SpamAssassin v. 2.* & 3.* \n";
	exit(0);
}


my $dbh = DBI->connect($db_address, $dbUser, $dbPw)
or die( &ltext('db_connect', '#XXX', $DBI::errstr) );


my ($sql,$ok);

if ( $spamAssassinVersion >= 3 ) {

	print "update rewrite_subject ... ";
	# support of records from confixx < 3.1.x
	#
	$sql = "UPDATE spampref SET preference='rewrite_header', ".
		"value='subject *****SPAM*****' WHERE preference='rewrite_subject' AND value='1'".
			" AND server_id='$ServerID'";
	$ok = &doRequest($sql);
	$sql = "DELETE FROM spampref WHERE preference='rewrite_subject' AND value='0' AND server_id='$ServerID'";
	$ok &&= &doRequest($sql);

	# support of records from confixx 3.1.x
	#
	$sql = "UPDATE spampref SET preference='rewrite_header', ".
		"value=CONCAT( 'subject ', value ) WHERE preference='rewrite_header subject' ".
			" AND server_id='$ServerID'";
	$ok &&= &doRequest($sql);
	print $ok?"ok\n":"fail\n";
	

	print "update require_hits ... ";
	$sql = "UPDATE spampref SET preference='required_score' ".
		" WHERE preference='required_hits' AND server_id='$ServerID'";
	$ok = &doRequest($sql);
	print $ok?"ok\n":"fail\n";


	print "update reporting ... ";
	$sql = "UPDATE spampref SET preference='add_header spam Report', ".
		"value='_REPORT_' WHERE preference='report_header' AND value='1' AND server_id='$ServerID'";
	$ok = &doRequest($sql);
	$sql = "DELETE FROM spampref WHERE preference='rewrite_header' AND value='0' AND server_id='$ServerID'";
	$ok &&= &doRequest($sql);
	$sql = "DELETE FROM spampref WHERE preference='use_terse_report' AND server_id='$ServerID'";
	$ok &&= &doRequest($sql);
	print $ok?"ok\n":"fail\n";

	print "clean unused preferences ... ";
	$sql = "DELETE FROM spampref WHERE preference='defang_mime' AND server_id='$ServerID'";
	$ok = &doRequest($sql);
	print $ok?"ok\n":"fail\n";

} else {

	print "update rewrite_header ... ";

	$sql = "UPDATE spampref SET preference='rewrite_subject', ".
		"value='1' WHERE ( preference='rewrite_header subject' OR (preference='rewrite_header' AND value LIKE 'subject %')) AND server_id='$ServerID'";
	$ok = &doRequest($sql);
	print $ok?"ok\n":"fail\n";

	print "update require_score ... ";
	$sql = "UPDATE spampref SET preference='required_hits' WHERE preference='required_score' AND server_id='$ServerID'";
	$ok = &doRequest($sql);
	print $ok?"ok\n":"fail\n";


	print "update reporting ... ";
	$sql = "UPDATE spampref SET preference='report_header', ".
		"value='1' WHERE preference='add_header spam Report' AND server_id='$ServerID'";
	$ok = &doRequest($sql);
	print $ok?"ok\n":"fail\n";

}
$dbh->disconnect();

print "update configure ...\n";

safe_do "$installDir/admin/subs/subs_include_modules.pl";
safe_do "$installDir/admin/subs/spamassassin_install.pl";
&installSpamassassin();

safe_do "$installDir/admin/subs/subs_include_writeConfig.pl";
&WritePHPConfigFile();

if ( $pm_spamassassin_reload ) {
	print "Reload spamd ...\n";
	system( $pm_spamassassin_reload );
}


print "updating of user SpamAssassin preferences is finished\n";


exit(0);

##################################################################
#
# subs
#
##################################################################

sub doRequest {
	my $sql = shift;
	
	unless ( $dbh->do($sql) ) {
		warn("Error execute sql-request ($sql): $DBI::errstr\n");
		return 0;
	}
	return 1;
}

sub checkVersion {

	print "Check version of Confixx ...";

	my $script = "$installDir/confixx_updatescript.pl";
	if ( -x $script ) {
		my $out = `$script VERSION`;
		unless ( $out =~ /^(\d+)\.(\d+)\.(\d+)/ ) {
			$out = `$script -v`;
		}
		if ( $out =~ /^(\d+)\.(\d+)\.(\d+)/ ) {
			my ($major,$minor,$patchlevel) = ($1,$2,$3);

			print " $major.$minor.$patchlevel\n";

			my $ver = $major+$minor/1000+$patchlevel/1000000;

			if ( $ver >= 3.000006 ) {

				return 1; ## It is found !!!!

			}
		}
	} else {
		die "confixx_updatescript.pl is not found in $installDir\n";
	}
	return 0;
}

