package sql::Index;

########## Confixx(R) 3.0 Professional ############
####### Copyright SWsoft, Inc. 2004-2005 ##########
#### http://www.sw-soft.com - info@sw-soft.com ####

use vars qw/$DEBUG $dbType/;
use strict;

sub new {
  my $classname = shift;
  my $args = {};
  if ( @_ == 1 ) {
    $args->{'fullsql'}=shift;
  } else {
    $args = {'name'=>'',
	     'sql'=>'',
	     'fullsql'=>'',
	      @_
	    };
  }
  my $this = {'name' => $args->{'name'},
							'sql' => $args->{'sql'},
							'fullsql' => $args->{'fullsql'},
							'table' => undef,
							'field' => undef,
							'unique' => undef
						 };

  bless ($this, $classname);
  return $this;
}

sub Name {
  my $this = shift;
  if ( @_ ) {
    $this->{'name'} = shift;
  }
  return $this->{'name'};
}

sub Correct {
  my $this = shift;
  if ( @_ ) {
    $this->{'correct'} = shift;
  }
  return $this->{'correct'};
}


sub Field {
  my $this = shift;
	if( @_ ){
		$this->{'field'} = shift;
	}
	return $this->{'field'};
}

sub parseSQL {
  my $this = shift;
  my $sql = shift || $this->{'sql'};
  unless ($sql =~ s/^\s*create\s+(unique\s+)?index\s+(\S+)\s+on\s+//i){
    return 0;
  }
  $this->{'name'} = $2;
  $this->{'field'} = undef;
  $this->{'table'} = undef;
	$this->{'unique'} = $1;

  if ( $DEBUG>1 ) {
    print STDERR "Start parsing index ".$this->{'name'}."\n";
  }
	if( $sql =~ /^(\S+)\s*\(\s*(.*)\s*\)/){
		$this->{'table'} = $1;
		$this->{'field'} = $2;

		return 1;
	}else{
    print STDERR "Index (".$this->{'name'}."): parse error: wrong tail\t=\t'$sql'\n";
    return 0;
	}
}

sub SQL {
  my $this = shift;
  if ( @_ ) {
    $this->{'sql'}=shift;
  }
  return $this->{'sql'};
}

sub appendSQL {
  my $this = shift;
  if ( @_ ) {
    $this->{'sql'} .= shift;
  }
  return $this->{'sql'};
}

sub FullSQL {
  my $this = shift;
  if ( @_ ) {
    $this->{'fullsql'} = shift;
  }
  return $this->{'fullsql'};
}

sub appendFullSQL {
  my $this = shift;
  if ( @_ ) {
    $this->{'fullsql'}.=shift;
  }
  return $this->{'fullsql'};
}

sub getSQL {
  my $this = shift;
  my $sql = $this->{'fullsql'};
  while ( chomp $sql ){
    $sql =~ s/--.*$//;  ## clean comment
  }
  $sql =~ s/;\s*$//;
  return $sql;
}


sub toText {
  my $this=shift;
  my $prefix = shift||'';
  my ($key,$value,$chunk,$cnt);
  my $ret='';
  while ( ($key,$value) = each %{$this}){
    if ( ref($value) =~ /HASH/ ) {
      $ret .= "$prefix$key\t(hash):\n";
      while ( ($key,$chunk) = each %{$value} ) {
				$ret .= $prefix."{$key}\t:\n";
				if ( ref($chunk) =~ /Field/ ) {
					$ret .= $chunk->toText("\t");
				} else {
					$ret .= "$prefix\t$key\t=\t$chunk\n";
				}
      }
    } elsif ( ref($value)=~/ARRAY/ ) {
      $cnt = @{$value};
      $ret .= "$prefix$key\t(array $cnt):\n";
      $cnt = 0;
      foreach $chunk ( @{$value} ) {
				$ret .= $prefix."\t[$cnt]\t=\t$chunk\n";
				$cnt++;
      }
    } else {
      $ret .= "$prefix$key\t=\t$value\n";
    }
  }
  return $ret;
}

1;
