package sql::Table;

########## Confixx(R) 3.0 Professional ############
####### Copyright SWsoft, Inc. 2004-2005 ##########
#### http://www.sw-soft.com - info@sw-soft.com ####


use strict;

use sql::Field;

sub new {
  my $classname = shift;
  my $args = {};
  if ( @_ == 1 ) {
    $args->{'fullsql'}=shift;
  } else {
    $args = {'name'=>'',
	     'sql'=>'',
	     'fullsql'=>'',
	      @_
	    };
  }
  my $this = {'name' => $args->{'name'},
							'sql' => $args->{'sql'},
							'fullsql' => $args->{'fullsql'},
							'fields' => {},
							'fldnames' => [],
							'unique' => []
						 };

  bless ($this, $classname);
  return $this;
}

sub Name {
  my $this = shift;
  if ( @_ ) {
    $this->{'name'} = shift;
  }
  return $this->{'name'};
}

sub Correct {
  my $this = shift;
  if ( @_ ) {
    $this->{'correct'} = shift;
  }
  return $this->{'correct'};
}


sub Field {
  my $this = shift;
  my $name = shift;
  my $field;
  if ( exists($this->{'fields'}->{$name}) ) {
    if ( @_ ) {
      $field = shift;
      if ( ref($field ) =~ /Field/ ) {
				$this->{'fields'}->{$name} = $field;
      }
    }
    return $this->{'fields'}->{$name};
  }else{
    return undef;
  }
}

sub Fields {
  my $this = shift;
  if ( @_ ) {
    my $refHash = shift;
    $this->{'fields'} = $refHash if ref($refHash) =~ /HASH/;
  }
  return $this->{'fields'};
}

sub NamesOfFields {
  my $this = shift;
  if ( @_ ) {
    my $refHash = shift;
    $this->{'fldnames'} = $refHash if ref($refHash) =~ /ARRAY/;
  }
  return $this->{'fldnames'};
}

sub appendField {
  my $this = shift;
  my $field = shift;
  if ( ref($field) =~ /Field/ ) {
    my $name = $field->Name;
    if ( exists( $this->{'fields'}->{$name} ) ) {
      $field = undef;
    } else {
      $this->{'fields'}->{$name} = $field;
      push @{$this->{'fldnames'}},$name;
    }
  }
  return $field;
}

sub parseSQL {
  my $this = shift;
  my $sql = shift || $this->{'sql'};
  unless ($sql =~ s/^\s*create\s+table\s+(\S+)\s*\(//i){
    return 0;
  }
  $this->{'fields'} = {};
  $this->{'fldnames'} = [];
  $this->{'indexes'} = [];
  $this->{'unique'} = [];

  $this->{'name'} = $1;
  if ( $::DEBUG>1 ) {
    print STDERR "Start parsing table ".$this->{'name'}."\n";
  }
  my ($fieldSQL,$field,$fieldName,$tail,$index,$key,@list);
  if ( $sql =~ s/\)([^)]+);\s*$/);/ ) {
    $this->{'suffix'} = $1;
    $this->{'suffix'} =~ s/^\s+//;
    $this->{'suffix'} =~ s/\s+$//;
  }
  while ($sql =~ s/((?:'(?>[^']*)(?>['\]'[^']*)*'|"(?>[^"]*)(?>["\]"[^"]*)*"|\([^)(]*\)|[^'",)(])*)(,|\)\s*;)//){
    $fieldSQL = $1;
    if ( $fieldSQL =~ s/^\s*primary\s+key(?=[ (])//i ) {
      if ( $fieldSQL =~ s/\s*\(([^()]+)\)// ) {
				$key = $1;
				@list = map{ s/^\s+//; s/\s+$//; $_ } split(',', $key );
				if( @list == 1 ){
					$this->{'id'} = pop @list;
				}else{
					$this->{'id'} = [@list];
				}
      } else {
				print STDERR "Table (".$this->{'name'}."): parse error: 'primary key'-statement: $fieldSQL\n";
      }
    } elsif ( $fieldSQL =~ s/^\s*index(?=[ (])//i ) {
      if ( $fieldSQL=~s/\s*\(([^()]+)\)// ) {
				push @{$this->{'indexes'}},$1;
      } else {
				print STDERR "Table (".$this->{'name'}."): parse error: 'index'-statement: $fieldSQL\n";
      }

    } elsif ( $fieldSQL =~ s/^\s*unique(?=[ (])//i ) {
      if ( $fieldSQL =~ s/\s*\(([^()]+)\)// ) {
				$key = $1;
				@list = map{ s/^\s+//; s/\s+$//; $_ } split(',', $key );
				push @{$this->{'unique'}}, @list;
      } else {
				print STDERR "Table (".$this->{'name'}."): parse error: 'unique'-statement: $fieldSQL\n";
      }

    } elsif ( $fieldSQL =~ s/^\s*key(?=[ (])//i ) {
      $fieldSQL =~ s/^\s+//;
      if ( $fieldSQL =~ s/^(\S+)(?=[ (])// ) {
				$index = $1;
      }
      if ( $fieldSQL =~ s/\s*\(([^()]+)\)// ) {
				$index = $index?$index."($1)":$1;
				push @{$this->{'indexes'}},$index;
      } else {
				print STDERR "Table (".$this->{'name'}."): parse error: 'key'-statement: $fieldSQL\n";
      }
    } else {
      $field = sql::Field->new( $fieldSQL );
      if ( $field->parseSQL() ) {
				$fieldName = $field->Name;
				if ( exists( $this->{'fields'}->{$fieldName} ) ) {
					print STDERR "Table (".$this->{'name'}."): parse error: dublicate field '$fieldName'\n";
				} else{
					$this->{'fields'}->{$fieldName} = $field;
					push @{$this->{'fldnames'}},$fieldName;
					if ( $field->ID ) {
						$this->{'id'} = $fieldName;
					}
					if ( $field->Unique ) {
						push @{$this->{'unique'}}, $fieldName;
					}
				}
      }
    }
  }
  $sql =~ s/^\s+//;
  $sql =~ s/\s+$//;
  if ( $sql ) {
    print STDERR "Table (".$this->{'name'}."): parse error: wrong tail\t=\t'$sql'\n";
    return 0;
  }
  return 1;
}

sub ID {
  my $this = shift;
  if ( @_ ) {
    my $name = shift;
		if( ref($name) =~ /ARRAY/ ){
			my @exists = grep { exists( $this->{'fields'}->{$_})} @{$name};
			if( @exists == @{$name} ){
				$this->{'id'} = [ @{$name} ];
			}
		}else{
			if ( exists( $this->{'fields'}->{$name} ) ) {
				$this->{'id'} = $name;
			}
    }
  }
	if( wantarray() && ref($this->{'id'}) =~ /ARRAY/ ){
		return @{$this->{'id'}}
	}else{
		return $this->{'id'};
	}
}

sub Unique {
  my $this = shift;
  if ( @_ ) {
    my $name = shift;
		if( ref( $name ) =~ /ARRAY/ ){
			my @exists = grep { exists( $this->{'fields'}->{$_})} @{$name};
			if( @exists == @{$name} ){
				$this->{'unique'} = [ @{$name} ];
			}
		}else{
			if ( exists( $this->{'fields'}->{$name} ) ) {
				$this->{'unique'} = [ $name ];
			}
    }
  }
	if( wantarray() ){
		return @{$this->{'unique'}};

	}elsif( @{$this->{'unique'}} > 1 ){
		return $this->{'unique'};

	}else{
		return shift @{$this->{'unique'}};
	}
}

sub isValidKey{
  my $this = shift;
	my ($id);
	if(@_ > 1){
		$id = [ @_ ];
	}else{
		$id = shift;
	}


	unless( ref( $id ) ){
		my @list = map{s/^\s+//;s/\s+$//;$_} split( ',', $id );
		if( @list == 1 ){
			$id = pop @list;
		}else{
			$id = [ @list ];
		}
	}

	if( $this->{'id'} ){
		if( ref($id) =~ /HASH/ ){
			$id = [ keys %{$id} ];
		}
		if( ref($id) =~ /ARRAY/ ){
			if( ref( $this->{'id'} ) =~ /ARRAY/ ){
				my %flds = map{ $_ => 1} @{$this->{'id'}};
				map{ delete $flds{$_} } @{$id};
				return ( @{$this->{'id'}} == @{$id} ) && ! keys %flds;
			}else{
				return 0;
			}
		}else{
			return $id eq $this->{'id'};
		}
	}else {
		return ! $id;
	}
}

sub isValidUnique {
  my $this = shift;
	my @unique = @_;
	if( @{$this->{'unique'}} == 0 ){
		return ((@unique == 0)? 1: 0);
	}else{
		return 0 unless @unique == @{$this->{'unique'}};
		
		my %flds = map{ $_ => 1 } @{$this->{'unique'}};
		foreach my $fld ( @unique ){
			if( exists $flds{$fld} ){
				delete $flds{$fld};
			}
		}
		return ((keys %flds)? 0: 1);
	}
}

sub getListKey {
  my $this = shift;
	if( $this->{'id'} ){
		if( ref( $this->{'id'} ) =~ /ARRAY/ ){
			return join(',',@{$this->{'id'}} );
		}else{
			return $this->{'id'};
		}
		
	}else{
		return undef;
	}
}

sub SQL {
  my $this = shift;
  if ( @_ ) {
    $this->{'sql'}=shift;
  }
  return $this->{'sql'};
}

sub appendSQL {
  my $this = shift;
  if ( @_ ) {
    $this->{'sql'} .= shift;
  }
  return $this->{'sql'};
}

sub FullSQL {
  my $this = shift;
  if ( @_ ) {
    $this->{'fullsql'} = shift;
  }
  return $this->{'fullsql'};
}

sub appendFullSQL {
  my $this = shift;
  if ( @_ ) {
    $this->{'fullsql'}.=shift;
  }
  return $this->{'fullsql'};
}

sub getSQL {
  my $this = shift;
  my $sql = $this->{'fullsql'};
  while ( chomp $sql ){
    $sql =~ s/--.*$//gm;  ## clean comment
  }
  $sql =~ s/;\s*$//;
  return $sql;
}

sub fillFromDB {
  my $this = shift;
  my $sth = shift;
  return 0 unless( ref($sth)=~/DBI/ );

#
# clean
#
  $this->{'fields'} = {};
  $this->{'fldnames'} = [];
  $this->{'indexes'} = [];
  $this->{'unique'} = [];
  
  my($fldNumb,$j,$fldName,$fldType,$fldNull,$field, $fldSize);
  my $dbIsPg = ( $::dbType eq 'Pg' );

  $fldNumb = $sth->{'NUM_OF_FIELDS'};
  for ( $j = 0; $j < $fldNumb; $j++ ) {

    if ($dbIsPg){
      $fldName = lc($sth->{'NAME'}->[$j]);
    } else {
      $fldName = $sth->{'NAME'}->[$j];
    }

		$fldSize = $sth->{'PRECISION'}->[$j];

    $fldType = $sth->{'TYPE'}->[$j];
    $fldNull = $sth->{'NULLABLE'}->[$j];
    $field = sql::Field->new('name'=>$fldName);
    $field->NotNull(1) unless $fldNull;
    if ( $dbIsPg ) {
      if ( $fldType == 5 ) {  ## smallint
				$field->Type('smallint');
      } elsif ( $fldType == 4) { ## int
				$field->Type('int');
      } elsif ( $fldType == 8 ) { ## bigint
				$field->Type('bigint');
      } elsif ( $fldType == 2 ) { ## real
				$field->Type('real');
      } elsif ( $fldType == 7 ) { ## double
				$field->Type('double');
      } elsif ( $fldType == 1700 ) { ## decimal
				$field->Type('decimal');
      } elsif ( $fldType == 1114 ) { ## timestamp
				$field->Type('timestamp');
      } elsif ( $fldType == 9 ) {
				$field->Type('date');
			} else {
				$fldType .= "($fldSize)" if $fldSize;
				$field->Type($fldType);
      }
    }else{
      if ($fldType==-6){ ## tinyint
				$field->Type('tinyint');
      } elsif( $fldType == 4 ){ ## int
				$field->Type('int');
      } elsif ( $fldType == 5 ) { ## smallint
				$field->Type('smallint');
			} elsif ( $fldType == -5 ) {    ## bigint
				$field->Type('bigint');
			} elsif ( $fldType == 11 ) { ## timestamp
				$field->Type('timestamp');
			} elsif ( $fldType == 9 ) { ## date
				$field->Type('date');
			} elsif ( $fldType == 12 ) { ## varchar
				$fldType = 'varchar';
				$fldType .= "($fldSize)" if $fldSize;
				$field->Type( $fldType );
      } elsif ( $fldType == 1 ) { ## varchar
				$fldType = 'varchar';
				$fldType .= "($fldSize)" if $fldSize;
				$field->Type( $fldType );
      } elsif ( $fldType == -1 || $fldType == -4 ){ ## blob
				$field->Type('blob');
      } else {
				$fldType .= "($fldSize)" if $fldSize;
				$field->Type($fldType);
				if ($::DEBUG){
					print STDERR "Found unknown type of field($fldName) : $fldType\n"
				}
      }
    }
    $this->{'fields'}->{$fldName} = $field;
    push @{$this->{'fldnames'}},$fldName;
  }
  return $fldNumb;
}

sub toText {
  my $this=shift;
  my $prefix = shift||'';
  my ($key,$value,$chunk,$cnt);
  my $ret='';
  while ( ($key,$value) = each %{$this}){
    if ( ref($value) =~ /HASH/ ) {
      $ret .= "$prefix$key\t(hash):\n";
      while ( ($key,$chunk) = each %{$value} ) {
				$ret .= $prefix."{$key}\t:\n";
				if ( ref($chunk) =~ /Field/ ) {
					$ret .= $chunk->toText("\t");
				} else {
					$ret .= "$prefix\t$key\t=\t$chunk\n";
				}
      }
    } elsif ( ref($value)=~/ARRAY/ ) {
      $cnt = @{$value};
      $ret .= "$prefix$key\t(array $cnt):\n";
      $cnt = 0;
      foreach $chunk ( @{$value} ) {
				$ret .= $prefix."\t[$cnt]\t=\t$chunk\n";
				$cnt++;
      }
    } else {
      $ret .= "$prefix$key\t=\t$value\n";
    }
  }
  return $ret;
}

1;
