#!/usr/bin/perl

########## Confixx(R) 3.2 Professional ############
####### Copyright SWsoft, Inc. 2004-2006 ##########
##### http://www.swsoft.com - info@swsoft.com #####

BEGIN {

  use FindBin qw($Bin);
	use File::Basename;

  use lib $Bin=~s%(?<=.)/$%%?$Bin:$Bin;
  use lib dirname( $Bin ).'/scripts';
  use lib dirname( $Bin ).'/subs';

#@@CHECK@@
	my $cmd = dirname( $Bin ).'/subs/Confixx_Filter_VERSION.pl 2>/dev/null';

	my $ver = `$cmd`;

	chomp $ver;
	unless( $ver =~ /^[0-9.]+$/){

		$cmd = dirname( $Bin )."/subs/installConfixxFilter.pl -r $Bin/".basename($0);
		exec( $cmd );

		print STDERR <<"EOF";

Fatal error:

There is no Confixx::Filter module installed. Please download one for your OS from Confixx WWW-site.
If there is no package for your operating system contact confixx-support\@sw-soft.com and we will build up one for you as fast as you contact us.

EOF
		exit(1);
	}
#@@/CHECK@@

}

use File::Copy;
use File::Path;
use File::Find;
use DBI;

use lib_module_common;
use lib_module_db;
use lib_module_events;
use Parser::Css;
use Modules::HomeStructure;
use Modules::Backup::Version;
use Modules::System;

use strict;

our ($newVersion,$newLangfileversion);



# it is replaced during make

$newVersion = '3.3.1';
$newLangfileversion = '3.1.0';



use vars qw($wDir $dbh $OBJECT_PRIMARY $EVENT_GO $OBJECT_SECONDARY $checkMasterDb);

($wDir ||= $FindBin::Bin) =~ s%(?<=.)/$%%; ## trim last slash

print "\n\n";

&initConfig;

our $oldVersion = $version;
$confixxState = 'update';

open(LOCK, '>', "$installDir/.confixx_counterscript.lock" );
close(LOCK);

$OSTYPE = `uname -s`;
chop($OSTYPE);

print "update perl modules\n";
safe_do "$installDir/admin/subs/subs_include_questions.pl";
safe_do "$installDir/admin/subs/subs_include_modules.pl";
unless($ENV{'NOCPAN'}){
my ($ret,$ptrArr) = &checkAndInstallFlat();
unless(  $ret ) {
	unless ( &YesNoQuestion( &ltext( 'update_modules_failed' ),'j' ) ) {
		my $listPkgs = join(',', &checkPkgs( $ptrArr ) );
		if ( $listPkgs ) {
			die( &ltext( 'install_question_module_load', $listPkgs) );
		}
	}
}
}
foreach my $script qw( subs_include_writeConfig.pl
											 subs_include_files.pl
											 subs_include_events.pl
											 subs_include_quota.pl
											 subs_include_check.pl
											 subs_include_majo.pl
										 ){

	safe_do "$installDir/admin/subs/$script";
}


unless( $language eq 'de' ) {
	$language = 'en';
}

unless( -e "$installDir/admin/languages/$language/scripts.local" ){
  $language = 'en';
}

$dbh = DBI->connect( $db_address, $dbUser, $dbPw ) or
	die( &ltext('db_connect', '#XXX', $DBI::errstr) );


my @need_binaries = ( 'grep','cp','find','chown','rm','chmod','ifconfig',
											'du','gzip','tar','su');

my @optional_binaries  = ( 'webalizer', 'mysql', 'psql', 'sendmail', 'openssl',
													 'quota', 'quotaon', 'quotaoff', 'quotacheck', 'setquota',
													 'makemap', 'postmap', 'newaliases', 'unzip', 'mysqldump',
													 'apachectl' );
my ($binary);

no strict 'refs';

foreach $binary ( @need_binaries ) {
	unless ( $bin{$binary} && -x $bin{$binary} ){
		$bin{$binary} = ${'bin_'.$binary};
		unless ( $bin{$binary} && -x $bin{$binary} ){
			$bin{$binary} = &getBin( $binary );
		}
	}
}
foreach $binary ( @optional_binaries ) {
	unless ( $bin{$binary} && -x $bin{$binary} ){
		$bin{$binary} = ${'bin_'.$binary};
		unless ( $bin{$binary} && -x $bin{$binary} ){
			$bin{$binary} = &getBin( $binary, "don't ask" );
		}
	}
}

unless( $bin{'apachectl'} && -x $bin{'apachectl'} ) {
    $bin{'apachectl'} = &getBin( 'apache2ctl', "don't ask" );
}

use strict 'refs';

my $secondaryServer = ($dns_server == 2 || $mail_server == 2);

if( $version =~ /^3/ ){
  my $startTime  = time;
  my ($ptrEvent,$ptrCount);
  if($secondaryServer){
#
# secodnary server
#
    $ptrCount = &getEventsCount( $dbh, $OBJECT_PRIMARY, $EVENT_GO );
    if(keys %{$ptrCount}){
      $ptrEvent = &eventGet( 'dbh' => $dbh,
														 'object_type' => $OBJECT_PRIMARY,
														 'event_type' => $EVENT_GO );
      my $primStart = $ptrEvent->{'event_prop'};
      if( $primStart && $startTime < $primStart+600 ){  ## 10 min after starting of primary server
				if (&YesNoQuestion("An update process of the primary server is started".
													 " less than 10 minutes ago.\n".
													 "Do you want to interrupt the update process and to repeat it later?",'j')){
					die "An update process is started on primary server\n".
						"Please repeat to launch update later.\n";
				}
      }
    }
    &eventAdd( 'dbh'=>$dbh,
							 'object_type'=>$OBJECT_SECONDARY,
							 'object_prop'=>'',
							 'event_type'=>$EVENT_GO,
							 'event_prop'=>$startTime );

  }elsif(!$mail_server){
#
# primary server
#
    $ptrCount = &getEventsCount($dbh,$OBJECT_SECONDARY,$EVENT_GO);
    if(keys %{$ptrCount}){
      $ptrEvent = &eventGet( 'dbh' => $dbh,
														 'object_type' => $OBJECT_SECONDARY,
														 'event_type' => $EVENT_GO
													 );
      my $secStart = $ptrEvent->{'event_prop'};
      if($secStart && $startTime<$secStart+600){  ## 10 min after starting of secondary server
				if (&YesNoQuestion("An update process of the secondary server is started less than 10 minutes ago.\n".
													 "Do you want to interrupt the update process and to repeat it later?",'j')){
					die "An update process is started on secondary server\n".
						"Please repeat to launch update later.\n";
				}
      }
    }
    &eventAdd( 'dbh'=>$dbh,
							 'object_type'=>$OBJECT_PRIMARY,
							 'object_prop'=>'',
							 'event_type'=>$EVENT_GO,
							 'event_prop'=>$startTime
						 );
  }
}


my $localPop = $mail_server?1:0;

unless($show_emailtransfer){
  $show_emailtransfer = "0";
}

unless($apacheBackupDay){
  $apacheBackupDay = "1";
}
unless($apacheBackupLocal){
  $apacheBackupLocal = "0";
}

unless($secondaryServer ){

  if ( -d $apacheLogDir ) {
		chmod(0700, $apacheLogDir);
		chown(0, 0, $apacheLogDir);
  }
  
  if ( -d $apacheBackupDir ) {
		chmod(0700, $apacheBackupDir);
		chown(0, 0, $apacheBackupDir);
  }

  if ( -e $httpd_conf ) {
		chmod(0400, $httpd_conf);
		chown(0, 0, $httpd_conf);
  }
  
}  

my $confixx_old_version = $version;

my $sql = "SELECT quota, cssl FROM admin";
if( $ServerID && $master_confixx){
	$sql .= " WHERE server_id='$ServerID'";
}

my $sth = $dbh->prepare( $sql );
unless( $sth->execute ){
	$sql = "SELECT quota, ssl FROM admin";
	if( $ServerID && $master_confixx ){
		$sql .= " WHERE server_id='$ServerID'";
	}
  $sth = $dbh->prepare( $sql );
  $sth->execute;
}

my @row = $sth->fetchrow;
if( $row[0] ){
  
  $use_quota = 1;
  unless($localPop){
    $mail_quota = '';
  }else{
    unless($mail_quota){
      $mail_quota = '1';
    }
  }
  
  if($secondaryServer){
    $user_quota = '';
  } else {
    unless($user_quota){
      $user_quota = '1';
    }
  }

}else{

  $use_quota = 0;
  $mail_quota = 0;
  $user_quota = 0;

}
$sth->finish;

if ( $row[1] ) {
  unless  ( $bin_openssl && -x $bin_openssl ) {
    $bin{'openssl'} = &getBin('openssl');
  }
}
if ( $dbType eq 'mysql' ) {
  unless ( $bin_mysql && -x $bin_mysql ) {
    $bin{'mysql'} = &getBin('mysql');
  }
} else {
  unless ( $bin_psql && -x $bin_psql ) {
    $bin{'psql'} = &getBin('psql');
  }
}
unless( $bin_sendmail && -x $bin_sendmail ) {
  $bin{'sendmail'} = &getBin('sendmail');
}
unless($bin_gzip ne ""){
  $bin{'gzip'} = &getBin('gzip');
}

# process workaround for disabling backup service for users
#
my $user_backup_status = ($backup_off)?0:1;

# if you need to update variables - please, move that code into vars_update.pl
safe_do "$installDir/admin/updates/vars_update.pl";

&UpdateAllConfig (1);

&checkCGI unless $secondaryServer;

if($mail_server){

	if( $mta eq 'qmail' ){
		&changeFWGroup();
		&checkQmailForwards();

	}elsif(  $mta &&
					! ( $aliases && $bin_newaliases && -x $bin_newaliases ) ){
		&getAliases;
	}
}


my($file);

unless(-d "$user_homeDir/empty" || $secondaryServer){
  mkdir("$user_homeDir/empty", 0444);
  chmod(0444, "$user_homeDir/empty");
  chown(0, 0, "$user_homeDir/empty");
}

&UpdateAllConfig (1);

unless($secondaryServer){

  my ($kunde,$home,$uid,$cmd,$find,$newuid,$account,$path,$dir,$docroot);

	&checkApacheUser();

#
# fix home's permissions
#
	my $homeStructure = Modules::HomeStructure->new();

	my ($oldNVer);

	if ( $oldVersion =~ /(\d+)\.(\d+)\.(\d+)/ ) {
		$oldNVer = $1+ ( $2 + $3 * 0.001 ) * 0.001;
	}
	if ( defined($oldNVer) && 
			 ( ($oldNVer < 2.000014) || ($oldNVer >= 3 && $oldNVer < 3.000004) ## old shema of permissions
			 )
		 ) {
		$homeStructure->RestoreUsersPermissions( 1 ); ## force fix permissions of user's files/dirs

	} else {
		$homeStructure->RestoreUsersPermissions( $restore_users_permissions );
	}
	
	$sql = "SELECT kunde,uid FROM kunden";
	if( $ServerID && $master_confixx){
		$sql .= " WHERE server_id='$ServerID'";
	}
  $sth = $dbh->prepare( $sql );
  $sth->execute()
    or die "Error execute sql: DBI->errstr\n";
  while (($kunde,$uid)=$sth->fetchrow()){

		next unless $uid;

		unless($homeStructure->createHome( 'user' => $kunde,
																			 'uid' => $uid,
																			 'gid' => $uid )
					){
			my $errorCode = $homeStructure->lastErrorCode();
			my $fullPath = $homeStructure->lastFullPath();
			if($errorCode eq 'delete'){
			}elsif($errorCode eq 'create'){
				print &ltext('install_dir_create',$fullPath);
			}elsif($errorCode eq 'chmod'){
				print &ltext('install_file_chmod',$fullPath);
			}elsif($errorCode eq 'chown'){
			}
		}

#
# fix ownership of files in ~/backup to root:user
#
		$dir = "$user_homeDir/$kunde/backup";
		$cmd = "$bin_find $dir -type f | xargs -r $bin_chown 0:$uid";
		unless(system($cmd)==0){
			warn "Error by execute command '$cmd' ($!)\n";
		}

#
# fix ownership of files in ~/html to user ( ftp-account has same uid as user )
#

		$docroot = "$user_homeDir/$kunde/html";

		&fixOwnership($docroot, $uid,$uid, $apacheUser=>$gidapache );

 		$cmd="$bin_chown $uid:$gidapache $docroot";  ## restore ownership of ~/html
		unless(system($cmd)==0){
			warn "Error by execute command '$cmd' ($!)\n";
		}	

		$dir = $docroot.'/cgi-bin/bin';  ## restore ownershif of ~/html/cgi-bin/bin
		if(-d $dir){
	 		$cmd="$bin_chown -R 0:0 $dir";
			unless(system($cmd)==0){
				warn "Error by execute command '$cmd' ($!)\n";
			}	
		}

		$dir = $docroot.'/_vti_pvt';
		if(-d $dir){
			$cmd = "$bin_chown $uid:$gidapache $dir";  ## set up ownership like ~/html
			unless( system( $cmd ) == 0){
				warn "Error by execute command '$cmd' ($!)\n";
			}	
		}

		$dir = "$user_homeDir/$kunde/files";
		&fixOwnership( $dir, $uid, $uid, $apacheUser => $gidapache );
 		$cmd = "$bin_chown $uid:$gidapache $dir";  ## restore ownership of ~/files
		unless( system( $cmd ) == 0){
			warn "Error by execute command '$cmd' ($!)\n";
		}	
#		&fixOwnership("$user_homeDir/$kunde/phptmp", $uid=>$uid, $apacheUser=>$gidapache );
		

  }
  $sth->finish();	
}

#
# fix bug #29846
#
my $gen_mhost="$installDir/admin/scripts/gen_mhost.pl";
if(-e "$gen_mhost.pl"){
	if(-e $gen_mhost){
		unlink "$gen_mhost.pl";
	}else{
		rename "$gen_mhost.pl",$gen_mhost; 
	}		
}
#
# end fix bug #29846
#



if($secondaryServer){
  print "run on secondary server\n";
}else{
  print "run on primary server\n";
}

$version = $newVersion;
$langfileversion = $newLangfileversion;

unless( $ServerID ){
	if($dns_server == 2 || $mail_server == 2){
		$scndServerID = generateServerID( 'Secondary' );
		$sth = $dbh->prepare( "SELECT server_id FROM admin" );
		if( $sth->execute && ( $sth->rows == 1 ) ){
			( $ServerID ) = $sth->fetchrow();
			$sth->finish;
		}
		unless( $ServerID ){
			if( -f "$installDir/confixx_master.conf" ){
				&loadConfFile( "$::installDir/confixx_master.conf" );
				my $dbhLocal = DBI->connect($db_local_dsn, $dbLocalUser, $dbLocalPw);
				if( $dbhLocal ){
					$sth = $dbhLocal->prepare( "SELECT server_id FROM admin" );
					if( $sth->execute ){
						( $ServerID ) = $sth->fetchrow();
						$sth->finish;
					}
					$dbhLocal->disconnect;
				}
			}
		}
	}else{
		$ServerID = generateServerID( 'Primary' );
	}
}

&UpdateAllConfig( 'without_bin' );

unless($secondaryServer){
  print "launching db_update.pl\n";
  safe_do "$installDir/admin/updates/db_update.pl";

  if( $master_confixx == 2 ){
	print "launching db_update.pl (master)\n";
	$checkMasterDb = 1;
	safe_do "$installDir/admin/updates/db_update.pl";
  }

  print "launching files_update.pl\n";
  safe_do "$installDir/admin/updates/files_update.pl";

	&UpdateAllConfig( 1 );

	&checkDbConnect();

#
# bug #74192
#
	my $oldVer = Modules::Backup::Version->new( $confixx_old_version );
	if( $oldVer->lessThan( '3.1.0' )){
		my $sql;
		if($dbType eq 'mysql'){
			$sql = "UPDATE domains SET cssl=IF(cssl>1,1,2) WHERE cssl IN (1,2) AND server_id='$ServerID'";
		}else{
			$sql = "UPDATE domains SET cssl = CASE WHEN cssl>1 THEN 1 ELSE 2 END WHERE cssl IN (1,2) AND server_id='$ServerID'";
		}
 
		$dbh->do( $sql );
	}

#
# end bug #74192
#

#
# bug #84994 - need to turn off backup service for all users if backup_off = '1'
# (backup_off is workaround for turn off backup service for users implemented in 3.0.x)
#
	unless ($user_backup_status) {
	    my $sql = "UPDATE kunden set backup = '0' WHERE server_id='$ServerID'";
	}
#
# end of bug #84994
#

}



if ($mysqlUserServer && $mysqlUserUser ) {

	print "check user's mysql connection\n";

	$mysqlUserHost ||= 'localhost';
	my $userDSN = &makeDSN('mysql',$mysqlUserServer,'mysql',$mysqlUserPort);
	my $userDbh = DBI->connect($userDSN,$mysqlUserUser,$mysqlUserPw);
	if ( $userDbh ) {
		my $sql = "SELECT  kunde, MAX(dbext) as dbext FROM mysql_datenbanken WHERE server_id='$ServerID' GROUP BY kunde";
		my $userSth = $dbh->prepare( $sql );
		my $err = DBI->errstr;
		$sql = "SELECT dbname, dbext FROM mysql_datenbanken WHERE kunde=? AND server_id='$ServerID'";
		my $dbSth = $dbh->prepare( $sql );
		$err .= "\n" if $err;
		$err .= DBI->errstr;
		$sql = "SELECT * FROM user WHERE user=? AND host=? ";
		my $mysqlUserSth = $userDbh->prepare( $sql );
		$err .= "\n" if $err;
		$err .= DBI->errstr;
		$sql = "SELECT * FROM db WHERE user=? AND host=? AND db=? ";
		my $mysqlDbSth = $userDbh->prepare( $sql );
		$err .= "\n" if $err;
		$err .= DBI->errstr;
		if ( $userSth && $dbSth && $mysqlUserSth && $mysqlDbSth ) {

			my ($user,$ext,%hosts,$host,%row);
			$userSth->execute;
			while (($user,$ext) = $userSth->fetchrow) {
#
# check 'user'-table
#
				%hosts = ( ( $ext? '%': '127.0.0.1' ) => 1, 
									 'localhost' => 1, 
									 $mysqlUserHost => 1 );
				%row = ();
				foreach $host (keys %hosts) {
					$mysqlUserSth->execute( $user, $host);
					if ( $mysqlUserSth->rows ) {
						unless ( keys %row ) {
							%row = %{$mysqlUserSth->fetchrow_hashref};
						}
						$hosts{$host} = 0; ## ok
					}
					$mysqlUserSth->finish;
				}
				unless (keys %row){
					warn "User 'user' has not accont to user's mysql\n";
					next;
				}

				foreach $host ( grep{ $hosts{$_} } keys %hosts ) {
					if ( exists($row{'host'}) ) {
						$row{'host'} = $host;
					} else {
						$row{'Host'} = $host;
					}
					$sql = "INSERT INTO user (".join( ',', keys %row ).
						") values (".join( ',', map{"'$_'"} values %row).")";
					$userDbh->do( $sql );
				}
#
# /check 'user'-table
#
#
# check 'db'-table
#
				$dbSth->execute( $user );
				my ($db,$slashDb);
				while ( ( $db, $ext ) = $dbSth->fetchrow ) {
					%hosts = ( ( $ext? '%': '127.0.0.1' ) => 1, 
										 'localhost' => 1, 
										 $mysqlUserHost => 1 );
					%row = ();
					( $slashDb = $db ) =~ s/_/\\_/g;
					foreach $host (keys %hosts) {
						$mysqlDbSth->execute( $user, $host, $slashDb);
						if ( $mysqlDbSth->rows ) {
							unless ( keys %row ) { ## get source to clone
								%row = %{$mysqlDbSth->fetchrow_hashref};
							}
							$hosts{$host} = 0; ## ok 
						}
						$mysqlDbSth->finish;
					}
					unless (keys %row){
						warn "User 'user' has not accont to database '$db'\n";
						next;
					}

					foreach $host ( grep{ $hosts{$_} } keys %hosts ) {
						if ( exists($row{'host'}) ) {
							$row{'host'} = $host;
						} else {
							$row{'Host'} = $host;
						}
						$sql = "INSERT INTO db (".join( ',', keys %row ).
							") values (".join( ',', map{"'$_'"} values %row).")";
						$userDbh->do( $sql );
					}
				}
				$dbSth->finish;
#
# /check 'db'-table
#
			}
			$userSth->finish;

		} else {
			warn "Error: can't get user's mysql info:\n$err\n";
		}

		$userDbh->disconnect;
	}
}


print "launching scripts_install.pl\n";
safe_do "$installDir/admin/subs/scripts_install.pl";

$bin_cp ||= $bin{'cp'} || 'cp';
$bin_su ||= $bin{'su'} || 'su';
$stdShell ||= '/bin/sh';

my %skinsColor = ( '#64a4eb' => 1,
									 '#65a4eb' => 1,
									 '#7bca81' => 2,
									 '#c7d6a4' => 3,
									 '#c36f56' => 4,
									 '#cbcbd5' => 5
								 );

my %checkCss = ( 'nav' => 'css/nav.css',
								 'style' => 'style.css',
								 'dtree' => 'css/dtree.css',
								 'images' => 'css/images.css',
							 );

unless($secondaryServer){
  print "launching webPages_install.pl\n";
  safe_do "$installDir/admin/subs/webPages_install.pl";

# for suPHP Add $confixx_user to apache group 
	&AddGroup($apacheGroup,$confixx_user);

#
# update default skins
#
	my $dstSkins = "$confixx_htmlDir/skins";
  unless ( -d $dstSkins ) {
    mkdir ( $dstSkins );
    system( "$bin_cp -r \"$installDir/admin/html/skins/*\" \"$dstSkins\"" );
    system( "$bin_chown -R $confixx_uid:$confixx_gid \"$dstSkins\"" );
  }
	chmod( 0775, $dstSkins );
	chown( $confixx_uid, $gidapache, $dstSkins );

  unless ( -d $confixx_sbinDir ) {
    mkdir ( $confixx_sbinDir, 0751 );
    system( "$bin_cp -rf \"$installDir/admin/scripts/Modules/\" \"$confixx_sbinDir/Modules\"");
    system( "$bin_chown -R $confixx_uid:$confixx_gid \"$confixx_sbinDir/Modules\"");;
  }
	chmod (0751,$confixx_sbinDir );

	my ( $row,$skin,$cmd,$dir,$skinName, %skins );

	my $sth = $dbh->prepare ( "SELECT id,owner_type,name,version ".
														" FROM custom_skins WHERE server_id='$ServerID'" );
	$sth->execute;
	while ( $row = $sth->fetchrow_hashref ){

		$skins{$row->{'name'}} = $row->{'id'}; ## register skin

		next unless ( $row->{'owner_type'} =~ /reseller/ );
		
		my ( $skins_user, $skins_group, $there_is, $skin_dir );
		if ($php_engine eq 'suphp'){
			$skins_user = $confixx_user;
			$skins_group = $confixx_group;
		}else{
			$skins_user = $apacheUser; 
			$skins_group = $gidapache;
		}
		
		$skinName = (($row->{'version'}eq'powp')?'mskin_':'skin_').$row->{'id'};
		
		$skin_dir = "$dstSkins/$skinName";
		if ( -d $skin_dir  ) {
			$there_is = 1;
			if( $row->{'version'} eq 'xp30' ){
				$there_is = 0 unless -f "$skin_dir/style.css";

			}elsif( $row->{'version'} eq 'powp' ){
				$there_is = 0 unless -f "$skin_dir/css/general.css";
			}
			unless( $there_is ){
				rmtree( $skin_dir );
			}
		}else{
			$there_is = 0;
		}
		if( $there_is ){
			if( $row->{'version'} eq 'xp30' ){
				&fixSkinVersion( $dstSkins, $skinName );
			}
			system( "$bin_chown -R $skins_user:$skins_group \"$skin_dir\"" );
		} else {
			$skin = "$confixx_sbinDir/skinmng.pl --skin $skinName --new_skin --use_dir mskin_1 --force";
			$cmd = "$bin_su - -s $stdShell $skins_user -c '$skin'";
			unless ( system( $cmd ) == 0 ) {
				warn ("Error execute command: $cmd\n$!\n");
			}
		}
	}
	$sth->finish;

	if ( opendir (DIR, $dstSkins) ) {
		while ( $skinName = readdir(DIR) ) {

			next if $skinName =~ /^\.\.?$/;
			next unless ( -d "$dstSkins/$skinName" );
			next if exists $skins{$skinName}; ## already is prepared
			next unless $skinName =~ /^skin_\d+$/;

			system( "$bin_chown -R $apacheUser:$gidapache \"$dstSkins/$skinName\"" );
			
		}
		closedir(DIR);
	} else {
		warn "Can't open dir '$dstSkins': $!\n";
	}

#
# /update default skins
#

  print "launching cgis_install.pl\n";

	$sth = $dbh->prepare ( "SELECT webftp,webmail FROM admin WHERE server_id='$ServerID'" );
	$sth->execute;
	($use_webftp,$use_webmail) = $sth->fetchrow;
	$sth->finish;

  safe_do "$installDir/admin/subs/cgis_install.pl";

	&installAllCGIs( $dbh );

}
print "\n";

&checkDbConnect();

if ( $::use_quota){
  &quotaSupportCheck();
  &UpdateAllConfig (1);
}

if(-x "/usr/bin/chsh"){
  chmod(0755, "/usr/bin/chsh");
}
if(-x "/usr/local/bin/chsh"){
  chmod(0755, "/usr/local/bin/chsh");
}

if ($mail_server){
  if($spamassassin_support){
		safe_do "$installDir/admin/subs/spamassassin_install.pl";
		$spamassassinUid = &getSpamdUid( $spamassassinScript );
		&WriteMainConfigFile();
		&installSpamassassin();	
  }
}

my($return);

unless($secondaryServer){
  print "\n\n";
  if ( $ftpDaemon eq 'ProFTPD' ) {
    safe_do "$installDir/admin/subs/proFTPD_install.pl";

  } elsif ( $ftpDaemon eq 'wu-ftpd' ) {
    safe_do "$installDir/admin/subs/wu-ftpd_install.pl";

  } elsif ( $ftpDaemon eq 'vsftpd' ) {
    safe_do "$installDir/admin/subs/vsftpd_install.pl";
  }
}


unlink("$installDir/.confixx_counterscript.lock");

&checkDbConnect();
$dbh->do("UPDATE allgemein SET confixxupdate = 0 WHERE server_id='$ServerID'");


if($confixx_old_version=~/^3/ && ($secondaryServer || !$mail_server)){
#
# launch for version 3.* and only on the duble server system
#
  system("$installDir/admin/contrib/fix_uids.pl");
}

print "\nConfixx update script started. \nWARNING: The operation could take a long time.\n";

system ( "cd $installDir; $installDir/confixx_updatescript.pl --force-all --skip-calc" );
unlink ( "$installDir/confixx_counterscript.pl" );
symlink ( "$installDir/confixx_updatescript.pl", "$installDir/confixx_counterscript.pl" );

#
# clean events
#

if($confixx_old_version=~/^3/){
  if($secondaryServer){
#
# secodnary server
#
    &eventAdd('dbh'=>$dbh,'object_type'=>$OBJECT_SECONDARY,
	    'event_type'=>$EVENT_GO,'object_prop'=>'','count'=>0);

  }elsif(!$mail_server){
#
# primary server
#
    &eventAdd('dbh'=>$dbh,'object_type'=>$OBJECT_PRIMARY,
	    'event_type'=>$EVENT_GO,'object_prop'=>'','count'=>0);
  }
}
$dbh->disconnect;


&print_congratulations();

#
#
#==================================================
#
#

my %hashCss = ();

sub fixSkinVersion{

	my( $skinDir, $skinName ) = @_;
	
	my $nav = Parser::Css->new( "$skinDir/$skinName/".$checkCss{'nav'} );
	my $bkColor = $nav->getAttribute( 'body', 'background-color' );
	
	my $skin = $skinsColor{$bkColor} if $bkColor;
	unless( $skin ){
		print STDERR "Error: Can't find the master skin for '$skinName\n'";
		return 0;
	}

	my $masterSkin = $skinDir.'/skin_'.$skin;
	unless( -d $masterSkin ){
		print STDERR "Error: Can't find master skin '$masterSkin'\n";
		return 0;
	}

	my($key,$file,$masterFile, $path,$css,$masterCss,$save);
	while( ( $key, $file ) = each( %checkCss ) ){
		$path = "$skinDir/$skinName/$file";
		$masterFile = "$masterSkin/$file";
		unless( -f $path ){
			copy( $masterFile, $path );
			next;
		}
		if($key eq 'nav'){
			$css = $nav;
			$save = $css->delAttributes( 'body',
																	 'background-image',
																	 'background-position',
																	 'background-repeat'
																 );
		}else{
			$css = Parser::Css->new( $path );
		}

		unless( $masterCss = $hashCss{$masterFile} ){
			$masterCss = Parser::Css->new( $masterFile );
			$hashCss{$masterFile} = $masterCss;
		}
		
		if( $css->merge( $masterCss ) || $save ){
			copy( $path, $path.'.confixx_save' );
			$css->save();
		}

	}	

#
# check dirs & images
#
	my $reSubPath = qr|^\Q$masterSkin\E/(.+)|;
	my( $dstPath );

	find sub{
		if( -d $File::Find::name ){
			if( $File::Find::name =~ /$reSubPath/ ){
				$dstPath = "$skinDir/$skinName/$1";
				unless( -d $dstPath ){
					if( mkdir( $dstPath ) ){
						chmod 0755, $dstPath;
					}
				}
			}
		}elsif( /\.(gif|jpg)$/ && -f $File::Find::name ){
			if( $File::Find::name =~ /$reSubPath/ ){
				$dstPath = "$skinDir/$skinName/$1";
				unless( -f $dstPath ){
					if( copy( $File::Find::name, $dstPath ) ){
						chmod 0644, $dstPath;
					}
				}
			}
			}
	}, $masterSkin;

}

sub print_congratulations() {

	my $width = 56;
	my $text = <<CONGRAT;
The upgrade process was successfully completed.
Your Confixx installation is upgraded to $newVersion.
CONGRAT
	
	&print_line($width);
	&print_empty_line($width);
	&print_text_center_align("Congratulations!", $width);
	&print_text_width_align($text, $width);
	&print_empty_line($width);
	&print_line($width);
}

# Print line of asterisks (*) of $ln length
# 
sub print_line($) {
	my ($len) = @_;
	print "*" x $len;
	print "\n";
}

# Dumb routine for printing text bordered by (*)
# NOTE: no text wrapping imlemented, rough alignment must be done manually.
sub print_text_width_align($$) {
	my ($text, $block_width) = @_;
	my $padding = 3;
	my $border  = 1;
	my $text_area_width = int($block_width - $padding*2 - $border*2);

#	print STDERR "TAW = $text_area_width\n";
	my @lines = split /^/m, $text;
	foreach (@lines) {
		chomp;
		my @words = split;
		my $line = $_;

		my $orig_len = length($line);	# length of original string
		my $word_len = 0;				# length of string w/o spaces
		foreach (@words) { $word_len += length }
		# number of space-delimiters between words
		my $num_spaces = scalar(@words) - 1;	
		
#		print STDERR "OL = $orig_len, WL = $word_len, NS = $num_spaces\n";

		if ($orig_len > $text_area_width)  {
			# castrate, line wrapping is too complex to imlpement it now
			print "*", " " x $padding, 
			  substr($line, $orig_len-3, 3, '...'), 
			  " " x $padding, "*", "\n";
			next;
		} elsif ($orig_len == $text_area_width)  {
			print "*", " " x $padding, 
			  $line,
			  " " x $padding, "*", "\n";
			next;
		}
		
		# do width alignment
		#
		if ($num_spaces > 0) {
			# more than one word.
			
			# number of spaces to insert
			my $spaces_total = $text_area_width - $word_len;
			# average delimiter size
			my $average_space = int($spaces_total / $num_spaces);
			# number of bonus_spaces are always less than 
			my $bonus_spaces  = $spaces_total % $num_spaces;
#			print STDERR "ST = $spaces_total, AS = $average_space, BS = $bonus_spaces\n";

			my $space_str = "";	# space string
			for (my $i = 0; $i < $average_space; ++$i) {
				$space_str .= " ";
			}

			my $res_line = "";
			for (my ($i,$spaces_to_add) = (0, $bonus_spaces); $i < $num_spaces; ++$i) {
				$res_line .= $words[$i] . $space_str;
				if ($spaces_to_add > 0) {
					$res_line .= " ";	# bonus space
					--$spaces_to_add;
				}
			}
			$res_line .= $words[$#words];
			
			print "*", " " x $padding, $res_line, " " x $padding, "*", "\n";
			next;
			
		} else {
			my $fill_right = $text_area_width - $orig_len;
			print "*", " " x $padding, $line, " " x $fill_right,  " " x $padding, "*", "\n";
			next;

		}
	}
}

sub print_text_center_align($$) {
	my ($text, $block_width) = @_;

	my $padding = 3;
	my $border  = 1;
	my $text_area_width = int($block_width - $padding*2 - $border*2);
	
#	print STDERR "TAW = $text_area_width\n";
	my @lines = split /^/m, $text;
	foreach (@lines) {
		chomp;
		my @words = split;
		my $line = $_;
		
		my $orig_len = length($text);
		my $free_space = $text_area_width - $orig_len;
		my $fill_left = int (($free_space) / 2);
		my $fill_right = $free_space - $fill_left;
		
		print "*", " " x $padding, " " x $fill_left, 
		  $line, " " x $fill_right,  " " x $padding, "*", "\n";
		next;
	}
}

# print line like "*         *";
sub print_empty_line($) {
	my ($block_width) = @_;
	print "*", " " x ($block_width - 2),  "*", "\n";
}

#
# end of update
#
#====================================================================

## Unterprogramme

sub getAliases{
  my ( $default_aliases );

  if ( $mta eq "sendmail" ){
    $default_aliases = "/etc/mail/aliases";
    if( ! ( -e "/etc/mail/aliases") && ( -e "/etc/aliases" ) ){
      $default_aliases = "/etc/aliases";
    }
  }
  elsif ( $mta eq "postfix" ){
    $default_aliases = "/etc/postfix/aliases";
    if( ! ( -e "/etc/postfix/aliases" ) && ( -e "/etc/aliases" ) ){
      $default_aliases = "/etc/aliases";
    }
  }

  $bin{'newaliases'} = &getBin('newaliases');

  $aliases = &FileQuestion ( &ltext("install_$mta"."_aliases"), $default_aliases );

  if($aliases ne ""){
    &BackUpFile($aliases, "$installDir/backup/$mta/aliases");
    &BackUpFile($aliases, "$installDir/safe/aliases_header");
  }

}

sub changeFWGroup{
  my $mtaGroup = 'mtafw';
  unless($mta_gid = getgrnam($mtaGroup)){
    $mta_gid = &AddGroup($mtaGroup);
  }
  my(@Passwd, $i);
  $i = 0;
  open(PASSWD, "$installDir/safe/passwd_header");
  while(<PASSWD>){
    if($_ =~ /^confixxfw_(\w+):x:(\d+):$giduser\::/){
      $_ =~ s/$giduser/$mta_gid/;
    }
    $Passwd[$i++] = $_;
  }
  close(PASSWD);

  open(PASSWD, ">$installDir/safe/passwd_header");
  print PASSWD @Passwd;
  close(PASSWD);
}

sub checkCGI{
  unless(-d "$installDir/cgi/html/cgi-bin"){
    mkdir("$installDir/cgi", 0700);
    unless(-e "$installDir/cgi/aendern"){
      open(FILE, ">$installDir/cgi/aendern");
      print FILE "#Hier die zu Andernden Dateien eintragen z.B:\n#cgi-bin/FormMail.cgi:755\n#bestellen.html:644\n";
      close(FILE);
    }
    mkdir("$installDir/cgi/html", 0700);
    mkdir("$installDir/cgi/html/cgi-bin", 0700);
  }
}

# add group to /etc/group with its members
# arg $group - name of group
# arg @members - array/list of group members
sub AddGroup ($@) {
	my($group, @members) = @_;
	my($gid, %gid, $i, $stop);
	$gid = getgrnam($group);
	if(defined $gid && $gid =~ /^\d+$/){
		$i = $gid;
		if(@members){
			my (@lines,$pattern,$prefix,$suffix,%items,$npp,$item,$wasAdd);
			$pattern = qr/^(\Q$group\E:[^:]*:\d+:)(.*)/;
			if(open(GROUP, "<$groupDir")){
				while(<GROUP>){
# find line of $group
					if($_ =~ /$pattern/){
						$prefix=$1;
						$suffix = $2;
						$npp=0;
						chomp $suffix;
						%items = map {$_=>$npp++} split(/\s*,\s*/,$suffix);
# check if $group has all @members
						foreach $item (@members){
							unless(exists($items{$item})){
								$wasAdd=1;
								$items{$item}=$npp++;
							}
						}
						$suffix = join(',',keys %items);
						push @lines,$prefix.$suffix."\n";
					}else{
						push @lines,$_;
					}
				}
				close (GROUP);
				if($wasAdd){
#
# save new memebers to group
#
					if(open(GROUP,">$groupDir")){
						foreach $item (@lines){
							print GROUP $item;
						}
						close (GROUP);
					}
				}
			}
		}
	}else{
    if ( open(GROUP, "<$groupDir") ) {
			while(<GROUP>){
				if($_ =~ /^[^:]+:[^:]*:(\d+):/){
					$gid{$1} = 1;
				}
			}
			close(GROUP);
		}
		$stop = 0;
		$i = 500;
		while(defined $gid{$i}){
			$i++;
		}
		print &ltext('install_groupadd', $group);
		my $members_str = join(',', @members);
		if ( open(GROUP, ">>$groupDir") ) {
			print GROUP "$group:x:$i:$members_str\n";
			close(GROUP);
		}
	}
	return($i);
}

sub checkDbConnect {
	unless ($dbh->ping()){
		$dbh->disconnect();
		$dbh = DBI->connect($db_address, $dbUser, $dbPw)
			or die( &ltext('db_connect', '#XXX', $DBI::errstr) );
	}
}

sub checkApacheUser { 

	my %apacheOwner = ('User' => $apacheUser,
										 'Group' => $apacheGroup);

	my $apacheDir = dirname( $httpd_conf );
	unless ( &checkApacheConfig( $apacheDir, \%apacheOwner ) ) {

		my $dist = &GetLinuxVersion();

		if ( $dist =~ /(redhat|mandrake)/ ) {
			$apacheOwner{'User'} = 'apache';
			$apacheOwner{'Group'} = 'apache';

		} elsif ( $dist =~ /debian/ ) {
			$apacheOwner{'User'} = 'www-data';
			$apacheOwner{'Group'} = 'www-data';

		} elsif ( $dist =~ /suse/ ) {
			$apacheOwner{'User'} = 'wwwrun';
			$apacheOwner{'Group'} = 'www';
			
		} else {
			$apacheOwner{'User'} = 'www';
			$apacheOwner{'Group'} = 'www';
		}

		$apacheOwner{'User'} = &UGQuestion( &ltext('install_question_apacheuser') , $apacheOwner{'User'});
		$apacheOwner{'Group'} = &UGQuestion( &ltext('install_question_apachegroup') , $apacheOwner{'Group'});
	}

	if ( ( $apacheOwner{'User'} && ( $apacheUser ne $apacheOwner{'User'} ) ) ||
			 ( $apacheOwner{'Group'} && ( $apacheGroup ne  $apacheOwner{'Group'} ) ) 
		 ) {

		$apacheUser = $apacheOwner{'User'};
		$apacheGroup = $apacheOwner{'Group'};

		&UpdateMainConfig;
	}
}

sub GetLinuxVersion {
	my ( $dist, $dist_ver );

	if ( -e "/etc/redhat-release" ) {
		$dist = 'redhat';

	}	elsif ( -e "/etc/mandrake-release" ) {
		$dist = 'mandrake';

	}	elsif ( -e "/etc/SuSE-release" ) {
		$dist = 'suse';
		$dist_ver = &get_version_of_SuSE('/etc/SuSE-release');

	} elsif ( -e "/etc/debian_version" ) {
		$dist = 'debian';
	}

	if ( wantarray() ) {
		return ($dist, $dist_ver);
	} else {
		return $dist;
	}
}

