#!/usr/bin/perl

########## Confixx(R) 3.0 Professional ############
####### Copyright SWsoft, Inc. 2004-2005 ##########
#### http://www.sw-soft.com - info@sw-soft.com ####

BEGIN {
  use FindBin;
  use lib "$FindBin::Bin";
  use lib "$FindBin::Bin/../scripts";
  use lib "$FindBin::Bin/../subs";
}

use File::Basename;

use strict;

use lib_module_common;
use lib_module_db;



($::dist, $::dist_ver) = &GetUserInfo();



# -------------------- MAIN -------------------- #

#
# update database connection settings
#
if ( $::mysql_sock && -S $::mysql_sock ) {
	if ( $::dbType eq 'mysql' && $::dbServer eq 'localhost' ) {
		$::dbPort = $::mysql_sock unless $::dbPort;
	}
	if ( $::mysqlUserServer eq 'localhost' ) {
		$::mysqlUserPort = $::mysql_sock unless $::mysqlUserPort;
	}
}
if ( $::mysql_host ) {
  if ($::dbType eq 'mysql' && $::dbServer eq $::mysqlUserServer ) {
		$::dbMysqlHost = $::mysql_host; 
  }
  $::mysqlUserHost = $::mysql_host;
}

my($ret,$str);
if ( $::dbType eq 'mysql' ) {
	($ret,$str) = &getMysqlVersion( { 'server' => $::dbServer,
																		'user' => $::dbUser,
																		'password' => $::dbPw,
																		'port' => $::dbPort,
																		'dbname' => $::dbDB, 
																	}
																);
	$::dbMysqlVersion = $str if $ret;
}

if ( $::mysqlUserServer eq 'localhost' ) {

	my $ptrHash = &parseMyCnf('/etc/my.cnf','datadir','socket','port');

	unless ( $::mysql_homeDir && -d $::mysql_homeDir ) {
		if ( $ptrHash->{'datadir'} && -d $ptrHash->{'datadir'} ) {
			$::mysql_homeDir = $ptrHash->{'datadir'};
		}
	}
	unless ( $::mysqlUserPort ) {
		if ( $ptrHash->{'socket'} && -S $ptrHash->{'socket'} ) {
			$::mysqlUserPort = $ptrHash->{'socket'};
		}
	}
}

if ( $::mysqlUserServer && $::mysqlUserUser ) {
	if ( $::mysqlUserServer eq $::dbServer ) {
		$::mysqlUserVersion = $::dbMysqlVersion;
		if ( $::dbType eq 'mysql' && !$::mysqlUserPort ) {
			$::mysqlUserPort = $::dbPort;
		}

		$::mysqlUserHost ||= &getMysqlHost( { 'server' => $::mysqlUserServer,
																					'user' => $::mysqlUserUser,
																					'password' => $::mysqlUserPw,
																					'port' => $::mysqlUserPort
																				} );
	} else {
		($ret,$str) = &getMysqlInfo( { 'server' => $::mysqlUserServer,
																	 'user' => $::mysqlUserUser,
																	 'password' => $::mysqlUserPw,
																	 'port' => $::mysqlUserPort
																 }
																	);
		if( $ret ) {															
		  $::mysqlUserVersion = $ret->{'server version'};
		  my ($user,$host) = split(/@/,$ret->{'current user'});
		  if ( $host ) {
			$::mysqlUserHost = $host;
		  }	else {
			$::mysqlUserHost ||= 'localhost' if $::mysqlUserServer eq 'localhost';
		  }
		}  
	}
}

unless( $::php_engine ){
 	$::php_engine = 'mod_php';
}

&setVariable ( \$::spamassassin_support );
&setVariable ( \$::coldfusion_support );
&setVariable ( \$::cronjobs_support );
&setVariable ( \$::rpm_version_flag );
&setVariable ( \$::no_questions_mode );
&setVariable ( \$::no_pipelog_mode );
&setVariable ( \$::inode_std );
&setVariable ( \$::awstats );
&setBin ( 'tar' );
&setBin ( 'su' );
&setPath ( \$::confixx_sbinDir, $::confixx_htmlDir, 'sbin' );
&setPath ( \$::mhost_conf, $::vhost_conf, 'confixx_mhost.conf' );

if ( $::mail_server ){
  
  $::maildrop ||= ($::mta eq 'qmail' )? 'HOMEDIR/Maildir/': '/var/spool/mail/USER';
  
	unless($::majordomo_quota && $::majordomo_quota ne '' ){
	    $::majordomo_quota = $::use_quota && $::majordomo_ldir ? 1 : 0;
	}

	unless($::use_events && $::use_events ne ''){
		$::use_events = ( $::mta =~ /^(sendmail|postfix|qmail)$/ ) ? 1 : 0;
	}
}

if ( $::mail_server!=2 && $::dns_server!=2 ){ ## primaty server
	my ( $defaultApacheScript, $apacheScript );

#
# bug #40244: check & make $::groupDir
#
	unless ( $::groupDir && ( -T $::groupDir ) ) { ## must be an ASCII-file
		my $newGroup = $::passwdDir;
		if ( $newGroup =~ s/\/[^\/]+$/\/group/ ) {
			if ( -T $newGroup ) {
				$::groupDir = $newGroup;
			}
		} else {
			$newGroup = $::groupDir;
		}
		unless ( $::groupDir && ( -T $::groupDir ) ) { ## must be an ASCII-file
			die "Unable to get path to 'group'-file. ('$newGroup' is not an ASCII-file)\n";
		}
	}

	if($::pm_apache_reload eq "" || $::pm_apache_start eq ""){ 

		$defaultApacheScript = "/etc/init.d/httpd";
		if ( -e "/etc/debian_version" ){
			$defaultApacheScript = "/etc/init.d/apache";
		}elsif ( -e "/etc/SuSE-release" ){
			$defaultApacheScript = $::httpd eq "apache2.0" ? "/etc/init.d/apache2" : "/etc/init.d/apache";
		}
		$apacheScript = FileQuestion ( ltext("install_question_apache_script"), $defaultApacheScript );
		$::pm_apache_reload = "$apacheScript reload";
		$::pm_apache_start  = "$apacheScript start";
	}
		
	unless($::apacheUser && ( $::apacheUser ne 'root' ) && $::apacheGroup){
		my %apacheOwner = ('User'=>$::apacheUser,
							'Group'=>$::apacheGroup);

		if (&checkApacheConfig($::httpd_conf,\%apacheOwner) 
				&& $apacheOwner{'User'} && $apacheOwner{'Group'}
			 ){
			$::apacheUser = $apacheOwner{'User'};
			$::apacheGroup = $apacheOwner{'Group'};
		}else{
			$::apacheUser = &UGQuestion( &ltext('install_question_apacheuser') , $apacheOwner{'User'});
			$::apacheGroup = &UGQuestion( &ltext('install_question_apachegroup') , $apacheOwner{'Group'});
		}
	}
}

if ( $::new_version_url eq "" ){
    $::new_version_url = "http://updates.confixx.de/";
}

if ( $::dns_server ){
	my($bindScript,$defaultBindScript);
	if($::pm_bind_reload eq "" ){
		$defaultBindScript = '/etc/init.d/named';
		if ($::dist =~ /debian/) {
			$defaultBindScript = '/etc/init.d/bind9';
		} 

		$bindScript = &FileQuestion( &ltext( 'install_question_dns_script' ), $defaultBindScript );
		if ( $::dns_chroot && -d $::dns_chroot ) {
			$::pm_bind_reload = "$bindScript restart";
		} else {
			$::pm_bind_reload = "$bindScript reload";
		}
		$::pm_bind_start  = "$bindScript start";
	}
}
# -------------------- end MAIN -------------------- #
#
######################################################


# -------------------- setVariable -------------------- #
sub setVariable{
	my ($variable) = @_;
	$$variable = 0 unless ( $$variable );
}
# -------------------- end setVariable -------------------- #





# -------------------- setBin -------------------- #
sub setBin{
	my ( $bin ) = @_;
	if ( $main::{"bin_$bin"} eq "" ){
		$bin{$bin} = &getBin($bin);
	}
}
# -------------------- end setBin -------------------- #





# -------------------- setPath -------------------- #
sub setPath{
    my ( $variable, $path, $file ) = @_;
    $$variable = dirname($path) . "/" . $file;
}
# -------------------- end setPath -------------------- #


sub get_version_of_SuSE() {
	my ($file) = @_;
	$file = '/etc/SuSE-release' unless (defined $file);

	open(FILE, "<$file")
		or die("Can not open file '$file' for reading: $!\n");
	while (<FILE>) {
		chomp;
		return '9.0' if /^SuSE Linux 9\.0/;
		return $1 if /^\s*VERSION\s*=\s*(\d+\.\d+)/;
	}
	close(FILE)
		or die("Can not close file '$file': $!\n");
	return undef;
}

sub GetUserInfo {
	my ($dist, $dist_ver);

	if(-e "/etc/redhat-release"){
		$dist = 'redhat';
	}
	elsif(-e "/etc/mandrake-release"){
		$dist = 'mandrake';
	}
	elsif(-e "/etc/SuSE-release"){
		$dist = 'suse';
		$dist_ver = &get_version_of_SuSE('/etc/SuSE-release');
	}
	elsif(-e "/etc/debian_version"){
		$dist = 'debian';
	}
	return ($dist, $dist_ver);
}


1;
