package MailLogParser::Record;

########## Confixx(R) 3.0 Professional ############
####### Copyright SWsoft, Inc. 2004-2005 ##########
#### http://www.sw-soft.com - info@sw-soft.com ####

# $id: Record.pm, v 1.0 2003/10/16 $

=head1 NAME

MailLogParser::Record -       ,   smtp-.

=head1 SYNOPSIS

  use MailLogParser::Record;

  $batch = MailLogParser::Batch->new;
  $record = $batch->addfrom('from'=>'from-box@from-domain.com', 
                            'size'=> 345, 
                            'fromLocal' => 1);
  $record->to('to-box@to-domain');
  $record->status('sent');

=head1 DESCRIPTION

       MailLogParser::Batch. 

=over 4

=item new( ... )

    
 :
	from
	to
	size
        fromLocal
	toLocal
	mailer
        status	
        gid
	uid


=item from( [$string] )

 

=item fromLocal( [0|1] )

   

=item to( [$string] )

 

=item toLocal( [0|1] )

   

=item status( [$string] )

    smtp-. 
success -   

=item mailer( [$string] )

 ,  . 
prog -        
   log- sendmail  postfix

=item gid( [$string] )

  .    log-  qmail.

=item uid( [$string] )

  .    log-
 qmail

=item totext

    -A

=back

=head1 SEE ALSO

MailLogParser::Batch

=cut

my  $class = "MailLogParser::Record";


use strict('vars');


sub new {
  my $class = shift;
  my $self = {};

  bless($self, $class);

  my %args = (
	from => '',
	to => '',
	size => 0,
	fromLocal => 1,
	status => '',
	toLocal => 1,
	mailer => '',
	gid => undef,
	uid => undef,
	@_
  );

  $self->{_from}=$args{from} if defined $args{from};
  $self->{_to}=$args{to} if defined $args{to};
  $self->{_size}=$args{size} if defined $args{size};
  $self->{_lfrom}=$args{fromLocal} if defined $args{fromLocal};
  $self->{_status}=$args{status} if defined $args{status};
  $self->{_lto}=$args{toLocal} if defined $args{toLocal};
  $self->{_mailer}=$args{mailer} if defined $args{mailer};
  $self->{_gid}=$args{gid} if defined $args{gid};
  $self->{_uid}=$args{uid} if defined $args{uid};

  return $self;
}

sub gid {
  my $self = shift;
  if (@_) {
	$self->{_gid}=shift;
  }
  return $self->{_gid};
}

sub uid {
  my $self = shift;
  if (@_) {
	$self->{_uid}=shift;
  }
  return $self->{_uid};
}

sub from {
  my $self = shift;
  if (@_) {
	$self->{_from}=shift;
  }
  return $self->{_from};
}

sub to {
  my $self = shift;
  if (@_) {
	$self->{_to}=shift;
  }
  return $self->{_to};
}

sub status {
  my $self = shift;
  if (@_) {
	$self->{_status}=shift;
  }
  return $self->{_status};
}


sub size {
  my $self = shift;
  if (@_) {
	$self->{_size}=shift;
  }
  return $self->{_size};
}

sub fromLocal {
  my $self = shift;
  if (@_) {
	$self->{_lfrom}=shift;
  }
  return $self->{_lfrom};
}

sub toLocal {
  my $self = shift;
  if (@_) {
	$self->{_lto}=shift;
  }
  return $self->{_lto};
}

sub mailer {
  my $self = shift;
  if (@_) {
	$self->{_mailer}=shift;
  }
  return $self->{_mailer};
}


sub totext {
  my $self = shift;
  my $prefix = shift || '';
  my $ret='';
  my($key,$val);
  foreach $key (keys %$self){
	$val = $self->{$key};
	if (defined $val){
	  $ret.="$prefix$key\t=\t$val\n";
	}else{
	  $ret.="$prefix$key\t=\tundef\n";
	}
  }
  return $ret;
}

return 1;

END {
}

