#!/usr/bin/perl

# This script convert all confixx mail accounts 
# from mailbox to maildir format using mb2md.pl utility

BEGIN {

  use FindBin qw($Bin);
  use File::Basename;

  use lib $Bin=~s%(?<=.)/$%%?$Bin:$Bin, dirname($Bin)."/subs", dirname(dirname($Bin));
}

use lib_module_common;
use DBI;
use File::Path;
&initConfig;

unless ($mail_server){
	print "Mailserver is not running on this server. exit ...\n";
	exit 1;
}

do "$installDir/admin/subs/subs_include_questions.pl";
do "$installDir/admin/subs/subs_include_writeConfig.pl";

$bin_mb2md = "$installDir/admin/contrib/mb2md.pl";

unless ( -x $bin_mb2md ){
	print "$bin_mb2md does not exists or not executable. exit ...\n";
	exit;
}

unless ( -e $bin_chown ){
	print "$bin_chown does not exists . exit ...\n";
}
unless ( -e $bin_chmod ){
        print "$bin_chmod does not exists . exit ...\n";
}
## Configure confixx_main.conf parameters
my $default_emailHomeDir = $pop_homeDir?$pop_homeDir:"/home/email";
my $default_mailSpool = $mailSpool?$mailSpool:"/var/spool/mail";
my $default_maildrop = "HOMEDIR/Maildir/";
$mail_realHome = 1;
$spool = &DirQuestion( &ltext('install_question_mailspool') , $default_mailSpool);
$mailBoxName = &Question( &ltext('install_question_maildirname') , 'Maildir');
$pop_homeDir = &PathQuestion( &ltext('install_question_pophomedir') , $default_emailHomeDir);

&UpdateMainConfig();

unless (-d $pop_homeDir){
	&mkpath($pop_homeDir,0755) or die "Can not create directory $pop_homeDir";
}

unless ($dbh = DBI->connect($db_address, $dbUser, $dbPw)) {
  print "Can not connect to confixx db :\n  $DBI::errstr\n";
  exit(1);
}
if ($Server_ID){
	$addon = " where server_id = '$Server_ID'";
}
$sql = "UPDATE allgemein SET newpwd=1 $addon";
$dbh->do($sql) or die "Can not execute query '$sql':\n $DBI::errstr\n";
$sql = "SELECT account,uid from pop3 $addon";
$sth = $dbh->prepare($sql);
$sth->execute or die "Can not execute query $sql :\n $DBI::errstr\n";
while (@row = $sth->fetchrow_array){
	print "\nprocessing $row[0] mailbox\n";
	unless ( -e "$spool/$row[0]" ){
		print "Warning: file \"$spool/$row[0]\"  not found ... skipping $row[0]\n";
		next;
	}
	my $dir = "$pop_homeDir/$row[0]";
	unless ( -e $dir && -d "$dir" ){
		print "mkdir \"$dir\" ... ";
		unless ( mkdir ($dir)){
			print "failed, skipping $row[0]\n";
			next;
		}
		print "done\n";
		print "chown $row[1],$gidpop \"$dir\" ... ";
		unless (chown $row[1],$gidpop, $dir){
			print "failed, skipping $row[0]\n";
			next;
		}
		print "done\n";
    print "chmod 0700, \"$dir\" ... ";
    unless (chmod 0700 , $dir){
      print "failed, skipping $row[0]\n";
      next;
    }
    print "done\n";

	}
	$dir = "$pop_homeDir/$row[0]/$mailBoxName";
  unless ( $mailBoxName && -e $dir && -d $dir ){
    print "mkdir \"$dir\" ... ";
    unless ( mkdir ($dir)){
      print "failed, skipping $row[0]\n";
      next;
    }
    print "done\n";
    print "chown $row[1],$gidpop \"$dir\" ... ";
    unless (chown $row[1],$gidpop, $dir){
      print "failed, skipping $row[0]\n";
      next;
    }
    print "done\n";
    print "chmod 0700, \"$dir\" ... ";
    unless (chmod 0700 , $dir){
      print "failed, skipping $row[0]\n";
      next;
    }
    print "done\n";

	}
	my $cmd = "$bin_mb2md -s $spool/$row[0] -d $dir >> /dev/null";
	print "$cmd ... ";
	if (system($cmd)){
		print "failed, skipping $row[0]\n";
		next;
	}
	print "done\n";

  $cmd = "$bin_chown -R $row[1]:$gidpop $dir >> /dev/null";
  print "$cmd ... ";
  if (system($cmd)){
    print "failed, skipping $row[0]\n";
    next;
  }
  print "done\n";	
}
$sth->finish;
$dbh->disconnect;

