<?
include_once( "auth.php" );
include_once( "../include/elements/data/class.PagedSetOfRowsData.php" );
include_once( "../include/elements/data/class.HTMLDataField.php" );
include_once( "../include/elements/data/class.LinkDataField.php" );
include_once( "../include/elements/data/class.TextDataField.php" );
include_once( "../include/elements/data/class.CompoundDataField.php" );
include_once( "../include/elements/data/class.IconDataField.php" );
include_once( "../include/module.Database.php" );
include_once( "../include/elements/html/class.MainPageElement.php" );


define( "cc_PersonalIcon", "pics/icons/reseller_personal.gif" );
define( "cc_ServicesIcon", "pics/icons/reseller_services.gif");
define( "cc_IPsIcon", "pics/icons/reseller_ips.gif");
define( "cc_DNSIcon", "pics/icons/reseller_dns.gif" );
define( "cc_PasswordIcon", "pics/icons/reseller_password.gif" );
define( "cc_DeleteIcon", "pics/icons/reseller_delete.gif" );
define( "cc_LockIcon", "pics/icons/reseller_lock.gif" );
define( "cc_ActiveIcon", "pics/icons/user_on.gif" );
define( "cc_LockedIcon", "pics/icons/user_off.gif" );

/* -------------------- ff_CreateActionLink & ff_CreateHelp -------------------- */
function ff_CreateActionLink( $ps_Query, $ps_Icon, $ps_Title ) {
	$lo_Link = new LinkDataField( "anbieter_aendern_fwd.php", $ps_Query, array(), new IconDataField($ps_Icon) );
	$lo_Link->AppendAttributes( array( "title"=>$ps_Title ) );
	return $lo_Link;
}

function ff_CreateHelp( $ps_Icon, $ps_Help ) {
	$lo_Image = new IconDataField( $ps_Icon );
	$lo_Element = new CompoundElement( $lo_Image->GetOutputPresentation(), $ps_Help );
	$lo_Element->SetSeparator( " " );
	return $lo_Element;
}
/* -------------------- end ff_CreateActionLink & ff_CreateHelp -------------------- */

/* -------------------- HTML -------------------- */
$go_Data = new PagedSetOfRowsData( "resellers_list.php", "admin_resellers_list" );
$go_Data->SetDefault();
$go_Data->AppendHeaderRow(
		new HTMLDataField( ltext("anae_cell_status") ), 
		new HTMLDataField( ltext("anaeli_cell_reseller") ), 
		new HTMLDataField( ltext("anaeli_cell_firm") ),
		new HTMLDataField( ltext("anae_cell_title1") ) );

$go_DB =& get_db_connection();

$go_Total =& $go_DB->Select( "SELECT COUNT(*) AS total FROM anbieter WHERE server_id='$ServerID'" );
$ga_Row =& $go_Total->nextrow();
$go_Data->SetTotal( $ga_Row["total"] );

$go_Query =& $go_DB->Select( "SELECT anbieter, firma, gesperrt FROM anbieter WHERE server_id='$ServerID' ORDER BY number", 
	$go_Data->GetStep(), (int)($go_Data->GetStart()/$go_Data->GetStep()) );

while( $ga_Row =& $go_Query->nextrow() ) {
	$gs_Firma = istleer($ga_Row["firma"]) ? "( ".ltext("anaeli_nofirm")." )":$ga_Row["firma"];
		
	$anbieter = $ga_Row["anbieter"];
	$urlAnbieter = urlencode($anbieter);
	
	if($ga_Row["gesperrt"]) $go_Status = ff_CreateActionLink( "anbieter=$urlAnbieter&aktion=sperren", cc_LockedIcon, $lang_text["anae_status_locked"] );
	else $go_Status = ff_CreateActionLink( "anbieter=$urlAnbieter&aktion=sperren", cc_ActiveIcon, $lang_text["anae_status_active"] );	
	
	$go_ResellerLink = new LinkDataField( "resredirect.php", "type=" . USERTYPE_RESELLER . "&reseller=$urlAnbieter",
			array(), new TextDataField( $anbieter ) );
	$go_ResellerLink->AppendAttributes( array( "target"=>"_blank" ) );
	$go_Actions = new CompoundDataField();
	
	$go_Actions->AppendToContent( ff_CreateActionLink( "anbieter=$urlAnbieter&aktion=personendaten",
				cc_PersonalIcon, ltext("anae_cell_person") ) );
				
	$go_Actions->AppendToContent( ff_CreateActionLink( "anbieter=$urlAnbieter&aktion=leistungen",
				cc_ServicesIcon, ltext("anae_cell_features") ) );

	$go_Actions->AppendToContent( ff_CreateActionLink( "anbieter=$urlAnbieter&aktion=ips",
				cc_IPsIcon, ltext("anae_cell_ip") ) );
	
	$go_Actions->AppendToContent( ff_CreateActionLink( "anbieter=$urlAnbieter&aktion=dns",
				cc_DNSIcon, ltext("anae_cell_dns") ) );
				
	$go_Actions->AppendToContent( ff_CreateActionLink( "anbieter=$urlAnbieter&aktion=passwort",
				cc_PasswordIcon, ltext("anae_cell_password") ) );
				
	$go_Actions->AppendToContent( ff_CreateActionLink( "anbieter=$urlAnbieter&aktion=loeschen",
				cc_DeleteIcon, ltext("anae_cell_del") ) );
				
	//$go_Actions->AppendToContent( ff_CreateActionLink( "anbieter=$urlAnbieter&aktion=sperren",
	//			cc_LockIcon, ltext("anae_cell_block") ) );
				
	$go_Actions->SetSeparator( "" );
	$go_Actions->SetParentAttributes( array( "nowrap"=>NULL ) );
	$go_Data->AppendRow( $go_Status, $go_ResellerLink, new TextDataField( $gs_Firma ),  $go_Actions );
}

$go_Help = new CompoundElement(
		ff_CreateHelp( cc_PersonalIcon, ltext("anae_cell_person") ),
		ff_CreateHelp( cc_ServicesIcon, ltext("anae_cell_features") ),
		ff_CreateHelp( cc_IPsIcon, ltext("anae_cell_ip") ),
		ff_CreateHelp( cc_DNSIcon, ltext("anae_cell_dns") ),
		ff_CreateHelp( cc_PasswordIcon, ltext("anae_cell_password") ),
		ff_CreateHelp( cc_DeleteIcon, ltext("anae_cell_del") )
		//ff_CreateHelp( cc_LockIcon, ltext("anae_cell_block") )
		);
		
$go_Help->SetSeparator( "<br>" );
$go_List = $go_Data->GetOutputPresentation( ltext("man_editreseller") );
$go_List->AppendHelp( $go_Help );
$go_List->SetWidths( "3%", "27%", "40", "30%" );

$go_Page = new MainPageElement( $go_List );
$go_Page->OutputHTML();
/* -------------------- end HTML -------------------- */

?>