<?php
########## Confixx( R) 3.2 Professional ##########
###### Copyright SWsoft, Inc. 2004-2006 ##########
#### http://www.swsoft.com - info@swsoft.com #####

include_once("auth.php");/*{{{*/
include_once( "../include/class.SQLInteger.php" );
include_once( "../include/class.SQLString.php" );
include_once( "defines.php");
include_once("../include/class.Traffic.php");
include_once( "../include/elements/data/class.SetOfRowsData.php" );
include_once( "../include/elements/data/class.TextDataField.php" );
include_once( "../include/elements/data/class.HTMLDataField.php" );
include_once( "../include/elements/data/class.LinkDataField.php" );
include_once( "../include/elements/data/class.IconDataField.php" );
include_once( "../include/elements/data/class.PagedTableView.php" );
include_once( "../include/data_source/class.SQLQuery.php" );
include_once( "../include/data_source/class.CompoundValue.php" );
include_once( "../include/data_source/class.ValueLocale.php" );
include_once( "../include/data_source/class.ValueFromArray.php" );
include_once( "../include/data_source/class.ValueFormated.php" );
include_once( "../include/data_source/class.ConversedDBValue.php" );
include_once( "../include/data_source/class.DataValue.php" );
include_once( "../include/elements/html/class.MainPageElement.php" );
include_once( "../include/elements/html/class.SimpleSearchElement.php" );
include_once( "../include/elements/html/class.PPButtonElement.php" );
/*}}}*/

define( "cc_ActiveIcon", "pics/icons/user_on.gif" );
define( "cc_LockedIcon", "pics/icons/user_off.gif" );
define( "cc_AscIcon", "pics/asc.gif" );
define( "cc_DescIcon", "pics/desc.gif" );

global $DEBUG;
//$DEBUG=1;

db_connect($db_host, $db_user, $db_pass);

$jahr  = date("Y");
$monat = date("m");
$tag   = date("d");

initPagingSettings( $_POST, array( 'name' => $name ) );

$res = safe_query2( "SELECT COUNT(*) FROM anbieter WHERE server_id='$ServerID'" );
list( $total_number ) = db_fetch_array( $res );

if ( isset($name)&&strlen($name) ) {
	$loPat = new SQLString( '%'.$name.'%' );
	$res = safe_query2( "SELECT COUNT(*) FROM anbieter WHERE ( anbieter LIKE ? OR firma LIKE ? ) AND server_id='$ServerID'",
											$loPat, $loPat );
	list( $total_number ) = db_fetch_array( $res );
 }

/**
 * ---------------------------------------------------------------
 * Prepare count & sum
 * ---------------------------------------------------------------
 */

$gaCountDSs = array();

$loQuery = new SQLQuery( "SELECT  COUNT(account) AS cntpop ".
												 " FROM pop3 WHERE anbieter=? AND server_id='$ServerID'",
												 array( new SQlValue('', 'C') ) );
												 
$gaCountDSs['pop'] = new CompoundDBValue( $loQuery );

$loQuery = new SQLQuery( "SELECT COUNT(prefix) AS cntemail ".
												 " FROM email WHERE anbieter=? AND server_id='$ServerID'",
												 array( new SQlValue('', 'C') ));

												 
$gaCountDSs['email'] = new CompoundDBValue( $loQuery );

$loQuery = new SQLQuery( "SELECT SUM(IF(richtigedomain=1,1,0)) AS cntdomains, ".
												 " SUM(IF(richtigedomain=0,1,0)) AS cntsubdomains ".
												 " FROM domains WHERE anbieter=? AND server_id='$ServerID'",
												 array( new SQlValue('', 'C') ) );
												 
$gaCountDSs['domains'] = new CompoundDBValue( $loQuery );


$loQuery = new SQLQuery( "SELECT COUNT(account) AS cntftp ".
												 " FROM ftp WHERE anbieter=?  AND server_id='$ServerID'",
												 array( new SQlValue('', 'C') ) );
												 
$gaCountDSs['ftp'] = new CompoundDBValue( $loQuery );

$loQuery = new SQLQuery( "SELECT COUNT(datenbank) AS cntmysql ".
												 "FROM mysql_datenbanken WHERE anbieter=?  AND server_id='$ServerID'",
												 array( new SQlValue('', 'C') ) );
												 
$gaCountDSs['mysql'] = new CompoundDBValue( $loQuery );


$loQuery = new SQLQuery( "SELECT COUNT(kunde) AS cntkunden, ".
												 " SUM(kbhomedir) + SUM(kbdb) + SUM(IF(popmaxkb=0,kbpop,0)) AS sumkb, ".
												 " MIN(maxkb) AS maxkb, ".
												 " SUM(maxkb) AS summaxkb ".
												 " FROM kunden WHERE anbieter=?  AND server_id='$ServerID'",
												 array( new SQlValue('', 'C') ) );
												 
$gaCountDSs['kunden'] = new CompoundDBValue( $loQuery );

/**
 * ---------------------------------------------------------------
 * Get traffic
 * ---------------------------------------------------------------
 */

$trf = new Traffic();
$trf->setLog($trafficLog);
$trf->setGroup('anbieter');
$trf->setFields(array('ftp','web','email','pop'));
$trf->monthlyQuery($monat,$jahr);
$traffik = $trf->getGroupTraffic('all');

if($DEBUG){
	echo "sql: ".$trf->getSql()."<br><pre>\n";
	print_r($traffik);
	echo "</pre><hr>\n";
}

$lcFields = "a.anbieter, a.firma, a.gesperrt, a.maxmysql, a.maxpop, ".
	"a.maxemail, a.maxdomains, a.maxsubdomains, a.maxftp, a.maxkb, a.popmaxkb,".
	" a.maxtransfer, a.maxkunden, a.number";


$loQuery = new SQLQuery( "SELECT $lcFields FROM anbieter a " );

$lcQuery =& $loQuery->Query();

if( isset( $name ) && strlen( $name) ){
	$lcQuery .= " WHERE ( a.anbieter LIKE '%?%' OR a.firma LIKE '%?%') AND a.server_id='$ServerID'";
	$loQuery->Parameters( array( new SQLValue( $name,'S' ), new SQLValue( $name,'S' ) ) );
}else{
 	$lcQuery .= " WHERE a.server_id='$ServerID'";
}

/**
 * ---------------------------------------------------------------
 * Sort settings
 * ---------------------------------------------------------------
 */
switch ($order) {
 case 'status':
	 $lcQuery .= " ORDER BY a.gesperrt";
	 break;
 case 'du':
	 $lcQuery = "SELECT $lcFields, ".
		 " SUM(k.kbhomedir) + SUM(k.kbdb) + SUM(IF(k.popmaxkb=0,k.kbpop,0)) as kbsum ".
		 " FROM anbieter a LEFT JOIN kunden k ON k.anbieter = a.anbieter AND a.server_id=k.server_id";
	 if( $name ) {
		 $lcQuery .= " WHERE a.anbieter LIKE '%?%' OR a.firma LIKE '%?%' AND a.server_id='$ServerID'";
	 } else {
	   $lcQuery.= " WHERE a.server_id='$ServerID'";
	 }
	 $lcQuery .= " GROUP BY a.anbieter ORDER BY kbsum";
	 break;
 case 'traffic':
	 $lcQuery = "SELECT $lcFields, ".
		 " SUM(t.ftp) + SUM(t.web)+SUM(t.email)+SUM(t.pop) as kbsum ".
		 " FROM anbieter a".
		 " LEFT JOIN transfer t ON t.anbieter = a.anbieter AND a.server_id=t.server_id ".
		 " AND t.monat=$monat AND jahr = $jahr AND geloescht=0 AND log=1";
	 
	 if( $name ) {
		 $lcQuery .= " WHERE (a.anbieter LIKE '%?%' OR a.firma LIKE '%?%') AND a.server_id='$ServerID'";
	 } else {
	   $lcQuery .= " WHERE a.server_id='$ServerID'";
	 } 
	 
	 $lcQuery .= " GROUP BY a.anbieter ORDER BY kbsum";

	 break;
 case 'ucount':
	 $lcQuery = "SELECT $lcFields, ".
		 " COUNT(k.kunde) as usercnt ".
		 " FROM anbieter a LEFT JOIN kunden k ON k.anbieter = a.anbieter AND a.server_id=k.server_id ";
	 if( $name ) {
		 $lcQuery .= " WHERE (a.anbieter LIKE '%?%' OR a.firma LIKE '%?%') AND a.server_id='$ServerID'";
	 } else {
	   $lcQuery .= " WHERE a.server_id='$ServerID'";
	 } 
	 $lcQuery .= " GROUP BY a.anbieter ORDER BY usercnt";
	 
	 break;
 default:
	 $order  = 'reseller';
	 $lcQuery .= " ORDER BY a.number";
 }

if ($direction=='desc') {
	$lcQuery .= ' DESC';
}

$loResDS = new ConversedDBValue( $loQuery, $page_size, $start_index - 1);

$loResDS->TotalNumber( $total_number );
$loResDS->doQuery();

/**
 * ---------------------------------------------------------------
 * List setting
 * ---------------------------------------------------------------
 */

$loTemplate = new CompoundValue( new CompoundValue ( new ValueFromArray( 'gesperrt' ), 
																										 new ValueFromArray( 'anbieter' )
																										 ),
																new CompoundValue ( 
																									 new ValueFromArray( 'anbieter' ),
																									 new ValueFromArray( 'maxmysql' ),
																									 new ValueFromArray( 'maxpop' ),
																									 new ValueFromArray( 'maxemail' ),
																									 new ValueFromArray( 'maxdomains' ),
																									 new ValueFromArray( 'maxsubdomains' ),
																									 new ValueFromArray( 'maxftp' )
																									 ),

																new CompoundValue( new ValueFromArray( 'anbieter' ), 
																									 new ValueFromArray( 'maxkb')
																									 ),
																new CompoundValue( new ValueFromArray( 'anbieter' ), 
																									 new ValueFromArray( 'maxkb')
																									 ),
																new CompoundValue( new ValueFromArray( 'anbieter' ), 
																									 new ValueFromArray( 'maxkb')
																									 ),

																new CompoundValue( new ValueFromArray( 'anbieter' ), 
																									 new ValueFromArray( 'maxtransfer')
																									 ),
																new CompoundValue( new ValueFromArray( 'anbieter' ), 
																									 new ValueFromArray( 'maxtransfer')
																									 ),
																new CompoundValue( new ValueFromArray( 'anbieter' ), 
																									 new ValueFromArray( 'maxkunden')
																									 ),
																new CompoundValue( new ValueFromArray( 'anbieter' ), 
																									 new ValueFromArray( 'maxkunden')
																									 )
																);

$laContent = array();

$lcIcon = ($direction=='desc')? cc_DescIcon: cc_AscIcon;

if( $order == 'status'){
	$laContent['status'] = new CompoundDataField( new HTMlDataField( ltext( 'anae_cell_status' )),
																									new IconDataField( $lcIcon )
																									);
	$laContent['status']->SetSeparator('');
 }else{
	$laContent['status'] = new HTMlDataField( ltext( 'anae_cell_status' ) );
 }


if( $order == 'reseller'){
	$laContent['reseller'] = new CompoundDataField( new HTMlDataField( ltext( 'stst_cell_reseller' )),
																									new IconDataField( $lcIcon )
																									);
	$laContent['reseller']->SetSeparator('');
 }else{
	$laContent['reseller'] = new HTMlDataField( ltext( 'stst_cell_reseller' ) );
 }

if( $order == 'du'){
	$laContent['du'] = new CompoundDataField( new HTMlDataField( ltext( 'stst_cell_used' )),
																									new IconDataField( $lcIcon )
																									);
	$laContent['du']->SetSeparator('');
 }else{
	$laContent['du'] = new HTMlDataField( ltext( 'stst_cell_used' ) );
 }

if( $order == 'traffic'){
	$laContent['traffic'] = new CompoundDataField( new HTMlDataField( ltext( 'stst_cell_used' )),
																									new IconDataField( $lcIcon )
																									);
	$laContent['traffic']->SetSeparator('');
 }else{
	$laContent['traffic'] = new HTMlDataField( ltext( 'stst_cell_used' ) );
 }

if( $order == 'ucount'){
	$laContent['ucount'] = new CompoundDataField( new HTMlDataField( ltext( 'stst_cell_used' )),
																									new IconDataField( $lcIcon )
																									);
	$laContent['ucount']->SetSeparator('');
 }else{
	$laContent['ucount'] = new HTMlDataField( ltext( 'stst_cell_used' ) );
 }

$lcNewDir = ($direction =='desc') ? 'asc' : 'desc';

$loTitle = new CompoundValue( new DataValue ( 'status', NULL,
																						 new LinkDataField( "javascript:setValue('order','status');".
																																"setValue('start_index',1);".
																																"submitForm('direction','$lcNewDir')",
																																'',
																																array(),
																																$laContent['status']
																																)
																							),
															new DataValue ( 'reseller', NULL,
																							new LinkDataField( "javascript:setValue('order','reseller');".
																																"setValue('start_index',1);".
																																"submitForm('direction','$lcNewDir')",
																																'',
																																array(),
																																$laContent['reseller']
																																)
																							),

															new CompoundValue( new ValueLocale( 'stst_cell_du'),
																								 new CompoundValue( new DataValue ( 'du', NULL,
																																										new LinkDataField( "javascript:setValue('order','du');".
																																																			 "setValue('start_index',1);".
																																																			 "submitForm('direction','$lcNewDir')",
																																																			 '',
																																																			 array(),
																																																			 $laContent['du']
																																																			 )
																																										),
																																		new ValueLocale( 'stst_cell_assigned'),
																																		new ValueLocale( 'stst_cell_max')
																																		)
																								 ),
															new CompoundValue( new ValueLocale( 'stst_cell_transfer' ),
																								 new CompoundValue( new DataValue ( 'traffic', NULL,
																																										new LinkDataField( "javascript:setValue('order','traffic');".
																																																			 "setValue('start_index',1);".
																																																			 "submitForm('direction','$lcNewDir')",
																																																			 '',
																																																			 array(),
																																																			 $laContent['traffic']
																																																			 )
																																										),
																																		new ValueLocale( 'stst_cell_max' )
																																		)
																								 ),
															new CompoundValue( new ValueLocale( 'stst_cell_users' ),
																								 new CompoundValue( new DataValue ( 'ucount', NULL,
																																										new LinkDataField( "javascript:setValue('order','ucount');".
																																																			 "setValue('start_index',1);".
																																																			 "submitForm('direction','$lcNewDir')",
																																																			 '',
																																																			 array(),
																																																			 $laContent['ucount']
																																																			 )
																																										),
																																		new ValueLocale( 'stst_cell_max' )
																																		)
																								 )
															);

/*
echo "<br><pre>\n";
print_r($loTitle);
echo "</pre><hr>\n";
*/

$laWidths = array(  '5%', '15%', '35%', '25%','20%' );

$loResDS->Template( $loTemplate );

/**
 * ---------------------------------------------------------------
 * Call-back functions
 * ---------------------------------------------------------------
 */

$errorColor = array( "bgcolor" => $fehlerfarbe );

$gcHeadText = htmlspecialchars( ltext( 'man_editreseller' ) );

$gcLocked = ltext( 'anae_status_locked' );
$gcUnlocked = ltext( 'anae_status_active' );

function &createStatusLink( $poSrc ){/*{{{*/

	global $gcLocked, $gcUnlocked,$confixx_interface_version;
	global $gcHeadText;
	
	$loTitle =& $poSrc->Value(0);
	$lcTitle = $loTitle->Value()?$gcLocked:$gcUnlocked;
	$liGesperrt = $loTitle->Value();

	$loRes =& $poSrc->Value(1);
	$lcUrlRes = urlencode( $loRes->Value() );
	$lcQuery  = "anbieter=$lcUrlRes&aktion=sperren";

	$lcIcon = $liGesperrt? cc_LockedIcon: cc_ActiveIcon;
	$text = $liGesperrt? ltext('ll_state_locked'): ltext('ll_state_ok');
	$loLink = new LinkDataField( 'anbieter_aendern_fwd.php', 
															 $lcQuery, 
															 array('action' => 'sperren',
																		 'menu_node_id' => 'sperren',
																		 'cur_page' => 'anbieter_aendern_fwd.php',
																		 'head_text' => $gcHeadText,
																		 'ret_path' => 'statistik_start.php' ), 
															 ($confixx_interface_version == 'powp')?new IconDataField( $lcIcon ):$text);

	$loLink->Attribute( 'title', $lcTitle );
	$loLink->ParentAttribute( 'align', 'center' );
		
	return $loLink;
}/*}}}*/


$gaKeys = array('mysql','pop','email','domains','subdomains','ftp');
$gcResDetails = ltext( 'stde_title1' );

function &makeResellerLink( $poSrc ){/*{{{*/
	global $gaCountDSs;
	global $errorColor, $gaKeys, $gcResDetails  ;
	global $DEBUG;

	$loRes =& $poSrc->Value('anbieter');
	$anbieter = $loRes->Value();

	$lcTitle = '';

	foreach( $gaKeys as $lcKey ){
		$loMax = $poSrc->Value( 'max'.$lcKey );
		$liMax = $loMax->Value();
		if( $liMax >= 0 ) {

			/*
			if($DEBUG){
				echo "makeResellerLink: key = $lcKey<br>\n";
			}
			*/
			if( $lcKey == 'subdomains' ){
				$loDS =& $gaCountDSs['domains'];
			}else{
				$loDS =& $gaCountDSs[$lcKey];
			}
			$loQuery =& $loDS->SQLQuery();
			$loParam =& $loQuery->Parameter(0);
			if ( $loParam->Value() != $anbieter ) {
				$loParam->Value($anbieter);
				$loDS->doQuery();
			}
			$loCounts =& $loDS->Value(0);

			$loCnt = $loCounts->Value( 'cnt'.$lcKey );
			if( $loCnt->Value() > $liMax ) {
				$lcTitle = "$loKey : ".$loCnt->Value()." > $liMax";
				$red = 1;
				break;
			}
		}
	}
	

	$linkRes = new LinkDataField( 'statistik_details.php', '',
																array( 'anbieter' => $anbieter, 
																			 'menu_node_id' => 'stat_res',
																			 'cur_page' => 'statistik_details.php', 
																			 'head_text' => $gcResDetails 
																			 ),
																$anbieter
																);
	if ($red == 1){
		$linkRes->SetParentAttributes( $errorColor );	
		$linkRes->ParentAttribute( 'title', $lcTitle );	

	}

	return $linkRes;
}/*}}}*/

function &makeDiskUsage( $lcKey, $poSrc ){/*{{{*/
	global $gaCountDSs;
	global $errorColor;
	global $fehlerfarbe;
	global $DEBUG;

	$loRes =& $poSrc->Value('anbieter');
	$anbieter = $loRes->Value();

	$loQuery =& $gaCountDSs['kunden']->SQLQuery();
	$loParam =& $loQuery->Parameter(0);
	if ( $loParam->Value() != $anbieter ) {
		$loParam->Value($anbieter);
		$gaCountDSs['kunden']->doQuery();
	}
	
	$loCounts =& $gaCountDSs['kunden']->Value(0);

	$loUsed =& $loCounts->Value('sumkb');
	$kbgenutzt = $loUsed->Value();

	$loToUse =& $loCounts->Value('maxkb');
	$kbvergeben = $loToUse->Value();
	if( $kbvergeben >= 0 ){ ## there is not any -1 
		$loToUse =& $loCounts->Value('summaxkb');
		$kbvergeben = $loToUse->Value();
	}

	$loMax =& $poSrc->Value('maxkb');
	$maxkb = $loMax->Value();

	switch($lcKey){
	case 'used':
		$lcText = sinnv_kbwert($kbgenutzt);
		break;
	case 'assign':
		$lcText = sinnv_kbwert($kbvergeben);
		break;
	case 'max':	
		$lcText = sinnv_kbwert($maxkb);
		break;
	default:
		$lcText = sinnv_kbwert($kbgenutzt).' / '.sinnv_kbwert($kbvergeben).' / '.sinnv_kbwert($maxkb);
	}
	$duRes = new HTMLDataField( $lcText );
	$duRes->ParentAttribute('align','right');
	if ((($kbvergeben > $maxkb) || ($kbgenutzt > $maxkb) || ($kbvergeben == -1)) && ($maxkb <> -1)){
		$duRes->ParentAttribute( 'bgcolor', $fehlerfarbe );			
	}	
	return $duRes;
}/*}}}*/

function &makeTrafficUsage( $lcKey, $poSrc ){/*{{{*/
	global $traffik;
	global $fehlerfarbe;

	$loRes =& $poSrc->Value('anbieter');
	$anbieter = $loRes->Value();

	$loMax =& $poSrc->Value('maxtransfer');
	$maxtransfer = $loMax->Value();

	$usedtransfer = $traffik[$anbieter];

	switch($lcKey){
	case 'used':
		$lcText = sinnv_kbwert($usedtransfer);
		$trnsferRes = new LinkDataField( "statistik_details_transfer.php?anbieter=$anbieter",
																		 '',
																		 array(),
																		 $lcText
																		 );
		
		break;
	case 'max':
		$lcText = sinnv_kbwert($maxtransfer);
		$trnsferRes = new HTMLDataField($lcText);
		break;
	default:
		$lcText = sinnv_kbwert($usedtransfer).' / '.sinnv_kbwert($maxtransfer);
		$trnsferRes = new HTMLDataField($lcText);
	}
	$trnsferRes->ParentAttribute('align','right'); 
	if (($usedtransfer > $maxtransfer) && ($maxtransfer <> -1)){
		$trnsferRes->ParentAttribute( 'bgcolor', $fehlerfarbe );		
	}

	return $trnsferRes;
}/*}}}*/

function &makeUsersCount( $lcKey, $poSrc ){/*{{{*/
	global $gaCountDSs;
	global $fehlerfarbe;

	$loRes =& $poSrc->Value('anbieter');
	$anbieter = $loRes->Value();


	$loQuery =& $gaCountDSs['kunden']->SQLQuery();
	$loParam =& $loQuery->Parameter(0);
	if ( $loParam->Value() != $anbieter ) {
		$loParam->Value($anbieter);
		$gaCountDSs['kunden']->doQuery();
	}
	
	$loCounts =& $gaCountDSs['kunden']->Value(0);

	$loUsed =& $loCounts->Value('cntkunden');
	$usedkunden = $loUsed->Value();

	$loMax =& $poSrc->Value('maxkunden');
	$maxkunden = $loMax->Value();

	switch($lcKey){
	case 'used':
		$lcText = sinnv_intwert($usedkunden);
		break;
	case 'max':
		$lcText = sinnv_intwert($maxkunden);
		break;
	default:
		$lcText = sinnv_intwert($usedkunden).' / '.sinnv_intwert($maxkunden);
	}

	$kundenRes = new HTMLDataField($lcText);
	if (($usedkunden > $maxkunden) && ($maxkunden <> -1)){
		$kundenRes->ParentAttribute( 'bgcolor', $fehlerfarbe );	
	}
	$kundenRes->ParentAttribute( 'align', 'right' );	

	return $kundenRes;
}/*}}}*/



$loConv = new CompoundValue( new ValueFormated( 'status', NULL, 'createStatusLink' ), 
														 new ValueFormated( 'anbieter', NULL, 'makeResellerLink' ),
														 new ValueFormated( 'kb_used', NULL, 'makeDiskUsage',array('used') ),
														 new ValueFormated( 'kb_assign', NULL, 'makeDiskUsage',array('assign') ),
														 new ValueFormated( 'kb_max', NULL, 'makeDiskUsage',array('max') ),
														 new ValueFormated( 'traffic_cur', NULL, 'makeTrafficUsage',array('used') ),
														 new ValueFormated( 'traffic_max', NULL, 'makeTrafficUsage',array('max') ),
														 new ValueFormated( 'user_cur', NULL, 'makeUsersCount',array('used') ),
														 new ValueFormated( 'user_max', NULL, 'makeUsersCount',array('max') )
														 );

/*
echo "<br><pre>\n";
print_r($loResDS);
echo "</pre><hr>\n";
*/

$loResDS->Conversion( $loConv );

$loResDS->doQuery();

$loPTV = new PagedTableView( $loResDS, $total_number );

$loPTV->Title( $loTitle	);
$loPTV->Widths( $laWidths );
$loPTV->setParameter( 'menu_node_id', $menu_node_id );
$loPTV->setParameter( 'cur_page', $cur_page?$cur_page:'' );
$loPTV->setParameter( 'head_text', $head_text );
if (isset($name)&&strlen($name)) {
	$loPTV->NoItemsMessage(ltext('ll_empty_search'));
}	else {
	$loPTV->NoItemsMessage(ltext('ll_empty_list'));
}

$loPTV->setParameter( 'order', "$order" );
$loPTV->setParameter( 'direction', "$direction" );

$tbl = $loPTV->GetOutputPresentation( array( 'action' => 'statistik_start.php',
																						 'method' => 'post',
																						 'name' => 'reslist' ), 
																			ltext( 'ms_resellerstats' ) 
																			);

$dsSearch = new CompoundValue( new ValueFromArray( 'name', $name ),
															 new ValueLocale( 'll_search' ),
																 new ValueLocale( 'll_show_all' )
															 );
$loSearch = new SimpleSearchElement( array(), 
																		 new InputTextElement( array( 'name' => 'name', 
																																	'size' => '16',
																																	'value' => $name,
																																	'MAXLENGTH'=> '32' )
																													 ) 
																		 );

$loSearch->appendElement( new PPButtonElement( '', 
																							 "javascript:submitForm('start_index',1)", 
																							 'bid-search' 
																							 )
													);
$loSearch->appendElement( new PPButtonElement( '', 
																							 "javascript:setValue('name','');".
																							 "submitForm('start_index',1)", 
																							 'bid-show-all'
																							 ) 
													);

$dsSearch = new CompoundValue( new ValueFromArray( 'name', $name ),
															 new ValueLocale( 'll_search' ),
															 new ValueLocale( 'll_show_all' )
															 );

$loSearch->setDataSource( $dsSearch, array( 'name' => $name ) );


$tbl->setSearchElement( $loSearch );

$tbl->updateBodyContent();

$page = new MainPageElement( $tbl );

$page->OutputHTML( array( '../js/paged_form.js' ) );


db_close();

?>
