#!/usr/bin/perl
BEGIN {
	use FindBin;
	use lib $FindBin::Bin=~s%(?<=.)/$%%?$FindBin::Bin:$FindBin::Bin;
	use lib $FindBin::Bin.'/modules';

}

use SOAP::Lite;
use Getopt::Long;

use lib_module_db;
use lib_module_events;

use Confixx::Session;
use Confixx::MySQL;

use strict;

my @config_opts = (
									 'host|h=s',
									 'login|l=s',
									 'pass|p=s',

									 'sid=s',

									 'db-srv|dbs=s',
									 'db-port=s',
									 'db-name|dbn=s',
									 'db-user|dbu=s',
									 'db-pass|dbp=s',

									 'logout!',

									 'debug|dbg:i'
									);
my %args = ();
unless ( &GetOptions( \%args, @config_opts ) ) {

	warn "Error: errors in the command line found\n";
	&print_help();
	exit 1;
}

unless( exists( $args{'logout'})){
	$args{'logout'} = 1;
}
if( exists( $args{'debug'})){
	$args{'debug'} = 1 unless $args{'debug'};
}

if($args{'debug'}){
	SOAP::Lite->import( +trace => 'all' );
}

my $confixx_domain = $args{'host'};
my $login = $args{'login'};
my $password = $args{'pass'};
my $server = $args{'db-srv'};
my $port = $args{'db-port'};
my $db_name = $args{'db-name'};
my $db_user = $args{'db-user'};
my $db_pass = $args{'db-pass'};

unless( $confixx_domain && $login && $password && 
				$server && $db_name && $db_user && $db_pass ){
	warn "Error: errors in the command line found\n";
	&print_help();
	exit 1;
}

my( $soap_session );
$soap_session = SOAP::Lite -> uri( 'http://www.soaplite.com/Confixx/Session')
	-> proxy( "http://$confixx_domain/cgi-bin/soap/server.cgi" )
	-> on_fault( \&on_error );

my ($session_id);
if( $args{'sid'} ){
	$session_id = $args{'sid'};
}else{
	$session_id = $soap_session->login( $login, $password )->result;
	print "session_id: $session_id\n";
}


my $soap_mysql = SOAP::Lite -> uri( 'http://www.soaplite.com/Confixx/MySQL')
	-> proxy( "http://$confixx_domain/cgi-bin/soap/server.cgi" )
	-> on_fault( \&on_error );


my $args = SOAP::Data->value( SOAP::Data->name('session_id')->value( $session_id ),
															SOAP::Data->name('server')->value( $server ),
															SOAP::Data->name('port')->value( $port ),
															SOAP::Data->name('db_name')->value( $db_name ),
															SOAP::Data->name('db_user')->value( $db_user ),
															SOAP::Data->name('db_paswd')->value( $db_pass )
														);
my $host = $soap_mysql->check_connect( $args )->result;

print "host: $host\n";

my $server_id = $soap_session->get_config( $session_id, 'ServerID' )->result;
print "server_id: $server_id\n";

my $myDiff = Confixx::MySQL->get_time_diff();

my $ourDiff = $soap_mysql->get_time_diff( $session_id )->result;

print "time-diff: ".($ourDiff - $myDiff)."\n";


if( $args{'logout'} ){
	$soap_session->logout( $session_id );
}

exit 0;

#
#
#============================================
#
#

sub on_error {
	my( $soap, $res ) = @_;
	if( ref($res) =~ /SOAP/ ){
		print STDERR "error-code: ",$res->faultcode,
			"\nerror-string: ",$res->faultstring,
			"\nerror-detail: ",$res->faultdetail,"\n";
		exit 2;
	}else{
		die $soap->transport->status,"\n";
	}
}

sub print_help {
	print <<"HELP";

check_connect.pl - check connect to the Confixx's database

command line options:

  --host |-h = < hostname of the Confixx's server >
  --login|-l = < login name of the Confixx's administrator >
  --pass |-p = < password of the Confixx's administrator >

  --db-srv |-dbs = < hostname of the master database >
  --db-port      = < port >
  --db-name|-dbn = < name of the master database >
  --db-user|-dbu = < name of the databases's user to connect to the master database >
  --db-pass|-dbp = < password to connect to the master database >

  --no-logout  -  don't logout after checking
  --sid = < session's ID >

  --debug|-dbg = < debug level >

HELP

}

