package Confixx::MySQL;

BEGIN{
	use FindBin;
	use File::Basename;

	use lib $FindBin::Bin=~s%(?<=.)/$%%?$FindBin::Bin:$FindBin::Bin;
	use lib dirname( $FindBin::Bin );
}
use DBI;

use lib_module_db;
use lib_module_events;

use Confixx::Session;

use strict;

my ( $masterDbh, $localDbh );

#===================================================
#
# SOAP methods

sub check_connect {
	my $this = shift;
	my $som = pop; ## last item
	my $ref = ref($som);
	my($session_id,$server,$port,$db_name,$db_user,$db_paswd,$ptrSession);

	if( $ref =~ /SOAP::SOM/  ) {
		$session_id = $som->valueof( '//check_connect/session_id' );
		unless( $session_id ){
			die SOAP::Fault->faultcode( 'Server.Parameter' )
				->faultstring( "Error: Parameter 'session_id' is not set" );		
		}
	}else{
		($session_id,$server,$port,$db_name,$db_user) = @_;
		$db_paswd = $som;
	}


	unless( $ptrSession = &loadSession( $session_id ) ){
		die SOAP::Fault->faultcode( 'Server.Session' )
				->faultstring( "Error: session '$session_id' is not found" );		
	}

	my %params;

	if( $ref =~ /SOAP::SOM/  ) {
		$params{'server'} = $som->valueof( '//check_connect/server' );

		unless( $params{'server'} ){
			die SOAP::Fault->faultcode( 'Server.Parameter' )
				->faultstring( "Error: Parameter 'server' is not set" );		
		}


		$params{'port'} = $som->valueof( '//check_connect/port' );


		$params{'dbname'} = $som->valueof( '//check_connect/db_name' );
		unless( $params{'dbname'} ){
			die SOAP::Fault->faultcode( 'Server.Parameter' )
				->faultstring( "Error: Parameter 'db_name' is not set" );		
		}

		$params{'user'} = $som->valueof( '//check_connect/db_user' );
		unless( $params{'user'} ){
			die SOAP::Fault->faultcode( 'Server.Parameter' )
				->faultstring( "Error: Parameter 'db_user' is not set" );		
		}
		
		$params{'paswd'} = $som->valueof( '//check_connect/db_paswd' );
		unless( $params{'paswd'} ){
			die SOAP::Fault->faultcode( 'Server.Parameter' )
				->faultstring( "Error: Parameter 'db_pass' is not set" );		
		}
	}else{
		%params = ( 'server' => $server,
								'port' => $port,
								'dbname' => $db_name,
								'user' => $db_user,
								'paswd' => $db_paswd
							);		
	}

	my( $host, $errmsg ) = &getMysqlHost( \%params );

	unless( $host ){
		die SOAP::Fault->faultcode('MySQL.Info')
			->faultstring( $errmsg );
	}

	my $dsn = &makeDSN( 'mysql',
											$params{'server'},
											$params{'dbname'} || $db_name,
											$params{'port'}
										);

	$ptrSession->{'dsn_master'} = $dsn;
	$ptrSession->{'master_user'} = $params{'user'};
	$ptrSession->{'master_pass'} = $params{'paswd'};

	&Confixx::Session::saveSession( $session_id );

	if( $errmsg ){
		return $host, $errmsg;

	}else{
		return $host;
	}
}

sub copy_table {
	my( $this,$session_id,$table ) = @_;
	my( $ptrSession );
	unless( $ptrSession = &loadSession( $session_id ) ){
		die SOAP::Fault->faultcode( 'Server.Session' )
				->faultstring( "Error: session '$session_id' is not found" );		
	}
	
	my $dbh = &Confixx::Session::getDbh();
	my $server_id = &Confixx::Session::getConfig('ServerID');
	
	unless( $masterDbh ){
		$masterDbh = DBI->connect( $ptrSession->{'dsn_master'},
															 $ptrSession->{'master_user'},
															 $ptrSession->{'master_pass'}
														 ) or
															 die SOAP::Fault->faultcode('DBI.Connect')
																 ->faultstring("Error: can't connect to DB: $DBI::errstr");
	}

	my $sth = $dbh->prepare( "SELECT * FROM $table WHERE server_id='$server_id'" );

	$sth->execute() or
		die SOAP::Fault->faultcode('DBI.Execute')
			->faultstring("Error: sql query error: $DBI::errstr");

	$masterDbh->do( "DELETE FROM $table WHERE server_id='$server_id'" ) or
		die SOAP::Fault->faultcode('DBI.Execute')
			->faultstring("Error: sql query error: $DBI::errstr");

	my($ptrRow,$flds,$vals,$sql);
	my $cnt = 0;
	while( $ptrRow = $sth->fetchrow_hashref()){
		$ptrRow = &prepareRow( $ptrRow, $sth );
		( $flds, $vals ) = &makeSqlInsert( $ptrRow );

		$sql = "INSERT INTO $table ( $flds ) VALUES ( $vals )";
		$masterDbh->do( $sql ) or
			die SOAP::Fault->faultcode('DBI.Execute')
				->faultstring("Error: sql query error: $DBI::errstr");
		$cnt++;
	}

	if(wantarray()){
		return ($server_id,$cnt);
	}else{
		return $server_id;
	}
}

sub rise_event {
	my ($this,$session_id,
			$obj_type,$obj_id,$obj_prop,
			$event_type,$event_prop,$data ) = @_;

	my( $ptrSession );

	unless( $ptrSession = &loadSession( $session_id ) ){
		die SOAP::Fault->faultcode( 'Server.Session' )
				->faultstring( "Error: session '$session_id' is not found" );		
	}

	my $dbh = &Confixx::Session::getDbh();
	my $server_id = &Confixx::Session::getConfig('ServerID');

	my($ret, $errstr) = &eventAdd(  'dbh' => $dbh,
																	'obj_type' => $obj_type,
																	'obj_id' => $obj_id,
																	'obj_prop' => $obj_prop,
																	'event_type' => $event_type,
																	'event_prop' => $event_prop,
																	'data' => $data,
																	'server_id' => $server_id
															);
	unless( $ret ){
		die SOAP::Fault->faultcode('Event.Rise')
			->faultstring( $errstr );
	}
	return $ret;
}

sub get_time_diff{

	my( $this, $session_id,
			$server, $port, $db_name, $db_user, $db_pass) = @_;

	unless( $masterDbh ){
		my( $ptrSession );
		if( $session_id ){
			$ptrSession = &loadSession( $session_id );
		}
		if( $ptrSession && $ptrSession->{'dsn_master'} ){
			$masterDbh = DBI->connect( $ptrSession->{'dsn_master'},
																 $ptrSession->{'master_user'},
																 $ptrSession->{'master_pass'}
															 ) or	
																 die SOAP::Fault->faultcode('DBI.Connect')
																	 ->faultstring("Error: can't connect to DB: $DBI::errstr");

		}
		unless( $masterDbh ){
			if( $server ){

				my $DSN = lib_module_db::makeDSN( 'mysql', $server, $db_name, $port );

				&connectToMaster( $DSN, $db_user, $db_pass );

			}else{
				&connectToMaster();
			}
		}
	}
	
	my $sth = $masterDbh->prepare( "SELECT unix_timestamp()" );

	my $start = time();

	$sth->execute() or
		die SOAP::Fault->faultcode('DBI.Execute')
			->faultstring("Error: can't get timestamp from DB: $DBI::errstr");

	my $stop = time();
	my( $curtime ) = $sth->fetchrow;
	$sth->finish();

	my $diff = ( $stop - $start ) * 0.5 + $start - $curtime;

	return $diff;
}

# end SOAP methods
#
#========================================================

sub connectToMaster{
	my( $DSN, $user, $pass ) = @_;

	unless( $DSN ){
		my( $server, $port, $db );
		( $server, $port, $db, $user, $pass ) = Confixx::Session::getConfig( qw/mysqlMasterServer mysqlMasterPort
																																					 dbMasterDB dbMasterUser dbMasterPw/ );
		$DSN = lib_module_db::makeDSN( 'mysql', $server, $db, $port );
	}

	if( $masterDbh ){
		$masterDbh->disconnect();
		$masterDbh = undef;
	}
	
	$masterDbh = DBI->connect( $DSN, $user, $pass ) or
		die SOAP::Fault->faultcode('DBI.Connect')
			->faultstring("Error: can't connect to DB: $DBI::errstr");

	return $masterDbh;
}

sub new {
	my $class = shift;
	my $this = {};
	bless( $this, $class);
	return $this;
}


END {
	if( $masterDbh ){
		$masterDbh->disconnect();
		$masterDbh = undef;
	}
	if( $localDbh ){
		$localDbh->disconnect();
		$localDbh = undef;
	}
}

1;


