<?
########## Confixx(R) 3.0 Professional ############
####### Copyright SWsoft, Inc. 2004-2005 ##########
#### http://www.sw-soft.com - info@sw-soft.com ####

class Cond
{
	var $var;
	var $value;
	
	var $quote = "'";
	
	var $sign = "=";
	
	/**
	 * @return Cond
	 * @param var string
	 * @param value mixed
	 * @desc Baseclass for conditions
	 */
	function Cond($var, $value)
	{
		$this->var = $var;
		$this->value = $value;
	}
	
	function checkVar($var)
	{
		return true;
	}
	
	function check($v)
	{
		if( is_array($v) )
		{
			return $this->checkVar($v[$this->var]);
		}
		if( is_object($v) && method_exists($v, 'getValue') )
		{
			return $this->checkVar( $v->getValue($this->var) );
		}
		return $this->checkVar($v);
	}
	
	function getSQL()
	{
		//return '(' . $this->var . ' ' . $this->sign . ' ' . $this->quote . $this->value . $this->quote . ')';
		return $this->var . ' ' . $this->sign . ' ' . $this->quote . db_quote($this->value) . $this->quote;
	}
	
	function getVar()
	{
		return $this->var;	
	}
}

class CondEq extends Cond 
{
	function CondEq($var, $value)
	{
		$this->Cond($var, $value);
	}
	
	function checkVar($v)
	{
		return $v == $this->value;
	}
}

class CondNe extends Cond 
{
	var $sign = '<>';
	
	function CondNe($var, $value)
	{
		$this->Cond($var, $value);
	}
	
	function checkVar($v)
	{
		return $v != $this->value;
	}
}

class CondLt extends Cond 
{
	var $sign = '<';
	
	function CondLt($var, $value)
	{
		$this->Cond($var, $value);
	}
	
	function checkVar($v)
	{
		return $v < $this->value;
	}
}

class CondGt extends Cond 
{
	var $sign = '>';
	
	function CondGt($var, $value)
	{
		$this->Cond($var, $value);
	}
	
	function checkVar($v)
	{
		return $v > $this->value;
	}
}

class CondLe extends Cond 
{
	var $sign = '<=';
	
	function CondLe($var, $value)
	{
		$this->Cond($var, $value);
	}
	
	function checkVar($v)
	{
		return $v <= $this->value;
	}
}

class CondGe extends Cond 
{
	var $sign = '>=';
	
	function CondGe($var, $value)
	{
		$this->Cond($var, $value);
	}
	
	function checkVar($v)
	{
		return $v >= $this->value;
	}
}

class CondIn extends Cond 
{
	var $sign = 'in';
	
	function CondIn($var, $value)
	{
		if(!is_array($value))
		{
			$value = array($value);
		}
		$this->Cond($var, $value);
	}
	
	function checkVar($v)
	{
		return in_array($v, $this->value);
	}
	
	function getSQL()
	{
		foreach($this->value as $v)
		{
			$values[] = $this->quote . db_quote($v) . $this->quote;
		}
		return $this->var . ' ' . $this->sign . ' ' . '(' . implode($values, ',') . ')';
	}
}

class CondLike extends Cond 
{
	var $sign = 'like';
	
	function CondLike($var, $value)
	{
		$this->Cond($var, $value);
	}
	
	function checkVar($v)
	{
		return 	strpos($this->value, $v) !== false;
	}
	
	function getSQL()
	{
		return $this->var . ' ' . $this->sign . ' ' . '\'%' . db_quote($this->value) . '%\'';
	}
}

class CondNotIn extends CondIn 
{
	var $sign = 'not in';
	
	function CondNotIn($var, $value)
	{
		$this->CondIn($var, $value);
	}
	
	function check($v)
	{
		return !CondIn::check($v);
	}
}

class CondContainer
{
	var $conds = false;
	//var $cond2;
	
	var $sign = 'and';
	
	//function CondContainer($c1, $c2)
	function CondContainer($conds  = false)
	{
		//$this->cond1 = $c1;
		//$this->cond2 = $c2;
		if($conds !== false)
		{
			if(!is_array($conds))
			{
				$conds = array($conds);	
			}
			$this->conds = $conds;
		}
	}
	
	function addCond($c)
	{
		$this->conds[] = $c;	
	}
	
	function  check($v)
	{
		return true;	
	}
	

	function checkVar(&$vars, &$obj)
	{
		/*
		if( is_subclass_of($obj, 'Cond') )
		{
			if( is_object($vars) )
			{
				if( method_exists($vars, 'getValue') )
				{
					$v = $vars->getValue($obj->getVar());
				}
				else
				{
					$v = '';
				}
			}
			
			if( is_array($vars) )
			{
				if( isset($vars[$obj->getVar()]) )
				{
					$v = $vars[$obj->getVar()];
				}
				else 
				{
					$v = '';
				}
				
			}
			
			if( !isset($v) )
			{
				$v = $vars;
			}
			//echo $v."-<br>";
			return $obj->check($v);
		}
		//*/
		return $obj->check($vars);
	}

	function getSQL()
	{
		if(is_array($this->conds))
		{
			$sqlconds = array();
			foreach ($this->conds as $c)	
			{
				$sqlconds[] = '(' . $c->getSQL() . ')';
			}
			return implode( $sqlconds, ' ' . $this->sign . ' ' );
		}
		//return '(' . $this->cond1->getSQL() . ') ' . $this->sign . ' (' . $this->cond2->getSQL() . ')';
		return '';
	}
}


class CondAND extends CondContainer 
{
	//function CondAND($c1, $c2)
	function CondAND($conds = false)
	{
		$this->CondContainer($conds);
	}
	
	function check($v)
	{
		//return $this->checkVar($v, $this->cond1) && $this->checkVar($v, $this->cond2);
		if( !is_array($this->conds) )
		{
			return false;	
		}
		$ret = true;
		foreach ($this->conds as $c)
		{
			if(!$this->checkVar($v, $c))
			{
				$ret = false;	
			}
		}
		return $ret;
	}
}

class CondOR extends CondContainer 
{
	var $sign = 'or';
	
	function CondOR($conds = false)
	{
		$this->CondContainer($conds);
	}
		
	function check($v)
	{
		if( !is_array($this->conds) )
		{
			return false;	
		}
		//return $this->checkVar($v, $this->cond1) || $this->checkVar($v, $this->cond2);
		$ret = false;
		foreach ($this->conds as $c)
		{
			if($this->checkVar($v, $c))
			{
				$ret = true;	
			}
		}
		return $ret;
	}
}


?>
