<?php
########## Confixx(R) 3.1 Professional ############
####### Copyright SWsoft, Inc. 2004-2005 ##########
##### http://www.swsoft.com - info@swsoft.com #####

/**
 * Class for work with csv data (csv -> array & array -> csv)
 *
 */
class CsvDataProcess {

  var $_mcDelimiter;
  var $_mcLineEnd;
  var $_maHeaders;
  
  function CsvDataProcess($paHeaders = array(), $pcLineEnd = "\r\n", $pcDelimiter = ',') {
    
    $this->_mcDelimiter = $pcDelimiter;
    $this->_mcLineEnd   = $pcLineEnd;
    $this->_maHeaders   = $paHeaders;
    
  }
  
  function lineEnd($pcLineEnd = null) {
    if (is_string($pcLineEnd)) {
      $this->_mcLineEnd = $pcLineEnd;
    }    
    return $this->_mcLineEnd;
  }
  
  function &Headers($paHeaders = null) {
    if (is_array($paHeaders)) {
      $this->_maHeaders = $paHeaders;
    }
    return $this->_maHeaders;
  }
  
  function escape($lcStr = '') {
    if (is_string($lcStr)) {
      return str_replace('"', '""', $lcStr);
    }
    return '';
  }  
  
  function unescape($pcStr = '') {
    if (is_string($pcStr)) {
      $lcValue = preg_replace( '~^"(.*)"$~i', '$1', trim( $pcStr ) );
      $lcValue = str_replace( '""', '"', $lcValue);      
      return $lcValue;
    }
    return '';
  }
  
  function &csvToArray(&$pcInput, $pcInputType = 'f') {
    if ($pcInputType == 'f') {
       if (file_exists($pcInput)) {
         $pcInputData = file_get_contents($pcInput);
       } else {
         return array();
       }
    } else {
      $pcInputData = $pcInput;
    }
    $laImportContacts    = array();
    $laTmpImportContacts = array();
    $laImportHeaders     = array();

    foreach (explode($this->_mcLineEnd, $pcInputData) as $value) {
  	  $value = str_replace('"', '', $value);
  		$laTmpImportContacts[] = explode(',', $value);
  	}
  	
  	if (count($this->_maHeaders)) {
  			
    	$laImportHeaders = $laTmpImportContacts[0];
    	array_shift($laTmpImportContacts);
    		
    	foreach ($laTmpImportContacts as $key => $value) {
    	  foreach ($laImportHeaders as $liHeaderKey => $lcHeader) {
    		  if ($lcTmpHeader = array_search($lcHeader, $this->_maHeaders)) {
    			  $laImportContacts[$key][$lcTmpHeader] =	trim($value[$liHeaderKey]);			
    			}					
    		}
      }
      return $laImportContacts;
  	} else {
      return $laTmpImportContacts;
  	}
  }
  
  function &arrayToCsv(&$paInputData) {
    
    $lcOutputData = '';
    
    if (is_array($paInputData)) {
      
      if (count($this->_maHeaders)) {
        
        foreach ($this->_maHeaders as $value) {
        	$lcOutputData .= "\"".$this->escape($value)."\"".$this->_mcDelimiter;
        }
        
      	$lcOutputData .= $this->_mcLineEnd;	
      	
        foreach ($paInputData as $laRow) {
          
          foreach ($this->_maHeaders as $key => $value) {
            
      	   if (array_key_exists($key, $laRow)) {
      			  $lcOutputData .= "\"".$this->escape($laRow[$key])."\"".$this->_mcDelimiter;
      		 } else {
      			  $lcOutputData .= $this->_mcDelimiter;
      		 }
      		 
      	  }
      	  
        	$lcOutputData .= $this->_mcLineEnd;
        }
      } else {
        foreach ($paInputData as $laRow) {
   			  $lcOutputData .= implode($this->_mcDelimiter, $laRow).$this->_mcLineEnd;
        }
      }
      
      return $lcOutputData;
    }
    
    return '';
  }
}

?>