<?
/*
  -------------------- Name conventions --------------------
  Function names (except methods):

  ff_DescriptionOfFunction


  Constant names:

  cc_DescriptionOfConstant


  Variable names:

  $ST_DescriptionOfVariable

  where S is a scope, T is a type.

  The following scopes should be used:
  g - global
  s - static
  l - local
  m - member of class
  p - parameter

  The following types should be used:
  s - scalar
  a - array
  r - resource
  o - object
  m - mixed

  -------------------- end Name conventions --------------------
*/





include_once ( dirname(__FILE__) . "/page_functions.php" );
include_once ( dirname(__FILE__) . "/../functions.inc.php" );
include_once ( dirname(__FILE__) . "/module.Informer.php" );
include_once ( dirname(__FILE__) . "/class.InputHiddenColumn.php" );
include_once ( dirname(__FILE__) . "/elements/data/class.SetOfRowsData.php" );
include_once ( dirname(__FILE__) . "/elements/html/class.MainPageElement.php" );





class FormPage{

    /* -------------------- Members -------------------- */
    var $ms_FormURL; // URL for form's action
    var $ma_Rows; // array of rows, "row" is an object of type FormPageAbstractRow
    var $ma_HiddenFields; // array of hidden fields, "hidden field" is an object of type InputHiddenColumn
    var $ma_FormAttributes; // attributes of form
    var $ma_FormMethod; // method for form's action
    /* -------------------- end Members -------------------- */





    /* -------------------- Constructor -------------------- */
    function FormPage( $ps_FormURL, $pa_FormAttributes=array(),$ps_FormMethod='post' )
    {
	$this->SetFormURL ( $ps_FormURL );
	$this->ma_Rows = array();
	$this->ma_HiddenFields = array();
	$this->SetFormAttributes ( $pa_FormAttributes );
	$this->SetFormMethod ( $ps_FormMethod );
    }
    /* -------------------- end Constructor -------------------- */





    /* -------------------- Get.../Set... -------------------- */
    function SetFormURL ( $ps_FormURL )
    {
	$this->ms_FormURL = $ps_FormURL;
    }

    function GetFormURL()
    {
	return $this->ms_FormURL;
    }

    function SetFormMethod ( $ps_FormMethod )
    {
    	if(stristr($ps_FormMethod,'get')){
				$this->ms_FormMethod = 'get';
    	}else{
				$this->ms_FormMethod = 'post';
    	}
    }
    function GetFormMethod()
    {
			return $this->ms_FormMethod;
    }


    
    function SetFormAttributes ( $pa_FormAttributes )
    {
	$this->ma_FormAttributes = $pa_FormAttributes;
    }

    function GetFormAttributes()
    {
	return $this->ma_FormAttributes;
    }
    /* -------------------- end Get.../Set... -------------------- */





    /* -------------------- manipulate rows -------------------- */
    function AddRow ( $po_Row )
    {
	$this->ma_Rows[] = $po_Row;
    }

    function CallOnRows ( $ps_Method )
    {
	$la_Arguments = func_get_args();
	array_shift ( $la_Arguments );
	for ( $i=0; $i<count($this->ma_Rows); $i++ )
	    call_user_func_array ( array( &$this->ma_Rows[$i], $ps_Method ), $la_Arguments );
    }
    /* -------------------- end manipulate rows -------------------- */





    /* -------------------- manipulate hidden fields -------------------- */
    function AddHiddenField() {
			foreach ( func_get_args() as $lm_Field ){
				if ( is_object($lm_Field) ){
					$this->ma_HiddenFields[] = $lm_Field;
				}elseif ( is_array($lm_Field) ){
					foreach ( $lm_Field as $lm_Item ){
						$this->AddHiddenField ( $lm_Item );
					}
				}else{
					$this->ma_HiddenFields[] = new InputHiddenColumn ( $lm_Field, "", "" );
				}
			}
		}
    /* -------------------- end manipulate hidden fields -------------------- */





    /* -------------------- methods that generate HTML -------------------- */
    function GetStartHTML()
    {
	$ls_Required = "";
	for ( $i=0; $i<count($this->ma_Rows); $i++ )
	    if ( ( $lo_Validator = $this->ma_Rows[$i]->CallOnField ( "GetValidator" ) ) && $lo_Validator->GetRequired() )
	    {
		$ls_Required = $this->ma_Rows[$i]->GetRequiredHTML() . " - " . ltext("fp_required_fields") . "<p>";
		break;
	    }
	return "$ls_Required <table class=tblbgcolor border=1 cellpadding=3 cellspacing=0
		bordercolorlight=\"#CCCCCC\" bordercolordark=\"#FFFFFF\">\n" . $this->GetFormHTML();
    }

    function GetFormHTML()
    {
	$ls_Attributes = "";
	foreach ( $this->GetFormAttributes() as $ls_Key => $ls_Value )
	    $ls_Attributes .= " $ls_Key=$ls_Value ";
	return "<form method=".$this->GetFormMethod()." action=\"" . $this->GetFormURL() . "\" $ls_Attributes>\n";
    }

    function GetEndHTML()
    {
	return "</form>\n</table>\n";
    }

    function GetRowsHTML ( $ps_ErrorFields )
    {
	$ls_Result = "";
	foreach ( $this->ma_Rows as $lo_Row )
	    $ls_Result .= $lo_Row->GetHTML ($ps_ErrorFields);
	return $ls_Result;
    }

    function GetHiddenHTML()
    {
	$ls_Result = "";
	foreach ( $this->ma_HiddenFields as $lo_Field )
	    $ls_Result .= $lo_Field->GetHTML() . "\n";
	return $ls_Result;
    }
    /* -------------------- end methods that generate HTML -------------------- */





    /* -------------------- Display & related -------------------- */
	// method that maps old classes to include/elements/*
    function Display ( $ps_ErrorFields = FALSE, $ps_HeaderAndFooter = TRUE, $pm_Title="" )
    {
		$lo_Data = $this->GetDataObject();
		$la_Attributes = $this->GetFormAttributes();
		foreach( array_keys($la_Attributes) as $ls_Key )
			if( preg_match( "/^\".*\"$/", $la_Attributes[$ls_Key] ) )
				$la_Attributes[$ls_Key] = substr( $la_Attributes[$ls_Key], 1, -1 );
		$la_Attributes = array_merge( $la_Attributes, array( "method"=>$this->GetFormMethod(),
					"action"=>$this->GetFormURL() ) );
		$lo_Form = $lo_Data->GetInputPresentation( $la_Attributes, $pm_Title );
		if( $ps_HeaderAndFooter ) {
			$lo_Page = new MainPageElement( $lo_Form );
			$lo_Page->OutputHTML();
		}
		else
			$lo_Form->OutputHTML();
    }

	// method that maps old classes to include/elements/*
	function GetDataObject() {
		$lo_Data = new SetOfRowsData();
		foreach ( $this->ma_Rows as $lo_Row )
			$lo_Row->AppendToData( $lo_Data );
		foreach( $this->ma_HiddenFields as $lo_Field )
			$lo_Data->AppendHidden( $lo_Field->GetDataField() );
		return $lo_Data;
	}
    /* -------------------- end Display & related -------------------- */





    /* -------------------- Set...Data -------------------- */
    function SetRowsData ( $pa_Data )
    {
	for ( $i=0; $i<count($this->ma_Rows); $i++ )
	    $this->ma_Rows[$i]->CallOnField ( "SetFromArray", NULL, $pa_Data, NULL );
    }

    function SetHiddenData ( $pa_Data )
    {
	for ( $i=0; $i<count($this->ma_HiddenFields); $i++ )
	    $this->ma_HiddenFields[$i]->SetFromArray ( $pa_Data, NULL );
    }

    function SetData ( $pa_Data )
    {
	$this->SetRowsData ( $pa_Data );
	$this->SetHiddenData ( $pa_Data );
    }
    /* -------------------- end Set...Data -------------------- */





    /* -------------------- ProcessSubmit & related -------------------- */
    function ProcessSubmit(){
			$this->SetData ( $_POST );
			if ( ! $this->ValidateAll($ls_Message) ){
				message( ERROR, $ls_Message );
				$this->Display( TRUE );
				exit;
			}
			$this->SaveData();
    }

    function ValidateAll ( &$ps_Message ){
			$ls_Number = 0;
			for ( $i=0; $i<count($this->ma_Rows); $i++ ){
				if ( ! $this->ma_Rows[$i]->CallOnField( "IsValid", TRUE ) ){
					if ( ++$ls_Number > 1 ){
						$ps_Message = ltext ( "fp_incorrect_fields" );
						return FALSE;
					}	else{
						$ps_Message = ltext ( "fp_incorrect_field", array($this->ma_Rows[$i]->CallOnField("GetLabel")) );
					}
				}
			}
			return $ls_Number == 0;
    }

    // overload SaveData is you'd like
    function SaveData()
    {
    }
    /* -------------------- end ProcessSubmit & related -------------------- */

}
?>
