<?
/*
  -------------------- Name conventions --------------------
  Function names (except methods):

  ff_DescriptionOfFunction


  Constant names:

  cc_DescriptionOfConstant


  Variable names:

  $ST_DescriptionOfVariable

  where S is a scope, T is a type.

  The following scopes should be used:
  g - global
  s - static
  l - local
  m - member of class
  p - parameter

  The following types should be used:
  s - scalar
  a - array
  r - resource
  o - object
  m - mixed

  -------------------- end Name conventions --------------------
*/





include_once ( dirname(__FILE__) . "/class.FormPageAbstractRow.php" );
include_once ( dirname(__FILE__) . "/class.InputTextColumn.php" );





class FormPageHeaderRow extends FormPageAbstractRow{

    /* -------------------- Members -------------------- */
    var $mo_Right; // text in right column
    /* -------------------- end Members -------------------- */





    /* -------------------- Constructor -------------------- */
	function FormPageHeaderRow ( $pm_Left, $pm_Right="", $ps_Wide=FALSE, $pa_Attributes=array() )
	{
		if ( is_object($pm_Left) )
			$this->FormPageAbstractRow ( $pm_Left, $ps_Wide, $pa_Attributes );
		else
		{
			$this->FormPageAbstractRow ( new InputTextColumn ( NULL, "", $pm_Left ), $ps_Wide, $pa_Attributes );
			$this->CallOnField ( "SetInput", NULL, FALSE );
		}
		if ( is_object($pm_Right) )
			$this->mo_Right = $pm_Right;
		else
		{
			$this->mo_Right = new InputTextColumn ( NULL, "", $pm_Right );
			$this->mo_Right->SetInput(FALSE);
		}
	}
    /* -------------------- end Constructor -------------------- */





    /* -------------------- definitions of "abstract" methods -------------------- */
	function GetHTML ( $ps_ErrorFields )
	{
		$ls_More = $this->GetTRHTML() . " " . $this->GetErrorHTML($ps_ErrorFields);
		return $this->GetWide() ?
			"<tr class=\"titel-3\" $ls_More><td colspan=2>" . $this->CallOnField( "GetHTML" ) . "</td></tr>\n" :
			"<tr class=\"titel-3\" $ls_More><td>" . $this->CallOnField( "GetHTML" ) . "</td><td>" .
			$this->mo_Right->GetHTML() . "</td></tr>\n";
	}

	// method that maps old classes to include/elements/*
	function AppendToData( &$po_Data ) {
		if( $this->GetWide() ) {
			$lo_Field = $this->CallOnField("GetDataField");
			$lo_Field->SetColSpan(2);
			$po_Data->AppendHeaderRow( $lo_Field );
		}
		else {
			$lo_Left = $this->CallOnField("GetDataField");
			$lo_Right = $this->mo_Right->GetDataField();
			$po_Data->AppendHeaderRow( $lo_Left, $lo_Right );
		}
	}
    /* -------------------- end definitions of "abstract" methods -------------------- */

}
?>
