<?
/*
  -------------------- Name conventions --------------------
  Function names (except methods):

  ff_DescriptionOfFunction


  Constant names:

  cc_DescriptionOfConstant


  Variable names:

  $ST_DescriptionOfVariable

  where S is a scope, T is a type.

  The following scopes should be used:
  g - global
  s - static
  l - local
  m - member of class
  p - parameter

  The following types should be used:
  s - scalar
  a - array
  r - resource
  o - object
  m - mixed

  -------------------- end Name conventions --------------------
*/





include_once ( dirname(__FILE__) . "/class.FormPageAbstractRow.php" );





class FormPageRow extends FormPageAbstractRow{

    /* -------------------- Members -------------------- */
    var $mm_LabelAlign; // align of label
     
    /* -------------------- end Members -------------------- */





    /* -------------------- Constructor -------------------- */
    function FormPageRow ( $po_Field, $ps_Wide=FALSE, $pa_Attributes=array(), $pm_LabelAlign=NULL )
    {
    	if($pm_LabelAlign){
    		$this->mm_LabelAlign=$pm_LabelAlign;
    	}
	$this->FormPageAbstractRow ( $po_Field, $ps_Wide, $pa_Attributes );
    }
    /* -------------------- end Constructor -------------------- */





    /* -------------------- definitions of "abstract" methods -------------------- */
    function GetHTML ( $ps_ErrorFields )
    {
	$ls_More = $this->GetTRHTML() . " " . $this->GetErrorHTML($ps_ErrorFields);
			if($this->mm_LabelAlign){
				if(is_array($this->mm_LabelAlign)){
					$ls_LabelAlign='';
					foreach($this->mm_LabelAlign as $ls_Key => $ls_Value){
						if($ls_Key=='align'){
							$ls_LabelAlign.=" align=$ls_Value";
						}elseif($ls_Key=='valign'){
							$ls_LabelAlign.=" valign=$ls_Value";
						}
					}
				}else{	
					$ls_LabelAlign = "align=$this->ms_LabelAlign";
				}	
			}else{
				$ls_LabelAlign = "align=rigth";
			}
			
	return $this->GetWide() ?
		"<tr $ls_More><td colspan=2>" . $this->CallOnField("GetHTML") . "</td></tr>\n" :
		"<tr $ls_More><td $ls_LabelAlign>" . $this->CallOnField("GetLabel") . $this->GetRequiredHTML() . "</td><td>" .
		$this->CallOnField("GetHTML") . "</td></tr>\n";
    }

	// method that maps old classes to include/elements/*
	function AppendToData( &$po_Data ) {
		if( $this->GetWide() ) {
			$lo_Field = $this->CallOnField("GetDataField");
			$lo_Field->SetColSpan(2);
			$po_Data->AppendRow( $lo_Field );
		}
		else {
			$lo_Label = $this->CallOnField("GetLabelDataField");
			$lo_Field = $this->CallOnField("GetDataField");
			$po_Data->AppendRow( $lo_Label, $lo_Field );
		}
	}
    /* -------------------- end definitions of "abstract" methods -------------------- */

}
?>
