<?
/*
  -------------------- Name conventions --------------------
  Function names (except methods):

  ff_DescriptionOfFunction


  Constant names:

  cc_DescriptionOfConstant


  Variable names:

  $ST_DescriptionOfVariable

  where S is a scope, T is a type.

  The following scopes should be used:
  g - global
  s - static
  l - local
  m - member of class
  p - parameter

  The following types should be used:
  s - scalar
  a - array
  r - resource
  o - object
  m - mixed

  -------------------- end Name conventions --------------------
*/





include_once (  dirname(__FILE__) . DIRECTORY_SEPARATOR . "class.ListColumn.php" );
include_once (  dirname(__FILE__) . "/elements/data/class.YesNoDataField.php" );
include_once (  dirname(__FILE__) . "/elements/data/class.HTMLDataField.php" );
include_once (  dirname(__FILE__) . "/elements/data/class.CompoundDataField.php" );





class InputCheckboxColumn extends ListColumn
{
    /* -------------------- Members -------------------- */
    var $ms_Checked; // value that is used for checked checkbox
    var $ml_ReadOnly; // value that is used for readonly checkbox
    var $ml_Disabled; // value that is used for disabled checkbox
    var $ms_OnClick; // value that is used for OnClick handler
    /* -------------------- end Members -------------------- */





    /* -------------------- Constructor -------------------- */
    function InputCheckboxColumn (  $ps_Checked, $ps_Name, $ps_Label, $ps_Value, $pa_Attributes=array(), $ps_Width=NULL,
	    $ps_Align=NULL, $ps_ID=NULL )  {
			global $DEBUG;
			$this->ms_Checked = $ps_Checked;
			
			$this->ListColumn ( $ps_Name, $ps_Label, $ps_Value, $pa_Attributes, $ps_Width, $ps_Align, $ps_ID );
			
			if ($DEBUG){
#				echo "InputCheckboxColumn:<br><pre>\n";
#				print_r($this);
#				echo "</pre><hr>\n"; 
			}

    }
    /* -------------------- end Constructor -------------------- */





    /* -------------------- definitions of "abstract" methods -------------------- */
	// method that maps old classes to include/elements/*
	function GetDataField() {

		global $DEBUG;

		if ( ! $this->GetInput() )
			return new HTMLDataField( ltext( $this->GetValue() == $this->ms_Checked ? "g_yes" : "g_no" ) );
		
		$lo_Result = new YesNoDataField( array( $this->ms_Checked=>"" ), array( ""=>"" ), $this->GetValue(),
				$this->GetPureName() );
		$lo_Result->AppendAttributes( $this->GetAttributes() );
		if( $this->ml_ReadOnly )
			$lo_Result->AppendAttributes( array( "readonly" => NULL ) );
		if( $this->ml_Disabled )
			$lo_Result->AppendAttributes( array( "disabled" => NULL ) );
		if( $this->ms_OnClick )
			$lo_Result->AppendAttributes( array( "onclick" => NULL ) );
		if( $this->GetWithLabel() ) {
			$lo_Result = new CompoundDataField( $lo_Result, new HTMLDataField( $this->GetLabel() ) );
			$lo_Result->SetSeparator( " " );
		}

		if($DEBUG){
#			echo "InputCheckboxColumn::GetDataField<br><pre>\n";
#			print_r($lo_Result);
#			echo "</pre><hr>\n";
		}

		return $lo_Result;
	}

  function SetFromArray ( $pa_Data, $ps_ID ) {
  	$ls_Key = $this->ms_Name.'_readlony';
  	if(array_key_exists ( $ls_Key, $pa_Data )){
			$this->SetReadOnly($pa_Data[$ls_Key]);
		}
  	$ls_Key = $this->ms_Name.'_disabled';
  	if(array_key_exists ( $ls_Key, $pa_Data )){
			$this->SetDisabled($pa_Data[$ls_Key]);
		}

  	ListColumn::SetFromArray ( $pa_Data, $ps_ID );	
  }
    
  function GetHTML(){

		global $DEBUG;
		if($DEBUG){
#			echo "InputCheckboxColumn::GetHTML<br>\n";
		}

  	if ( ! $this->GetInput() )
	    return ltext ( $this->GetValue() == $this->ms_Checked ? "g_yes" : "g_no" );
	
	  $ls_More = $this->GetAttributesHTML();
		$ls_Checked = $this->GetValue() == $this->ms_Checked ? "checked" : "";
		$ls_ReadOnly = $this->ml_ReadOnly ? "readonly":"";
		$ls_Disabled = $this->ml_Disabled ? "disabled":"";
		$ls_OnClick = $this->ms_OnClick ? "onclick=\"".htmlspecialchars($this->ms_OnClick)."\"" :"";
		$ls_Label = $this->GetWithLabel() ? " " . htmlspecialchars($this->GetLabel()) : "";
	
		return "<input type=checkbox name=\"" . htmlspecialchars($this->GetName()) . "\" $ls_More value=\"" .
			htmlspecialchars( $this->GetValue() ) . "\" $ls_Checked $ls_ReadOnly $ls_Disabled $ls_OnClick>$ls_Label";

  }
    /* -------------------- end definitions of "abstract" methods -------------------- */





    /* -------------------- ...Checked -------------------- */
    function IsChecked()
    {
	return $this->GetValue() == $this->GetChecked();
    }

    function GetChecked()
    {
	return $this->ms_Checked;
    }

    function SetChecked ( $ps_Checked )
    {
	$this->ms_Checked = $ps_Checked;
    }
    
	function GetReadOnly(){
  	return $this->ml_ReadOnly;  		
  }
 /**
 * @return unknown
 * @param boolean $pl_ReadOnly
 * @desc set up readonly key
 */
  function SetReadOnly($pl_ReadOnly){
  	$this->ml_ReadOnly=$pl_ReadOnly;
  	return $this->ml_ReadOnly;  		
  }
	function GetDisabled(){
  	return $this->ml_Disabled;  		
  }
	/**
	* @return unknown
	* @param boolean $pl_Disabled
	* @desc set up disabled key
	*/
	function SetDisabled($pl_Disabled){
		$this->ml_Disabled=$pl_Disabled;
  	return $this->ml_Disabled;
  }

  /* -------------------- end IsChecked -------------------- */

}
?>
