<?
########## Confixx(R) 3.1 Professional ############
####### Copyright SWsoft, Inc. 2004-2005 ##########
#### http://www.sw-soft.com - info@sw-soft.com ####

class InputDecode
{
	function utf8ToUnicodeEntities ($source) 
	{
		// array used to figure what number to decrement from character order value
		// according to number of characters used to map unicode to ascii by utf-8
		$decrement[4] = 240;
		$decrement[3] = 224;
		$decrement[2] = 192;
		$decrement[1] = 0;
	
		// the number of bits to shift each charNum by
	
		$shift[1][0] = 0;
		
		$shift[2][0] = 6;
		$shift[2][1] = 0;
		
		$shift[3][0] = 12;
		$shift[3][1] = 6;
		$shift[3][2] = 0;
	
		$shift[4][0] = 18;
		$shift[4][1] = 12;
		$shift[4][2] = 6;
		$shift[4][3] = 0;
	
		$pos = 0;
	
		$len = strlen ($source);
	
		$encodedString = '';
	
		while ($pos < $len) 
		{
			//$asciiPos = ord (substr ($source, $pos, 1));
			$asciiPos = ord($source{$pos});
			if (($asciiPos >= 240) && ($asciiPos <= 255)) 
			{ // 4 chars representing one unicode character
				$thisLetter = substr ($source, $pos, 4);
				$pos += 4;
			}
			else if (($asciiPos >= 224) && ($asciiPos <= 239)) 
			{ // 3 chars representing one unicode character
				$thisLetter = substr ($source, $pos, 3);
				$pos += 3;
	
			}
			else if (($asciiPos >= 192) && ($asciiPos <= 223)) 
			{ // 2 chars representing one unicode character
				$thisLetter = substr ($source, $pos, 2);
				$pos += 2;
			}
			else
			{ // 1 char (lower ascii)
				$thisLetter = $source{$pos};//substr ($source, $pos, 1);
				$pos += 1;
			}
			// process the string representing the letter to a unicode entity
	
			$thisLen = strlen ($thisLetter);
	

			if ($thisLen > 1)
			{
				$thisPos = 0;
				$decimalCode = 0;
				while ($thisPos < $thisLen) 
				{
					$thisCharOrd = ord ($thisLetter{$thisPos});//(substr ($thisLetter, $thisPos, 1));
					if ($thisPos == 0) 
					{
						$charNum = intval ($thisCharOrd - $decrement[$thisLen]);
						$decimalCode += ($charNum << $shift[$thisLen][$thisPos]);
					}
					else 
					{
						$charNum = intval ($thisCharOrd - 128);
						$decimalCode += ($charNum << $shift[$thisLen][$thisPos]);
					}
					$thisPos++;
				}
				$encodedLetter = "&#". $decimalCode . ';';
			}
			else
			{
				$encodedLetter = $thisLetter; 
			}
			/* if ($thisLen == 1)
				$encodedLetter = "&#". str_pad($decimalCode, 3, "0", STR_PAD_LEFT) . ';';

			else
				$encodedLetter = "&#". str_pad($decimalCode, 5, "0", STR_PAD_LEFT) . ';';
			*/ 
			$encodedString .= $encodedLetter;
	
		}
		return $encodedString;
	} 
	
	function code2utf($num)
	{
		if($num < 128)
		{
			return chr($num);
		}
		if($num < 2048)
		{
			return chr(($num >> 6) + 192) . chr(($num & 63) + 128);
		}
		if($num<65536)
		{
			return chr(($num >> 12) + 224) . chr((($num >> 6) & 63) + 128) . chr(($num & 63) + 128);
		}
		if($num < 2097152)
		{
			return chr(($num >> 18) + 240) . chr((($num >> 12) & 63) + 128) . chr((($num >> 6) & 63) + 128) . chr(($num & 63) + 128);
		}
		return '';
	}
	

	function &ent2utf($string){
		global $DEBUG;

		preg_match_all ('/&#([\d]+);/U', $string, $out); 

		/*
		if($DEBUG){
			echo "InputDecode::ent2utf : $string <br><pre>\n";
			print_r( $out );
			echo "</pre><ht>\n";
		}
		*/

		$arr = array();
		foreach( $out[1] as $num => $code ){
			$arr[$out[0][$num]]	= InputDecode::code2utf( $code );
		}

		$lcRet = strtr( $string, $arr);
		/*
		if( $DEBUG ){
			echo "InputDecode::ent2utf : $lcRet<br><pre>\n";
			print_r( $arr );
			echo "</pre><ht>\n";
		}
		*/
		return $lcRet;
	}
	
	function isASCIIString($string)
	{
		$len = strlen($string);
		for ($i = 0; $i < $len; $i++)
		{
			if(ord($string{$i}) > 127)
			{
				
				return false;
			}
		}
		return true;
	}
	
	
	function &decode( $string ) {
		global $iconv_utf8;
		global $DEBUG;

		/*
		if( $DEBUG ){
			echo "InputDecode::decode : $string<br>\n";
		}
		*/
		if( InputDecode::isASCIIString( $string ) || 
				preg_match( '/&#\d{4}/', $string ) )	{

			/*
			 if( $DEBUG ){
			 echo "InputDecode::decode : call ent2utf<br>\n";
			 }
			*/
			return InputDecode::ent2utf( $string );

		}	else {
			if( ! ( isset( $iconv_utf8 ) && $iconv_utf8 ) ){
				$iconv_utf8 = 'UTF-8';
			}
			
			$fromCharset = strtoupper( $GLOBALS['lang_html_charset'] ); 
			if ( $fromCharset == $iconv_utf8 ) {
				return $string;
			} else {
				$lcRet = iconv( $fromCharset, $iconv_utf8, $string);	
				return $lcRet;
			}
		}
	}
}	


?>
