<?
/*
  -------------------- Name conventions --------------------
  Function names (except methods):

  ff_DescriptionOfFunction


  Constant names:

  cc_DescriptionOfConstant


  Variable names:

  $ST_DescriptionOfVariable

  where S is a scope, T is a type.

  The following scopes should be used:
  g - global
  s - static
  l - local
  m - member of class
  p - parameter

  The following types should be used:
  s - scalar
  a - array
  r - resource
  o - object
  m - mixed

  -------------------- end Name conventions --------------------
*/





include_once ( dirname(__FILE__) . "/class.Validatable.php" );
include_once ( dirname(__FILE__) . "/elements/data/class.HTMLDataField.php" );





class ListColumn extends Validatable
{

    /* -------------------- Members -------------------- */
    var $ms_Label; // label that should be used for this column
    var $ms_Width; // width of column
    var $ms_Align; // align of column
    var $ms_BgColor; // background color of column

    var $ms_Value; // value of column
    var $ms_Name; // name of column
    var $ms_ID; // identifier of row
    var $ma_Attributes; // attributes

    var $ms_Input; // if TRUE, then input is allowed in this column

    var $ms_Sortable; // if TRUE, then user can sort by this column

	var $ms_WithLabel; // output with label
    /* -------------------- end Members -------------------- */





    /* -------------------- Constructor -------------------- */
    function ListColumn ( $ps_Name, $ps_Label, $ps_Value, $pa_Attributes=array(), $ps_Width=NULL, $ps_Align=NULL,
		$ps_ID=NULL )
    {
	$this->Validatable();

	$this->ms_Label = $ps_Label;
	$this->ms_Width = $ps_Width;
	$this->ms_Align = $ps_Align;
	$this->ms_BgColor = NULL;

	$this->ms_Name = $ps_Name;
	$this->SetValue ( $ps_Value );
	$this->ms_ID = $ps_ID;
	$this->ma_Attributes = $pa_Attributes;

	$this->ms_Input = TRUE;
	$this->SetWithLabel (FALSE);
    }
    /* -------------------- end Constructor -------------------- */





    /* -------------------- Get... -------------------- */
	function GetWithLabel()
	{
		return $this->ms_WithLabel;
	}
	
    function GetLabel()
    {
	return $this->ms_Label;
    }

    function GetWidth()
    {
	return is_null( $this->ms_Width ) ? "" : "width=\"".$this->ms_Width."\"";
    }

	function GetPureWidth() {
		return $this->ms_Width;
	}

    function GetAlign()
    {
	return is_null( $this->ms_Align ) ? "" : "align=\"".$this->ms_Align."\"";
    }

	function GetBgColor()
  {
		return is_null( $this->ms_BgColor ) ? "" : "bgcolor=\"".$this->ms_BgColor."\"";
  }

    
    function GetName()
    {
	$ls_ID = $this->GetID();
	return strlen($ls_ID) ? $this->ms_Name."[".$ls_ID."]" : $this->ms_Name;
    }

    function GetPureName()
    {
	return $this->ms_Name;
    }

    function GetValue()
    {
	return $this->ms_Value;
    }

    function GetID()
    {
	return $this->ms_ID;
    }

    function GetAttributesHTML()
    {
			$ls_Result = "";
			if(is_array($this->ma_Attributes)){
				foreach ( $this->ma_Attributes as $ls_Key => $ls_Value ){
	    		$ls_Result .= is_null($ls_Value) ? " $ls_Key " : " $ls_Key=\"" . $ls_Value . "\"";
				}
			}
			return $ls_Result;
    }

	function GetAttributes() {
		return $this->ma_Attributes;
	}

    function GetURLQuery()
    {
	return urlencode( $this->GetName() ) . "=" . urlencode( $this->GetValue() );
    }

    function GetInput()
    {
	return $this->ms_Input;
    }

    function GetSortable()
    {
	return $this->ms_Sortable;
    }
    /* -------------------- end Get... -------------------- */





    /* -------------------- Set... -------------------- */
	function SetWithLabel ( $ps_WithLabel )
	{
		$this->ms_WithLabel = $ps_WithLabel;
	}
	
    function SetLabel ( $ps_Label )
    {
	$this->ms_Label = $ps_Label;
    }

	/**
	* @return void
	* @param string $ps_BgColor - background color 
	* @desc set up background color
	*/
	function SetBgColor ( $ps_BgColor )
  {
		$this->ms_BgColor = $ps_BgColor;
  }

    function SetValue( $ps_Value )
    {
	$this->ms_Value = $ps_Value;
    }

    function SetID ( $ps_ID )
    {
	$this->ms_ID = $ps_ID;
    }

    function SetFromArray ( $pa_Data, $ps_ID )
    {
    	
	if ( ! is_null($this->ms_Name) )
		if(array_key_exists ( $this->ms_Name, $pa_Data )){
			if(is_array($pa_Data[$this->ms_Name])){
				$la_Src =& $pa_Data[$this->ms_Name];
				if(array_key_exists ( 'value', $la_Src )){
					$this->SetValue($la_Src['value']);
				}else{
					$this->SetValue(NULL);
				}
				if(array_key_exists ( 'bgcolor', $la_Src )){
					$this->SetBgColor($la_Src['bgcolor']);
				}else{
					$this->SetBgColor(NULL);
				}
				if(array_key_exists ( 'label', $la_Src )){
					$this->SetLabel($la_Src['label']);
				}
			}else{
				$this->SetValue ($pa_Data[$this->ms_Name]);
			}
		}else{	
	    $this->SetValue ( NULL );
		}  
	$this->SetID ( $ps_ID );
			
    }

    function SetFromPostGet ()
    {
	if ( ! is_null($this->ms_Name) )
	{
	    if ( $_SERVER["REQUEST_METHOD"]=="POST" && array_key_exists( $this->ms_Name, $_POST ) &&
		    strlen( $_POST[$this->ms_Name] ) )
		$this->SetValue ( $_POST[$this->ms_Name] );
	    else
		$this->SetValue ( array_key_exists( $this->ms_Name, $_GET ) ? $_GET[$this->ms_Name] : NULL );
	}
    }

    function SetInput ( $ps_Input )
    {
	$this->ms_Input = $ps_Input;
    }

    function SetSortable ( $ps_Sortable )
    {
	$this->ms_Sortable = $ps_Sortable;
    }
    /* -------------------- end Set... -------------------- */





    /* -------------------- methods to manipulate value -------------------- */
    function AppendToValue ( $ps_Text )
    {
	$this->SetValue ( $this->GetValue() . $ps_Text );
    }
    /* -------------------- end methods to manipulate value -------------------- */





    /* -------------------- Is... -------------------- */
    function IsSetInQuery ()
    {
	if ( is_null($this->ms_Name) )
	    return FALSE;
	if ( $_SERVER["REQUEST_METHOD"]=="POST" && array_key_exists( $this->ms_Name, $_POST ) &&
		strlen( $_POST[$this->ms_Name] ) )
	    return TRUE;
	return array_key_exists ( $this->ms_Name, $_GET ) && strlen( $_GET[$this->ms_Name] );
    }
    /* -------------------- end Is... -------------------- */





    /* -------------------- "abstract" methods -------------------- */
    function GetHTML()
    {
	echo ( "method GetHTML should return HTML of column" );
    }

	// method that maps old classes to include/elements/*
	function GetDataField() {
		echo( "method GetDataField should return object!" );
	}
    /* -------------------- end "abstract" methods -------------------- */





	/* -------------------- GetLabelDataField -------------------- */
	// method that maps old classes to include/elements/*
	function GetLabelDataField() {
		return new HTMLDataField( $this->GetLabel(), $this->GetRequired() );
	}
	/* -------------------- end GetLabelDataField -------------------- */

}
?>
