<?
class PathBar {

	var $mcUser;
	var $maPathBar;
	var $maTop;
	var $maList;

	function PathBar( $pcUser = NULL ){
		global $PHP_AUTH_USER;
		if( is_string( $pcUser ) ) {
			$this->mcUser = $pcUser;

		}else{
			$this->mcUser = $PHP_AUTH_USER;
		}
		$this->maList = array( 'cur_page',
										'head_text',
										'menu_node_id',
										'head_id',
										'help_head_key',
										'help_text_key',
										'path_text' );

		$this->loadPathBar();
	}

	function User( $pcUser = NULL ){
		if( is_string( $pcUser ) ) {
			$this->mcUser;
			$this->loadPathBar();
		}
		return $this->mcUser;
	}

	function &loadPathBar( $pcUser = NULL ) {
		global $_SESSION, $ServerID;

		$this->User( $pcUser );

		if(!is_string($this->mcUser)){
			$this->maPathInfo = NULL;
			return $this->maPathInfo;
		}

		if( !is_array( $_SESSION['_users']) ){
			$_SESSION['_users'] = array();
		}	
		if( !is_array( $_SESSION['_users'][$ServerID]) ){
			$_SESSION['_users'][$ServerID] = array();
		}	
		if( !is_array( $_SESSION['_users'][$ServerID][$this->mcUser]) ){
			$_SESSION['_users'][$ServerID][$this->mcUser] = array();
		}	
		$lcHdrInfo = $this->mcUser.'_head_info';
		if( !is_array( $_SESSION['_users'][$ServerID][$this->mcUser][$lcHdrInfo]) ){
			$_SESSION['_users'][$ServerID][$this->mcUser][$lcHdrInfo] = array();
		}	

		if( !is_array( $_SESSION['_users'][$ServerID][$this->mcUser][$lcHdrInfo]['path_bar']) ){
			$_SESSION['_users'][$ServerID][$this->mcUser][$lcHdrInfo]['path_bar'] = array();
		}

		$this->maPathInfo =& $_SESSION['_users'][$ServerID][$this->mcUser][$lcHdrInfo]['path_bar'];


		return $this->maPathInfo;
	}

	function &cleanPathBar(){
		global $_SESSION, $ServerID;
		global $DEBUG;

		$lcHdrInfo = $this->mcUser.'_head_info';
		$_SESSION['_users'][$ServerID][$this->mcUser][$lcHdrInfo]['path_bar'] = array();
		$this->maPathInfo =& $_SESSION['_users'][$ServerID][$this->mcUser][$lcHdrInfo]['path_bar'];

		/*
		if($DEBUG){
			echo "PathBar::cleanPathBar : _SESSION<br><pre>\n";
			print_r($_SESSION);
			echo "</pre><hr>\n";
		}
		*/

		$this->topPathBar();

		return $this->maPathInfo;
	}

	function topPathBar(){
		global $_SESSION, $ServerID;
		global $path_bar;
		global $DEBUG;

		if( is_array( $this->maPathInfo )  && ( $liCount = count( $this->maPathInfo ) ) ){

			$laTop =& $this->maPathInfo[$liCount - 1];
		} else {
			$laTop = array();
		}

		$path_bar = $laTop;

		$lcHdrInfo = $this->mcUser.'_head_info';

		$i=0;
		$cnt = count($laTop);
		foreach( $this->maList as $lcKey ){
			if( $i >= $cnt ){
				break;
			}
			$_SESSION['_users'][$ServerID][$this->mcUser][$lcHdrInfo][$lcKey] = $laTop[$i];
			$GLOBALS[$lcKey] = $laTop[$i];
			$i++;
		}


		/*		
		if( $DEBUG ){
			echo "PathBar::topPathBar : _SESSION<br><pre>\n";
			print_r($_SESSION);
			echo "</pre><hr>\n";
		}
		*/

		return $laTop;

	}

	function &getTopPathBar(){
		if( is_array( $this->maPathInfo )  && ( $liCount = count( $this->maPathInfo ) ) ){

			$laTop =& $this->maPathInfo[$liCount - 1];
		} else {
			$laTop = array();
		}

		$laRet = array();
		$i=0;
		$cnt = count( $laTop );
		foreach( $this->maList as $lcKey ){
			if( $i >= $cnt ){
				break;
			}
			$laRet[$lcKey] = $laTop[$i];
			$i++;
		}
		return $laRet;
	}

	function &pushPathBar( &$paItem ){
		global $DEBUG;
		global $ServerID;

		/*
		if( $DEBUG ){
			echo "PathBar::pushPathBar : <br><pre>\n";
			print_r( $paItem );
			echo "</pre><hr>\n";
		}
		*/

		if( is_array( $paItem ) && count( $paItem ) ) {
			
			if( $paItem['main_menu_page'] ) { /* head */

				$go =1;
				if( is_array( $this->maPathInfo ) ) {
					if( count( $this->maPathInfo ) == 1 && 
							$this->maPathInfo[0][0] == $paItem['main_menu_page']){ /* head is already created */
						$go = 0;
					}
				}
				if( $go ){
					$this->cleanPathBar();
					$this->maPathInfo[] = array( $paItem['main_menu_page'], 
																			 $paItem['head_text'], 
																			 $paItem['menu_node_id'], 
																			 $paItem['head_id'], 
																			 $paItem['help_head_key'], 
																			 $paItem['help_text_key'],
																			 $paItem['path_text']
																			 );
				}

				/*								
				if( $DEBUG ){
					echo "PathBar::pushPathBar : main_menu_page <br><pre>\n";
					print_r( $this->maPathInfo );
					echo "</pre><hr><pre>\n";
					print_r( $paItem );
					echo "</pre><hr>\n";
				}
				*/

			} elseif( is_array( $this->maPathInfo ) ) {
			
				$lcCheckKey = '';
				$liCheckInd = -1;
				
				foreach( array('cur_page','head_id','menu_node_id') as $lcKey){
					if( $paItem[$lcKey] ){
						switch($lcKey){
						case 'cur_page':
							$liCheckInd = 0;
							break;
						case 'head_id':
							$liCheckInd = 3;
							break;
						case 'menu_node_id':
							$liCheckInd = 2;
							break;
						}
						$lcCheckKey = $lcKey;
						break;
					}
				}

				$llAdd = 1;
				
				if( $lcCheckKey ) {
					$liCount = count( $this->maPathInfo );
					for( $i = 0; $i < $liCount; $i++ ){
						if( $this->maPathInfo[$i][$liCheckInd] == $paItem[$lcCheckKey] ) {
							$llAdd = 0;
							if( $i+1 < $liCount ) {
								$lcHdrInfo = $this->mcUser.'_head_info';
								array_splice( $_SESSION['_users'][$ServerID][$this->mcUser][$lcHdrInfo]['path_bar'], $i+1 );
							}
							break;
						}
					}
				}

				if( $llAdd && $paItem['head_text'] && $paItem['cur_page'] ) {
					array_push( $this->maPathInfo,	
											array( $paItem['cur_page'], 
														 $paItem['head_text'], 
														 $paItem['menu_node_id'], 
														 $paItem['head_id'], 
														 $paItem['help_head_key'], 
														 $paItem['help_text_key'],
														 $paItem['path_text']
														 )
											);
					
				} else {
					
					$top = count($this->maPathInfo)-1;
					if( $top >= 0 ){
						$i=0;
						foreach( $this->maList as $lcKey ){
							if( array_key_exists( $lcKey, $paItem ) ) {
								$this->maPathInfo[$top][$i] = $paItem[$lcKey];
							}
							$i++;
						}
					}
				}
			}
		}

		/*
		if($DEBUG){
			echo "PathBar::pushPathBar : return  _SESSION<pre>\n";
			print_r($_SESSION);
			echo "</pre><hr>\n";
		}
		*/

		return $this->topPathBar();
	}

	function &keepFirst(){
		global $ServerID;
		if(is_array( $_SESSION['_users'][$ServerID][$this->mcUser][$lcHdrInfo]['path_bar'] )){
			array_splice( $_SESSION['_users'][$ServerID][$this->mcUser][$lcHdrInfo]['path_bar'], 1);
		}
		return $this->topPathBar();
	}

	function cloneTop($paItem){

		global $DEBUG;

		if( is_array( $paItem ) ) {
			$laTop =& $this->getTopPathBar();
			$paItem = array_merge( $laTop, $paItem );

			if($DEBUG){
				echo "PathBar::cloneTop:<br><pre>\n";
				print_r($paItem);
				echo "</pre><hr>\n";
			}

			return $this->pushPathbar( $paItem );
		}
	}

	function &popPathBar( $pcCurPage = NULL){

		$laTop = NULL;

		if( is_array( $this->maPathInfo ) ){

			if( is_string( $pcCurPage ) ) {

				$liCnt = count($this->maPathInfo);
				for( $i=0; $i<$liCnt; $i++ ){
					if($this->maPathInfo[$i][0] == $pcCurPage){
						$laTop = $this->maPathInfo[$i];
						array_splice( $this->maPathInfo, $i);
						break;
					}
				}
			}else{
				$laTop = array_pop( $this->maPathInfo );
			}
		}
		return $laTop;
	}

	function &saveSettings( $pcURL, &$paSettings, $llSafe = FALSE ){
		global $_SESSION, $ServerID;
		global $DEBUG;

		if( !is_array($_SESSION['_users'][$ServerID][$this->mcUser]['settings'][$pcURL])){
			$_SESSION['_users'][$ServerID][$this->mcUser]['settings'][$pcURL] = array();
		}
		$laSettings = $_SESSION['_users'][$ServerID][$this->mcUser]['settings'][$pcURL];

		/*
		if($DEBUG){
			echo "PathBar::saveSettings : url: $pcURL<br><pre>\n";
			print_r($laSettings);
			echo "</pre><hr>\n";
		}
		*/

		if( is_array( $paSettings ) ) {
			if( $llSafe ) {
				$laSettings = array_merge( $laSettings, $paSettings );
			}else{
				$laSettings = $paSettings;
			}
			$_SESSION['_users'][$ServerID][$this->mcUser]['settings'][$pcURL] = $laSettings;
		}				
		return $_SESSION['_users'][$ServerID][$this->mcUser]['settings'][$pcURL];
	}

	function appendSetting( $pcURL, $pcKey, $llSafe = FALSE ){
		global $ServerID;
		if(!is_array($_SESSION['_users'][$ServerID][$this->mcUser]['settings'][$pcURL])){
			$_SESSION['_users'][$ServerID][$this->mcUser]['settings'][$pcURL] = array();
		}

		if( $llSafe ){
			if( array_key_exists( $pcKey, $_SESSION['_users'][$this->mcUser]['settings'][$pcURL]) ){
				return;
			}
		}

		$_SESSION['_users'][$ServerID][$this->mcUser]['settings'][$pcURL][$pcKey] = $GLOBALS[$pcKey];
		
	}

	function removeSettings( $pcURL, $pcKey ){
		global $ServerID;

		if(!is_array($_SESSION['_users'][$ServerID][$this->mcUser]['settings'][$pcURL])){
			$_SESSION['_users'][$ServerID][$this->mcUser]['settings'][$pcURL] = array();
		}

		$laArgs = func_get_args();
		array_shift( $laArgs );
		foreach( $laArgs as $lcKey ){
			unset($_SESSION['_users'][$ServerID][$this->mcUser]['settings'][$pcURL][$lcKey]);
		}
		
	}

	function cleanSettings( $pcURL = NULL ){
		global $ServerID;
		if( is_null( $pcURL ) ){
			unset( $_SESSION['_users'][$ServerID][$this->mcUser]['settings'] );
		} else {
			unset( $_SESSION['_users'][$ServerID][$this->mcUser]['settings'][$pcURL] );
		}
	}

	function &saveRequest( $pcURL, $llSafe = FALSE ){

		global $HTTP_POST_VARS,$HTTP_GET_VARS;

		if( is_array( $_POST ) ){
			return $this->saveSettings( $pcURL, $_POST, $llSafe );

		}elseif( is_array( $HTTP_POST_VARS )){
			return $this->saveSettings( $pcURL, $HTTP_POST_VARS, $llSafe );

		}elseif( is_array( $_GET ) ){
			return $this->saveSettings( $pcURL, $_GET, $llSafe );

		}elseif( is_array( $HTTP_POST_VARS )){
			return $this->saveSettings( $pcURL, $HTTP_GET_VARS, $llSafe );
		}
		return NULL;
	}

	function &getSettings( $pcURL ){
		global $DEBUG;
		global $ServerID;
		if( is_array( $_SESSION['_users'][$ServerID][$this->mcUser]['settings'] ) ) {
			if($DEBUG){
				echo "PathBar::getSettings<br><pre>\n";
				print_r($_SESSION['_users'][$ServerID][$this->mcUser]['settings']);
				echo "</pre><hr>\n";
			}

			if( array_key_exists($pcURL, $_SESSION['_users'][$ServerID][$this->mcUser]['settings'] ) ) {
				return $_SESSION['_users'][$ServerID][$this->mcUser]['settings'][$pcURL];
			}
		}
		return NULL;
	}

	function restoreRequest( $pcURL, $llSafe = FALSE ){

		$laSettings =& $this->getSettings( $pcURL);

		if(is_array($laSettings)){
			foreach($laSettings as $key => $val){
				if( $llSafe ){
					if(array_key_exists($key,$GLOBALS)){
						continue;
					}
				}
				if(!is_array($val)){
					if (get_magic_quotes_gpc()) $val = StripSlashes($val);
				}
				$GLOBALS[$key] = $val;
			}
		}
	}

}
?>