<?
########## Confixx(R) 3.0 Professional ############
####### Copyright SWsoft, Inc. 2004-2005 ##########
#### http://www.sw-soft.com - info@sw-soft.com ####

/*
  -------------------- Name conventions --------------------
  Function names (except methods):

  ff_DescriptionOfFunction


  Constant names:

  cc_DescriptionOfConstant


  Variable names:

  $ST_DescriptionOfVariable

  where S is a scope, T is a type.

  The following scopes should be used:
  g - global
  s - static
  l - local
  m - member of class
  p - parameter

  The following types should be used:
  s - scalar
  a - array
  r - resource
  o - object
  m - mixed

  -------------------- end Name conventions --------------------
*/





include_once( dirname( __FILE__ ) . "/class.SQLType.php" );





class SQLInteger extends SQLType
{

	/* -------------------- Members -------------------- */
	/* -------------------- end Members -------------------- */





	/* -------------------- Constructor -------------------- */
	function SQLInteger( $ps_Value ){
		if( is_bool( $ps_Value ) ) { /* convert bool -> int */
			$ps_Value = $ps_Value? 1: 0;			
		}				
		$this->SQLType( $ps_Value );
	}
	/* -------------------- end Constructor -------------------- */





	/* -------------------- definitions of "abstract" methods -------------------- */

	function SetValue( $ps_Value ){
		if( is_bool( $ps_Value ) ) { /* convert bool -> int */
			$ps_Value = $ps_Value? 1: 0;			
		}	
		parent::SetValue( $ps_Value );	
	}
	
	function Validate()
	{
		$liValue = $this->GetValue();
		if( is_numeric( $liValue ) || !$liValue )
			return TRUE;
		$this->SetError ( ltext("sqltype_bad_number") );
		return FALSE;
	}

	function SQL()
	{
		return (int)$this->GetValue();
	}
	/* -------------------- end definitions "abstract" methods -------------------- */

	function &getClone(){
		return new SQlInteger( $this );
	}

}
?>
