<?
/*
  -------------------- Name conventions --------------------
  Function names (except methods):

  ff_DescriptionOfFunction


  Constant names:

  cc_DescriptionOfConstant


  Variable names:

  $ST_DescriptionOfVariable

  where S is a scope, T is a type.

  The following scopes should be used:
  g - global
  s - static
  l - local
  m - member of class
  p - parameter

  The following types should be used:
  s - scalar
  a - array
  r - resource
  o - object
  m - mixed

  -------------------- end Name conventions --------------------
*/





include_once ( dirname(__FILE__) . "/module.Database.php" );





class Suid
{
    /* -------------------- RunUtility -------------------- */
    function RunUtility ( $ps_Path, &$pa_Output, $pa_Arguments )
    {
	array_shift ( $pa_Arguments );
	exec ( dirname(__FILE__)."/../../sbin/$ps_Path ".call_user_func_array( array( new Suid(), "GetArguments" ),
	    $pa_Arguments )." 2>&1" , $pa_Output, $ls_Result );
	return !$ls_Result;
    }
    /* -------------------- end RunUtility -------------------- */





    /* -------------------- CreateDirectories -------------------- */
    function CreateDirectories ( &$pa_Output, $ps_First )
    {
	$la_Arguments = func_get_args();
	return Suid::RunUtility ( "util_mkdir.pl", $pa_Output, $la_Arguments );
    }
    /* -------------------- end CreateDirectories -------------------- */





    /* -------------------- CopyFiles -------------------- */
    function CopyFiles ( &$pa_Output, $ps_First, $ps_Second )
    {
	$la_Arguments = func_get_args();
	return Suid::RunUtility ( "util_copy.pl", $pa_Output, $la_Arguments );
    }
    /* -------------------- end CopyFiles -------------------- */





    /* -------------------- UnTar -------------------- */
    function UnTar ( &$pa_Output, $ps_First, $ps_Second )
    {
      global $ServerID;
	$la_Arguments = func_get_args();
	$lo_DB =& get_db_connection();
	$lo_Query =& $lo_DB->Select ( "SELECT path FROM bin WHERE server_id='$ServerID' AND name = 'tar'" );
	if ( $la_Data =& $lo_Query->nextrow() )
	{
	    array_splice ( $la_Arguments, 1, 0, array( $la_Data['path'] ) );
	    return Suid::RunUtility ( "util_untgz.pl", $pa_Output, $la_Arguments );
	}
	else
	{
	    $pa_Output[] = ltext ( "suid_no_tar" );
	    return FALSE;
	}
    }
    /* -------------------- end UnTar -------------------- */





    /* -------------------- UnZip -------------------- */
    function UnZip ( &$pa_Output, $ps_First, $ps_Second )
    {
      global $ServerID;
	$la_Arguments = func_get_args();
	$lo_DB =& get_db_connection();
	$lo_Query =& $lo_DB->Select ( "SELECT path FROM bin WHERE server_id='$ServerID' AND name = 'unzip'" );
	if ( $la_Data =& $lo_Query->nextrow() )
	{
	    array_splice ( $la_Arguments, 1, 0, array( $la_Data['path'] ) );
	    return Suid::RunUtility ( "util_unzip.pl", $pa_Output, $la_Arguments );
	}
	else
	{
	    $pa_Output[] = ltext ( "suid_no_unzip" );
	    return FALSE;
	}
    }
    /* -------------------- end UnZip -------------------- */





    /* -------------------- GetArguments -------------------- */
    function GetArguments()
    {
	$ls_Result = "";
	foreach ( func_get_args() as $ls_Value )
	    $ls_Result .= ' '.escapeshellarg($ls_Value).' ';
	return $ls_Result;
    }
    /* -------------------- end GetArguments -------------------- */
}
?>
