<?

include_once( 'class.SQLFieldSet.php' );
include_once( 'db/class.DBConnect.php' );
include_once( 'class.MysqlPermissions.php' ); 

class UserMysql{
	var $mcUser;
	var $mcReseller;
	var $mcServerID;
	var $mcPassword;
	var $miDbCount;
	var $mcError;
	
	function UserMysql( $pcUser, $pcServerID = NULL ){
		global $ServerID;
		if( is_string( $pcServerID ) ){
			$this->mcServerID = $pcServerID;
		}else{
			$this->mcServerID = $ServerID;
		}
		$this->User( $pcUser );
	}

	//
	// member functions
	//

	function &User( $pcUser = NULL ){
		if( is_string( $pcUser ) ){
			$this->mcUser = $pcUser;
		}
		return $this->mcUser;
	}

	function &Reseller( $pcReseller = NULL ){
		if( is_string( $pcReseller ) ){
			$this->mcReseller = $pcReseller;
		}
		return $this->mcReseller;
	}

	function &ServerID( $pcServerID = NULL ){
		if( is_string( $ServerID ) ){
			$this->mcServerID = $pcServerID;
		}
		return $this->mcServerID;
	}

	function &Password( $pcPassword = NULL ){
		if( is_string( $pcPassword ) ){
			$this->mcPassword = $pcPassword;
		}
		return $this->mcPassword;
	}

	function &getError(){
		return $this->mcError;
	}

	function &getDbCount(){
		return $this->miDbCount;
	}

	//
	// end member functions
	//

	
	function canCreateOne( $pcUser = NULL, $pcServerID = NULL ){
		$this->User( $pcUser );
		$this->ServerID( $pcServerID );
		
		$loFS = new SQLFieldSet( array( 'kunde'=>array( $this->mcUser, 'C' ),
																	  'server_id'=>array( $this->mcServerID, 'C' )
																		)
														 );

		$lcWhere = $loFS->getSQLWhere();

		$id = db_query( "SELECT maxmysql,anbieter FROM kunden WHERE ".$lcWhere );
		list( $liMax, $this->mcReseller ) = db_fetch_array( $id, 'N' );
		db_free_query( $id );

		$id = db_query( "SELECT COUNT(datenbank) FROM mysql_datenbanken WHERE ".$lcWhere );
		list( $this->miDbCount ) = db_fetch_array( $id, 'N' );
		db_free_query( $id );

		return ( $this->miDbCount < $liMax || $liMax == -1 );
	}
	
	function checkPassword( $pcPassword = NULL ){
		$this->Password( $pcPassword );
		$loConn =& getUserDbConnect();	
		if( ! $loConn->ConnectionID() ){
			$this->mcError = ltext( 'usmsql_error_conn' );
			return NULL;
		}
		$loPass = new SQLValue( $this->mcPassword, 'C' );
		$loUser	= new SQLField( 'user', $this->mcUser, 'C' );	
		$lcSQL = "SELECT COUNT(user) FROM user WHERE ".$loUser->getSQLWhere().
			" AND password <> password(".$loPass->getSQLValue().")";
		$id = userdb_query( $lcSQL );
		list( $liCnt ) = mysql_fetch_row( $id );
		mysql_free_result( $id );
		
		return ($liCnt == 0);
	}

	function createDB( $pcDbName, $pcPassword = NULL ){
		global $mysql_host, $mysql_user_version;

		if( ! preg_match('/^usr_'.$this->mcUser.'_\d+$/', $pcDbName ) ){
			$this->mcError = ltext( 'usmsql_error_dbanme', $pcDbName );
			return NULL;
		}

		$loConn =& getUserDbConnect();	
		if( ! $loConn->ConnectionID() ){
			$this->mcError = ltext( 'usmsql_error_conn' );
			return NULL;
		}

		if( ! $mysql_host  ){
			$mysql_host = 'localhost';
		}

		$loDefDbPrivs = new MysqlDbPermissions( false, $mysql_user_version );
		$loDefUserPrivs = new MysqlUserPermissions( false, $mysql_user_version );

		$loDefDbPrivs->check();
		$loDefUserPrivs->check();


		$loFS = new SQLFieldSet( array( 'user' => array($this->mcUser,'C'),
																		'host' => array('localhost','C')
																		)
														 );
		$loHost =& $loFS->Field(1);

		$laHosts = array_keys( array( $mysql_host => 1,
																	'127.0.0.1' => 1,
																	'localhost' => 1 ) );

		if( ! $this->miDbCount ){

			$this->Password( $pcPassword );

			if( ! $this->mcPassword ){
				$this->mcPassword = mkpasswd(8);
			}
			$loPasswd = new SQLValue( $this->mcPassword, 'P' );

			foreach( $laHosts as $lcHost ){
				$loHost->Value( $lcHost );
				$lcWhere = $loFS->getSQLWhere();
				$id = userdb_query( "SELECT COUNT(user) FROM user WHERE ".$lcWhere );
				list( $liCnt ) = mysql_fetch_row( $id );
				mysql_free_result( $id );
				if( $liCnt ){
					$lcSql = "UPDATE user SET ".$loPasswd->getSQLUpdate().",". 
						$loDefUserPrivs->getSqlUpdates()." WHERE $lcWhere";
				}else{
					list($lcFlds,$lcVals) = $loFS->getSQLInsert();
					$lcSql = "INSERT INTO user (password,$lcFlds,".$loDefUserPrivs->getSqlFields().
						") VALUES ( ".$loPasswd->getSQLValue().",$lcVals,".$loDefUserPrivs->getSqlValues().")";

				}
				userdb_query( $lcSql );
			}
		}
		$lcDbNameExp = str_replace('_', "\\_", $pcDbName );
		$loFS->addField( 'db', $lcDbNameExp, 'C' );

		foreach( $laHosts as $lcHost ){
			$loHost->Value( $lcHost );
			$lcWhere = $loFS->getSQLWhere();
			
			$id = userdb_query( "SELECT COUNT(db) FROM db WHERE ".$lcWhere );
			list( $liCnt ) = mysql_fetch_row( $id );
			mysql_free_result( $id );
			
			if( $liCnt ){
				$lcSql = "UPDATE db SET ".$loDefDbPrivs->getSqlUpdates().' WHERE '.$lcWhere;
			}else{
				list($lcFlds,$lcVals) = $loFS->getSQLInsert();
				$lcSql = "INSERT INTO db ($lcFlds,".$loDefDbPrivs->getSqlFields().
					") VALUES ($lcVals,".$loDefDbPrivs->getSqlValues().")";
			}
			userdb_query( $lcSql );
		}
		userdb_query( "CREATE DATABASE $pcDbName" );
		userdb_query( "FLUSH PRIVILEGES" );

		return $this->mcPassword;
	}

	function registerNewDB( $pcComment = '' ){

		if( ! $this->mcReseller ){
			if( ! $this->canCreateOne() ){
				$this->mcError = ltext( 'dbmyan_error1' );
				return NULL;
			}
		}


		$loFS = new SQLFieldSet( array( 'kunde' => array( $this->mcUser,'C' ), 
																		'server_id' => array( $this->mcServerID, 'C' )
																		)
														 );
			
			
		$lcSql = "SELECT datenbank FROM mysql_datenbanken WHERE ".$loFS->getSQLWhere()." ORDER by datenbank";
		$id = db_query( $lcSql );
		$liPrev = 0;
		while( list( $liId ) = db_fetch_array( $id, 'N' ) ){
			if( $liPrev + 1 != $liId ){
				break;
			}else{
				$liPrev = $liId;
			}
		}
		db_free_query( $id );

		$liIndex = $liPrev + 1;

		$lcDbName = join('_',array('usr',$this->mcUser,$liIndex));

		$loFS->addField( 'anbieter', $this->mcReseller, 'C' );
		$loFS->addField( 'dbname', $lcDbName, 'C' );
		$loFS->addField( 'datenbank', $liIndex );
		$loFS->addField( 'kommentar', $pcComment, 'C' );

		list($lcFlds, $lcVals)= $loFS->getSQLInsert();
		$lcSql = "INSERT INTO mysql_datenbanken ($lcFlds) VALUES ($lcVals)";
		db_query( $lcSql );

		return $lcDbName;
	}

}
?>