<?
include_once( 'class.CompoundDBValue.php');

class DataRowsDBValue extends CompoundDBValue {

	var $moSetOfRowsData;
	
	/*
	 * constructor
	 */
	function DataRowsDBValue( $poSQLQuery, $piSize = NULL, $piStart = NULL ) {
		$this->CompoundDBValue( $poSQLQuery, $piSize, $piStart );
		$this->moSetOfRowsData = new SetOfRowsData();
	}
	/*
	 *
	 */


	/*
	 * properties
	 */

	function &Template( $poTemplate = NULL ) {
		global $DEBUG;
		/*
		if( $DEBUG ){
			echo "DataRowsDBValue::Template: <br><pre>\n";
			print_r(func_get_args());
			echo "</pre><hr>\n";
		}
		*/
		if ( is_array( $poTemplate ) ) {
			$this->setTemplate( $poTemplate );
			
		} elseif( is_a( $poTemplate, 'DataRow' ) || 
							is_a( $poTemplate, 'DataField' ) || 
							is_a( $poTemplate, 'OneValueDataField' ) ) {
			$this->setTemplate( func_get_args() );
		}
		return parent::Template();
	}

	function &SetOfRowsData( $poSetOfRows = NULL ) {
		if( is_a( $poSetOfRows, 'SetOfRowsData' ) ){
			$this->moSetOfRowsData = $poSetOfRows;
		}
		return $this->moSetOfRowsData;
	}

	/*
	 * end properties
	 */


	/*
	 * set/get methods
	 */
	function &getSetOfRowsData() {
		return $this->moSetOfRowsData;
	}

	function setTemplate( $poData ) {
		global $DEBUG;
		/*
		if( $DEBUG ){
			echo "DataRowsDBValue::setTemplate: <br><pre>\n";
			print_r(func_get_args());
			echo "</pre><hr>\n";
		}
		*/
		if( is_a( $poData, 'DataRow' )){
			$this->moTemplate = $poData;
		} else {
			if( !is_array( $poData ) ) {
				$poData = func_get_args();
			}	
			$this->moTemplate = new DataRow();
			call_user_func_array( array( &$this->moTemplate, "AppendFields" ), $poData );
		}
		return $this->moTemplate;
	}

	/*
	 * end set/get methods
	 */

	function doQuery(){
		global $DEBUG;
		$loID = $this->moQuery->doQuery();
		if( $loID ){
			$this->clean();
			if( !is_array( $this->maFields ) ) {
				$this->maFields = $this->moQuery->getFieldNames();
			}
			if( is_a( $this->moTemplate, 'CompoundValue') ) {
				$llHasTemplate = TRUE;
				$loIter = $this->moTemplate->getTreeIterator();
				$laFields = array();
				while ( $loItem =& $loIter->getNext() ){
					$laFields[] = $loItem->Key();
				}
			} else {
				$laFields =& $this->maFields;
			}
			$llHasTemplate = is_a( $this->moTemplate, 'DataRow' );
			while ( $row = $this->moQuery->fetchArray( 'A' ) ) {
				if( $llHasTemplate ){
					$loRow =& $this->moTemplate->getClone();
					$loRow->SetFromArray( $row );
				} else {
					$loRow = new DataRow();
					foreach ( $laFields as $lcFieldName ) {
						$loRow->AppendFields( new TextDataField( $row[$lcFieldName], $lcFieldName ) );
					}
				}
				$this->moSetOfRowsData->AppendRow( $loRow );
			}
			$this->moQuery->freeResult();

			return $this->moSetOfRowsData->CountRows();

		} else {
			return NULL;
		}
	}
}
?>