<?
include_once("class.ValueFromArray.php");

class DataValue extends ValueFromArray {
	
	var $moDataField;
	var $mcTypeOfPresentation;

	function DataValue( $pcKey, $puValue = NULL, 
											$poDataField = NULL, $pcTypeOfPresentation = 'output' ) {
		if( is_a( $puValue, 'DataField' ) ) {
			$poDataField = $puValue;
			$puValue = NULL;
		}
		$this->ValueFromArray( $pcKey, $puValue );
		$loDataField =& $this->setDataField( $poDataField );
		if( !$this->getDataName() ) {
			$this->setDataName( $this->Key() );
		}
		if( !$this->getDataValue() ) {
			$this->setDataValue( $this->Value() );
		}
		$this->setTypeOfPresentation( $pcTypeOfPresentation );
	}

	function &TypeOfPresentation( $pcType=NULL ){
		if(is_string($pcType)){
			$this->setTypeOfPresentation($pcType);
		}
		return $this->getTypeOfPresentation();
	}

	function &setTypeOfPresentation( $pcType ){
		$pcType = strtolower( $pcType );
		switch($pcType){
		case 'input':
		case 'in':
		case 'i':
			$this->mcTypeOfPresentation = 'Input';
			break;
		case 'hidden':
		case 'hid':
		case 'h':
			$this->mcTypeOfPresentation = 'Hidden';
			break;
		case 'output':
		case 'out':
		case 'o':
		default:
			$this->mcTypeOfPresentation = 'Output';
		}
		return $this->mcTypeOfPresentation;
	}

	function &getTypeOfPresentation(){
		return $this->mcTypeOfPresentation;
	}

	function getPresentation( $pc_ID = NULL ){
		$lcMethod = 'Get'.$this->getTypeOfPresentation().'Presentation';
		if ( $loDataField =& $this->getDataField() ) {
			if(method_exists($loDataField,$lcMethod)){
				return call_user_func( array( &$loDataField, $lcMethod ), $pc_ID );
			}
		}
		return new HTMLElement( $this->Value() );
	}

	function &getParentAttributes(){
		if ( $loDataField =& $this->getDataField() ) {
			return $loDataField->GetParentAttributes();
		}	else {
			return array();
		}
	}

	function &DataField( $poDataField = NULL ){
		if( is_object( $poDataField ) ) {
 			$this->setDataField( $poDataField );
		}
		return $this->getDataField();
	}

	function &setDataField( &$poDataField ){
		if(is_a($poDataField,'DataField')){
			$this->moDataField =& $poDataField;
		}
		return $this->moDataField;
	}

	function &getDataField(){
		return $this->moDataField;
	}

	function setDataName( $pcName ){
		if( $loDataField =& $this->getDataField() ) {
			if( method_exists( $loDataField, 'SetName' ) ) {
				return $loDataField->SetName( $pcName );
			}
		}
		return NULL;
	}

	function getDataName(){
		if( $loDataField =& $this->getDataField() ) {
			if( method_exists( $loDataField, 'GetName' ) ) {
				return $loDataField->GetName();
			}
		}
		return NULL;
	}


	function setDataValue( $puValue ){
		if( $loDataField =& $this->getDataField() ) {


			if( method_exists( $loDataField, 'SetValue' ) ) {

				//				echo "DataValue::setDataValue : SetValue( $puValue ) <br>\n";

				$loDataField->SetValue( $puValue );

			} elseif(is_a( $loDataField, 'CompoundDataField' ) ) {

				//				echo "DataValue::setDataValue : CompoundDataField <br>\n";

				foreach ( $loDataField->GetContent() as $loData ) {
					if( method_exists( $loData, 'SetValue' ) ) {
						$loData->SetValue( $puValue );
					}
				}
			}

			/*
			echo "<pre>\n";
			print_r($loDataField);
			echo "</pre><hr>\n";
			*/

		}
		return NULL;
	}

	function getDataValue(){
		if( $loDataField =& $this->getDataField() ) {
			if( method_exists( $loDataField, 'GetValue' ) ) {
				return $loDataField->GetValue();
			}
		}
		return NULL;
	}

	function setValue( $puSrc ){

		//		echo "DataValue::setValue( $puSrc )<br>\n";

		parent::setValue( $puSrc );
		$this->setDataValue( $this->getValue());
	}

	function setFromArray( &$paSource ){
		parent::setFromArray( $paSource );
		if( $loDataField =& $this->getDataField() ) {
			if( method_exists( $loDataField, 'SetFromArray' ) ) {
				$loDataField->SetFromArray( $paSource );
			}
		}
		$this->setDataValue( $this->getValue());
		return TRUE;
	}

}
?>