<?
include_once( 'class.SQLFieldSet.php' );

class SQLQuery {

	var $msQuery;
	var $maParams;
	var $miStart;
	var $miSize;
	var $moResulID;
	var $miRowIndex;
	var $miRowCount;
	
	function SQLQuery( $psQuery, $paParams = NULL, $piSize = NULL, $piStart = NULL ) {

		global $DEBUG;

		$this->msQuery = '';
		$this->maParams = array();
		$this->miStart = -1;
		$this->miSize = -1;
	
		
		if( is_a( $psQuery, 'SQLQuery' ) ){
#
# copy sonstructor
#		
			$this->copyFrom( $psQuery );

			$this->Parameters( $paParams );

			$this->Size( $piSize );
			$this->Start( $piStart );

		} else {
			$this->Query( $psQuery );
		
#
# new SQLQuery ("SELECT * FROM table WHERE fld1=?",array(new SQLValue(1)),0,10);
#
			if( is_array( $paParams ) ) {
				/*
				if($DEBUG){
					echo "SQLQuery::SQLQuery (array)<br><pre>\n";
					print_r($paParams);
					echo "</pre><hr>\n";
				}
				*/
				$this->Parameters( $paParams );
				$this->Start( $piStart );
				$this->Size( $piSize );

#
# new SQLQuery ("SELECT * FROM table WHERE fld1=?",new SQLValue(1));
#
			} elseif( !is_null( $paParams ) ) {
				$laArgs = func_get_args();
				array_shift( $laArgs );
				$this->Parameters( $laArgs );
			}
		}
	}

	function &Start( $piStart = NULL ) {
		if( is_numeric( $piStart ) ) {
			$this->miStart = $piStart;
		}
		return $this->miStart;
	}

	function getNextStart(){
		return $this->Start() + $this->Size();
	}


	function &Size( $piSize = NULL ) {
		global $DEBUG;
		if( is_numeric( $piSize ) ) {
			$this->miSize = $piSize;
		}
		return $this->miSize;
	}


	function &Query( $psQuery = NULL ) {
		global $DEBUG;
		if( is_string( $psQuery ) ) {
			$this->msQuery = $psQuery;
		}
		return $this->msQuery;
	}

	function &SQL( $psSQL = NULL ){ /* alias of Query*/
		return $this->Query( $psSQL );
	}

	function &Parameters( $paParams = NULL ) {
		global $DEBUG;
		if( is_array( $paParams ) ) {
			$this->maParams = $paParams;
		}
		/*
		if( $DEBUG ) {
			echo "SQLQuery::Parameters: (argument)<br><pre>\n";
			print_r( $paParams );
			echo "</pre><hr>(object)<pre>\n";
			print_r( $this );
			echo "</pre><hr>\n";
		}
		*/
		return $this->maParams;
	}

	function addParameter( &$poParam ){
		if(is_a( $poParam, 'SQLValue' ) ) {
			$this->maParams[] = $poParam;
		}		
	}

	function &Parameter( $piInd, $poParam = NULL ){
		if(is_numeric($piInd)){
			if(is_a( $poParam, 'SQLValue' ) ) {
				$this->maParams[$piInd] = $poParam;
				return $this->maParams[$piInd];
			}else{
				if($piInd>=0 && $piInd < count($this->maParams)){
					return $this->maParams[$piInd];
				}
			}
		}
		return NULL;

	}

	function copyFrom( $poSrc ){
		global $DEBUG;
		if( is_a( $poSrc, 'SQLQuery' ) ){
			$this->Query( $poSrc->Query());
			$this->Parameters( $poSrc->Parameters() );
			$this->Start( $poSrc->Start() );
			$this->Size( $poSrc->Size() );
		}
	}

	function &getClone() {
		return new SQLQuery( $this );
	}

	function getSQL( $paParams = NULL, $piSize = NULL, $piStart = NULL ) {

		global $DEBUG;

		if( !is_array( $paParams ) ) {
			$paParams = $this->maParams;
		}
		if( !is_numeric( $piStart ) ) {
			$piStart = $this->miStart;
		}
		if( !is_numeric( $piSize ) ) {
			$piSize = $this->miSize;
		}
		$laVals= array();
		foreach( array_values($paParams) as $loPrm ) {
			
			if( is_a( $loPrm, 'SQLValue' ) ) {
				$laVals[] = $loPrm->getSQLValue();

			} elseif( is_a( $loPrm, 'SQLType' ) ) {
				$laVals[] = $loPrm->SQL();

			} else {
				$laVals[] = $loPrm;
			}
		}

		$lsQuery = $this->Query();

		$lsResult = '' ;
		while( ( $liInd = strpos( $lsQuery, '?' ) ) !== FALSE ) {
			$lsResult .= substr( $lsQuery, 0, $liInd );
			$lsQuery = substr( $lsQuery, $liInd+1 );
			if ( count( $laVals ) ) {
				$lsVal = array_shift( $laVals );
			} else {
				$lsVal = '';
			}
			$lsResult .= $lsVal;
		}
		$lsResult .= $lsQuery;
		if( $piSize > 0 ){
			$lsResult .= $this->getLimit( $piSize, $piStart );
		} else {
			$this->Start( 0 );
		}

		return $lsResult;
	}

	function getLimit( $piSize = NULL, $piStart = NULL ) {
		global $db_type;
		if( is_numeric( $piSize ) ) {
			$piSize = $this->miSize;
		}
		if( is_numeric( $piStart ) ) {
			$piStart = $this->miStart;
		}

		$lsResult = '';

		if( $db_type == 'mysql' ) {
			if ( $piSize > 0 ) {
				$lsResult .= $piSize;
				if( $piStart >= 0 ) {
					$lsResult = $piStart.','.$lsResult;
				} else {

					$piStart =  0;
				}
				$lsResult = ' LIMIT '.$lsResult;
			} else {
				$piStart = 0;
			}
			
		} else {
			if ( $piSize > 0 ) {
				$lsResult .= ' LIMIT '.$piSize;
			}
			if( $piStart >= 0 ) {
				$lsResult .= ' OFFSET '.$piStart;
			} else {
				$piStart = 0;
			}
		}
		$this->Start( $piStart );
		return $lsResult;
	}

	function &doQuery( $paParams=NULL, $piSize = NULL, $piStart = NULL ){
		global $DEBUG;

		$lcSQL = $this->getSQL( $paParams, $piSize, $piStart );

		if($DEBUG){
			echo "SQLQuery::doQuery: $lcSQL<br>\n";
		}


		$this->moResultID = db_query( $lcSQL );

		/*		
		if($DEBUG){
			echo "SQLQuery::doQuery: $lcSQL<br><pre>\n";
			print_r( $this->moResultID );
			echo "</pre><hr>\n";
		}
		*/

		$this->miRowCount =  $this->getRowCount();

		$this->miRowIndex = 0;
		return $this->moResultID;
	}

	function &fetchArray( $lcType = 'B' ) {
		global $db_type;
		if( $this->moResultID ) {
			if($db_type == 'Pg'){
				if($this->miRowIndex>=0 && $this->miRowIndex<$this->miRowCount){
					switch( $lcType ){
					case 'A':
						$array = pg_fetch_array( $this->moResultID, $this->miRowIndex, PGSQL_ASSOC );
						break;
					case 'N':
						$array = pg_fetch_array( $this->moResultID, $this->miRowIndex, PGSQL_NUM );
						break;
					default:
						$array = pg_fetch_array( $this->moResultID, $this->miRowIndex);
					}
				} else {
					$array = NULL;
				}
			} else {
				switch( $lcType ) {
				case 'A':
					$array = mysql_fetch_array( $this->moResultID, MYSQL_ASSOC );
					break;
				case 'N':
					$array = mysql_fetch_array( $this->moResultID, MYSQL_NUM );
					break;
				default:
					$array = mysql_fetch_array( $this->moResultID );
				}
			}
			if( $array ){
				$this->miRowIndex++;
			}
			return $array;

		} else {
			return NULL;
		}
	}

	function freeResult(){
		global $db_type;
		if( $this->moResultID ) {
			db_free_query( $this->moResultID );
			$this->moResultID = NULL;
		}
	}

	function finish(){
		$this->freeResult();
	}

	function getFieldCount(){
		global $db_type;
		if( $this->moResultID ) {
			if($db_type == 'Pg'){
				return pg_num_fields( $this->moResultID );
			} else {
				return mysql_num_fields( $this->moResultID );
			}
		} else {
			return 0;
		}
	}

	function getRowCount(){
		global $db_type;
		if( $this->moResultID ) {
			if($db_type == 'Pg'){
				return pg_num_rows( $this->moResultID );
			} else {
				return mysql_num_rows( $this->moResultID );
			}
		} else {
			return 0;
		}
	}


	function getFieldNames(){
		global $db_type;
		if( $this->moResultID ) {
			$laRet = array();
			$liCount = $this->getFieldCount();
			for( $i=0; $i<$liCount; $i++ ) {
				if( $db_type == 'Pg' ) {
					$laRet[$i] = pg_field_name( $this->moResultID, $i );
				} else {
					$laRet[$i] = mysql_field_name( $this->moResultID, $i );
				}
			}
			return $laRet;
		} else {
			return NULL;
		}
	}
}
?>
