<?
/*
  -------------------- Name conventions --------------------
  Function names (except methods):

  ff_DescriptionOfFunction


  Constant names:

  cc_DescriptionOfConstant


  Variable names:

  $ST_DescriptionOfVariable

  where S is a scope, T is a type.

  The following scopes should be used:
  g - global
  s - static
  l - local
  m - member of class
  p - parameter

  The following types should be used:
  s - scalar
  a - array
  r - resource
  o - object
  m - mixed

  -------------------- end Name conventions --------------------
*/





include_once( dirname(__FILE__) . "/class.DataField.php" );
include_once( dirname(__FILE__) . "/class.LinkDataField.php" );
include_once( dirname(__FILE__) . "/../html/class.ButtonURLElement.php" );
include_once( dirname(__FILE__) . "/../html/class.HTMLElement.php" );





class ButtonURLData extends DataField {

	/* -------------------- Members -------------------- */
	var $ms_Label; // label on button
	var $mo_Link; // LinkDataField - object
	var $ms_ID; // ID of button
	/* -------------------- end Members -------------------- */





	/* -------------------- Constructor -------------------- */
	function ButtonURLData( $ps_Label, $pm_Link, $ps_ID=NULL ) {
		$this->DataField();
		$this->SetLabel($ps_Label);
		$this->SetLink($pm_Link);
		$this->SetID( $ps_ID );
	}
	/* -------------------- end Constructor -------------------- */





	/* -------------------- Set.../Get... -------------------- */
	function SetLabel( $ps_Label ) {
		$this->ms_Label = $ps_Label;
	}

	function GetLabel() {
		return $this->ms_Label;
	}

	function SetLink( $pm_Link ) {
		if(is_object($pm_Link))	{
			$this->mo_Link = $pm_Link;
		}else{
			$this->mo_Link = new LinkDataField($pm_Link);
		}	
	}

	function &GetLink() {
		return $this->mo_Link;
	}

	function GetURL(){
		$lo_Link =& $this->GetLink();
		return $lo_Link->GetHREF();
	}


	function SetID( $ps_ID ) {
		$this->ms_ID = $ps_ID;
	}

	function GetID() {
		return $this->ms_ID;
	}
	/* -------------------- end Set.../Get... -------------------- */





	/* -------------------- "abstract" methods -------------------- */
	function SetFromArray($pa_values){
	}
	
	function GetInputPresentation() {
		return new ButtonURLElement( $this->GetLabel(), $this->GetURL(), $this->GetID() );
	}

	function GetOutputPresentation() {
		return new ButtonURLElement( $this->GetLabel(), $this->GetURL(), $this->GetID() );
	}

	function GetHiddenPresentation() {
		return new HTMLElement( "" );
	}
	/* -------------------- end "abstract" methods -------------------- */

}
?>
