<?
/*
  -------------------- Name conventions --------------------
  Function names (except methods):

  ff_DescriptionOfFunction


  Constant names:

  cc_DescriptionOfConstant


  Variable names:

  $ST_DescriptionOfVariable

  where S is a scope, T is a type.

  The following scopes should be used:
  g - global
  s - static
  l - local
  m - member of class
  p - parameter

  The following types should be used:
  s - scalar
  a - array
  r - resource
  o - object
  m - mixed

  -------------------- end Name conventions --------------------
*/

include_once(dirname(__FILE__) . '/../html/class.TagWithEndElement.php');


class Data {

	var $maParentTags;

	/* -------------------- Constructor -------------------- */
	function Data() {
		
	}
	/* -------------------- end Constructor -------------------- */

	function &SetPaternTags( &$paTagsArray ){
		if(is_array($paTagsArray)){
			$this->maParentTags = $maParentTags;
		}
		return $this->maParentTags;
	}

	function &AddParentTag( $pcTag, $paAttributes = array()){
		if(!is_array($this->maParentTags)){
			$this->maParentTags = array();
		}
		$this->maParentTags[$pcTag] = $paAttributes;
	}

	function &GetParentTags(){
		return $this->maParentTags;
	}

	function &WrapParentTags( &$poHtml ){
		$loRet =& $poHtml;
		$laTagsInfo =& $this->GetParentTags();
		if( is_array( $laTagsInfo ) ) {
			$laTags = array_reverse(array_keys($laTagsInfo));
			foreach( $laTags as $lcTag  ){
				if( is_string( $lcTag ) ) {
					$laAttributes = is_array($laTagsInfo[$lcTag])? $laTagsInfo[$lcTag]: array();
					$loRet = new TagWithEndElement( $lcTag, $laAttributes, $loRet);
				}
			}
		} 
		return $loRet;
	}


	/* -------------------- "abstract" methods -------------------- */
	function GetInputPresentation() {
		echo( "Method GetInputPresentation should return object!" );
	}

	function GetOutputPresentation() {
		echo( "Method GetOutputPresentation should return object!" );
	}

	function GetHiddenPresentation() {
		echo( "Method GetHiddenPresentation should return object!" );
	}

	function GetListPresentation() {
		// don't use this method, use PagedSetOfRowsData class to implement lists
		return $this->GetInputPresentation();
	}

	function GetTreePresentation() {
		return $this->GetInputPresentation();
	}
	/* -------------------- end "abstract" methods -------------------- */

}
?>
